<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'country-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    'htmlOptions' => array('enctype' => 'multipart/form-data'), // Important for file uploads
    
));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">

            <li class="col-sm-4">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textField($model, 'country_name', array('data-label' => 'Country Name *', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'country_name'); ?>
            </li>

            <li class="col-sm-4">
                <?php echo $form->textField($model, 'country_code', array('data-label' => 'Country Code *', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'country_code'); ?>
            </li>

            <li class="col-sm-4">
                <?php echo $form->textField($model, 'nationality', array('data-label' => 'Nationality *', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'nationality'); ?>
            </li>

            <li class="col-sm-4">
                <?php echo $form->dropDownList($model, 'isDefault', array('N' => 'No', 'Y' => 'Yes'), array('data-label' => 'Is Default?')); ?>
                <?php echo $form->error($model, 'isDefault'); ?>
            </li>

            <li class="col-sm-4">
    <?php echo $form->textField($model, 'phone_code', array(
        'data-label' => 'Phone Code *',
        'data-validation' => 'required',
        // 'placeholder' => '+91',
        'onkeyup' => 'isValidPhoneCountryCode(this.value)'
    )); ?>
    <?php echo $form->error($model, 'phone_code'); ?>
    <span class="help-block text-muted" style="font-size: 12px;">For eg: +971</span>
</li>


<li class="col-sm-4">  
    <?php
    echo $form->labelEx($model, 'Flag Image');
    $allowedExtensions = array("png", "jpg", "jpeg", "gif");
    $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
        'id' => rand(),
        'config' => array(
            'action' => Yii::app()->createUrl(Yii::app()->controller->id . '/UploadProfilePhoto', array('folder' => 'uploads/flags')),
            'multiple' => false,
            'allowedExtensions' => $allowedExtensions,
            'sizeLimit' => 1 * 1024 * 1024,
            'onStart' => "js:function(){}",
            'class' => 'pull-right',
            'onComplete' => "js:function(id, fileName, responseJSON){ 
                $('.flag_preview').html(
                    '<div class=\"each_image\">' +
                        '<input type=\"hidden\" value=\"'+responseJSON.filename+'\" name=\"MasCountry[flag_image]\">' +
                        '<img width=\"60\" height=\"40\" src=\"" . Yii::app()->baseUrl . "/uploads/flags/'+responseJSON.filename+'\" />' +
                    '</div>'
                );
            }"
        )
    ));
    ?>     
<div class="flag_preview">        
    <?php if (!empty($model->flag_image)): ?>   
        <div class="each_image">  
            <input type="hidden" name="MasCountry[flag_image]" value="<?php echo CHtml::encode($model->flag_image); ?>">    
            <img src="<?php echo Yii::app()->baseUrl . '/uploads/flags/' . CHtml::encode($model->flag_image); ?>" width="60" height="40" style="object-fit: cover; border: 1px solid #ccc;" />  
        </div>                                
    <?php endif; ?>            
</div>
                    

    <?php echo $form->error($model, 'flag_image'); ?>           
</li>




        </ul>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('Country/SaveCountry');
    echo CHtml::ajaxSubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            $("#loader").hide();
            if(data.status=="success"){  
                t8.success("Country Saved Successfully!");
                $(".x.close").click();
                reloadTable("#tbl_country_details");
            } else { 
                $("#country-form .country-save-btn").prop("disabled", false);                      
                $("#country-form .country-save-btn").addClass("btn-theme").removeClass("btn_loding"); 
                $.each(data, function(key, val) {
                    $("#country-form #"+key+"_em_").text(val).show(); 
                    t8.error(""+val+""); 
                }); 
            } 
        }',
        'beforeSend' => 'function(){
            $("#loader").show();
            $("#country-form .country-save-btn").prop("disabled", true);                      
            $("#country-form .country-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
            $(".toast8-error").hide(); 
        }'
    ), array('id' => 'mybtn' . rand(), 'class' => 'country-save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); ?>

<script>
function isValidPhoneCountryCode(code) {
    if (!/^\+\d+$/.test(code)) {
        // Optionally show visual feedback or logging
        console.warn("Invalid phone code format");
        return false;
    }
    return true;
}
</script>

