<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'bank-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textField($model, 'bank_name', array('data-label' => 'Bank Name *')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'bank_code', array('data-label' => 'Bank Code *')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'routing_code', array('data-label' => 'Routing Code *')); ?>
            </li>
            <li class="col-sm-3">

                <?php echo $form->dropdownList($model, 'isDefault',array('N'=>'No','Y'=>'Yes'),array('data-label'=>'Want to make it as default?')); ?>

                <?php echo $form->error($model,'isDefault'); ?>
                </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-default " id="bank_close" data-dismiss="modal">Close</button>
<?php
$url = Yii::app()->createUrl('/Bank/SaveBank');
echo CHtml::ajaxsubmitButton('Save', $url, array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
            $("#loader").hide();
            if(data.status=="success"){  
                 t8.success("Bank Saved Successfully!");
                 $("#bank_close").click();
                reloadTable("#tbl_bank_details");

            } else { 
                $("#bank-form .bank-save-btn").prop("disabled", false);
                $("#bank-form .bank-save-btn").addClass("btn-theme").removeClass("btn_loding");
                $.each(data, function(key, val) {
                        t8.error(""+val+""); 
                }); 
            } 
    }',
    'beforeSend' => 'function(){
                                $("#loader").show();
                                $(".toast8-error").hide(); 
                                $("#bank-form .bank-save-btn").prop("disabled", true);
                                $("#bank-form .bank-save-btn").addClass("btn_loding").removeClass("btn-theme");
                            }'
        ), array('id' => 'mybtn' . rand(), 'class' => 'bank-save-btn btn btn-theme'));
?>


</div>


    <?php $this->endWidget(); ?>










