<?php

    $cs = Yii::app()->getClientScript();
    $cs->registerScript("autoCompleteCustomer", "function autoCompleteCustomer(field_id)
                {
                    $('#Assignments_customer_id').val('');
                    var url = '" . Yii::app()->createUrl('customer/Getcustomer') . "';
                    $('#'+field_id).autocomplete({
                        minLength   : 1,
                        source      : function (request, response) { autoCompleteSource(request, response,url) },
                        focus       : function( event, ui ) {},
                        select      : function( event, ui ) {
                                        event.preventDefault();
                                        trigger_target_id  	=   $(event.target).attr('id');
                                        $('#Assignments_customer_id').val(ui.item.value);
                                        $('#Assignments_customer_name').val(ui.item.label);
                                    }
                        })
                }", CClientScript::POS_HEAD); 
        
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'assignment-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false,
    ));
?>

<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php $model->customer_name = ( $model->isNewRecord ) ? '' :  $model->customerDetails->customer_name ?>
                <?php echo $form->textField($model, 'customer_name',array('data-label'=>'Customer *',  'onkeypress' => 'js:autoCompleteCustomer(this.id)', 'placeholder' => 'Type & Select..')); ?>
                <?php echo $form->hiddenField($model,'customer_id'); ?>
                <?php echo $form->hiddenField($model,'id'); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->dropdownlist($model, 'type', array(1 => 'Meeting', 2 => 'Visit', 3 => 'Followup', 4 => 'Callback' ),array('class' => 'tooltipster', 'data-label' => 'Type')); ?>
            </li>
            <li class="col-sm-2">
                <?php $model->date  = (  $model->isNewRecord ) ? date('d/m/Y') : date('d/m/Y', strtotime($model->date));  ?>
                <?php echo $form->textField($model, 'date',array('class' => 'datepicker', 'data-label'=>'Date *')); ?>
            </li>
            <li class="col-sm-4">
                <?php $model->user_id = ( $model->isNewRecord ) ? Yii::app()->user->id : $model->user_id;  ?>
                <?php echo $form->dropdownlist($model, 'user_id', User::getAssignmnetUsers() ,array('class' => 'tooltipster', 'data-label' => 'Assigned To *')); ?>
            </li>
            <li class="col-sm-12">
                <?php echo $form->textArea($model, 'remarks', array('class' => 'tooltipster', 'data-label' => 'Remarks *')); ?>
            </li>
        </ul>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
    <?php 
        if( $model->isComplete == 'N' )
        echo CHtml::ajaxSubmitButton('Save', Yii::app()->createUrl('assignments/Save'), array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {
                if(data.status=="success"){ 
                    t8.success("Task Added!");
                    reloadTable("#tbl_assignments");
                    $("#loader").hide();
                    $(".x.close").click();
                }else{ 
                    $("#loader").hide();
                    $.each(data, function(key, val) {
                        t8.error(""+val+""); 
                    }); 
                } 
            }',
            'beforeSend' => 'function(){
                 $("#loader").show();
            }'
        ), array('id' => 'mybtn' . rand(), 'class' => 'currency-save-btn btn btn-theme'));

           

    ?>

    </div>

<?php $this->endWidget(); ?>

<!-- <script>
            $("#Assignments_date").datetimepicker({  
                minDate: new Date(),
                format: "DD/MM/YYYY"
        });

</script> -->








