<!doctype html>
<html lang="en">
    <head>
        <style>
            @page {
                margin-top: 2cm;
                margin-bottom: 2cm;
                margin-left: 1cm;
                margin-right: 1cm;
                header: html_myHeader;
                footer: html_myfooter;
                /*size: landscape;*/
                font-family:tahoma;
            }

            .table_tab{
                border-collapse:collapse;
                font-family: arial, sans-serif;
                width:100%;
            }
            .table_tab th{
                border: 1px solid #1f67b2;
                color:#fff !important;
                background-color: #fff!important;
                text-align:left;
                padding:3px;
            }
            .table_tab td{
                border: 1px solid #002060;
                text-align: left;
                padding: 3px;
                font-size:11px;
                color: #222;
                padding-left:20px;
                padding-right:20px;
            }
            .input-block{
                display: inline-block;
                padding: 5px 10px;
                background: #002060;
                border: none;
                border-radius: 4px;
                font-size:14px;
                margin-top:4px;
                color:#fff;
                margin-bottom:8px;
            }
            .table{
                border-collapse:collapse;
                font-family: arial, sans-serif;
                width:100%;
            }
            .table th{
                border: 1px solid #1f67b2;
                color:#fff !important;
                background-color: #002060!important;
                text-align:left;
                padding:15px;
                line-height: 17px;
            }
            .table td{
                border: 1px solid #1f67b2;
                text-align: left;
                padding: 15px;
                line-height: 17px;
                color: #222;
            }
        </style>
        <title>Minutes Of Meeting</title>
    </head>
    <body>
        <table style="border-collapse:collapse;font-family: arial, sans-serif;" width="100%" cellpadding="0">
            <tr>
                <th style="color:#fff !important;text-align:left;line-height: 18px;">
                    <table style="border-collapse:collapse;font-family: arial, sans-serif;" cellpadding="0" border="0">
                        <thead>
                            <tr>
                                <th style="font-size:25px;font-style:italic;color:#002060;text-align:left;width:100%;">Minutes Of Meeting</th>
                                <th><img style="width: 20%;float:right;" src="images/logo.png"></th>
                            </tr>
                        </thead>
                    </table>
                </th>
            </tr>
        </table>
        <div class="input-block">
            <b>Meeting No : <?php echo $model->id; ?></b>
        </div>
        <br>
        <div class="col-7">
                <table  class="table_tab" style="width:100%; ">
                    <tr>
                        <td>Title</td>
                        <td>
                            <?php echo $model['meeting_title']; //$model->title;   ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Type</td>
                        <td>
                            <?php echo $model['type']; //$model->title;    ?>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>Meeting Date</td>
                        <td>
                            <?php
                            $reporting_date = date('d/m/Y ', strtotime($model->meeting_date)) . " " . $model->meeting_time;
                            ?>
                            <?php echo $reporting_date; ?>
                        </td>
                    </tr>
                    <tr>
                        <td>Conducted by</td>
                        <td>
                            <ol type="1">
                                <?php
                                $list_str = $model->conducted_by;
                                $empModel = Employee::model()->findAll(array("condition" => ' t.id in (' . $list_str . ')'));
                                foreach ($empModel as $value) {
                                    ?> 
                                    <li> <?=$value->getemployeefullname()?></li>

                                    <?php
                                }
                                ?>
                            </ol>
                        </td>
                    </tr>
                </table>
        </div>
        <div class="col-5">
                    <table class="table_tab"  style="width: 100%; margin-left: 10%">
                        <tr>
                            <td>Attendee</td>
                        </tr>
                        
                        <tr>
                            <td style="vertical-align: top;">
                                <ol type="1">
                                    <?php
                                    $list_str_att = $model->attendees;
                                    $empModel_att = Employee::model()->findAll(array("condition" => ' t.id in (' . $list_str_att . ')'));
                                    foreach ($empModel_att as $value) {
                                        ?> 
                                        <li> <?= $value->getemployeefullname() ?></li>

                                        <?php
                                    }
                                    ?>
                                </ol>
                            </td>
                        </tr>
                    </table>
        </div>
        <br>
        <table style="font-family: arial,sans-serif;border-collapse: collapse;width: 100%;font-size: 12px;color:#222;">
            <thead>
                <tr>
                    <th style="border: 1px solid #ccc;background-color: #ccc;font-size: 12px;color: #002060;text-align: left;padding: 10px;line-height: 10px;">Agenda</th>
                    <!--<th style="border: 1px solid #ccc;background-color: #ccc;font-size: 12px;color: #002060;text-align: left;padding: 10px;line-height: 10px;">SELECT INCIDENT INVOLVING :</th>-->
                </tr>
            </thead>
        </table>
        <table style="font-family: arial,sans-serif;border-collapse: collapse;width: 100%;font-size: 12px;color:#222;">

            <tbody>
                <tr>

                    <th style="border: 1px solid #ccc;text-align: left;padding: 10px;line-height: 10px;color:#222;">#</th>
                    <th style="border: 1px solid #ccc;text-align: left;padding: 10px;line-height: 10px;color:#222;">Heading</th>
                    <th style="border: 1px solid #ccc;text-align: left;padding: 10px;line-height: 10px;color:#222;">Details</th>
                    <th style="border: 1px solid #ccc;text-align: left;padding: 10px;line-height: 10px;color:#222;">Assigned </th>
                    <th style="border: 1px solid #ccc;text-align: left;padding: 10px;line-height: 10px;color:#222;">Closing Date </th>
                    <th style="border: 1px solid #ccc;text-align: left;padding: 10px;line-height: 10px;color:#222;">Status </th>
                </tr>
                <?php
                $status = Array(2 => "Open", 1 => "On Hold", 3 => 'Closed');
                $modeltransations = MeetingTransaction::model()->findAll('meeting_id =' . $model->id);
                $i = 0;
                foreach ($modeltransations as $value) {
                    $i++;
                    $closing_date = date('d/m/yy', strtotime($value->closing_date));
                    ?>
                    <tr>
                        <td style="border: 1px solid #ccc;text-align: left;padding: 10px;line-height: 10px;color:#222;"><?php echo $i ?></td>
                        <td style="border: 1px solid #ccc;text-align: left;padding: 10px;line-height: 10px;color:#222;"><?php echo $value->heading ?></td>
                        <td style="border: 1px solid #ccc;text-align: left;padding: 10px;line-height: 10px;color:#222;"><?php echo $value->meeting_details ?></td>
                        <td style="border: 1px solid #ccc;text-align: left;padding: 10px;line-height: 10px;color:#222;"><?php echo $value->employee->getemployeefullname() ?></td>
                        <td style="border: 1px solid #ccc;text-align: left;padding: 10px;line-height: 10px;color:#222;"><?php echo $closing_date ?></td>
                        <td style="border: 1px solid #ccc;text-align: left;padding: 10px;line-height: 10px;color:#222;"><?php echo $status [$value->complete_status] ?></td>
                    </tr>
                    <?php
                }
                ?> 
            </tbody>
        </table>

    <br><htmlpagefooter name="myfooter"> <div style="text-align:center;width:100%;font-size:5px"></div>
            <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
                <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
                    <?php
                    date_default_timezone_set("Asia/Dubai");
                    echo date('d/m/Y h:i:s a');
                    ?>
                </div>
                <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
            </div>
    </htmlpagefooter>				
</body>
</html>

