<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$cs->registerScript("load", '
        $(document).ready(function() {

        var table_id ="#table_meeting_summary";
        var table = $(table_id).DataTable({
            scrollY         : "450px",
            "bAutoWidth": true,
            pageLength      : 50,
            ajax: {
                url: "' . Yii::app()->createUrl('meeting/getList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            order: [[ 1, "desc" ]],
            
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
$cs->registerScript("getCalendar", "$(document).ready(function(){
getCalendarEvents();

});", CClientScript::POS_READY);



$cs->registerScript("getCalendarEvents" . rand(), "function getCalendarEvents(){
  var filter_id = $('#sel_event_type').val();
  $('#calendar').fullCalendar({
            header: {
                left: 'prev,next today',
                center: 'title',
                right: 'month,basicWeek,basicDay'
            },
            dayClick: function(date, allDay, jsEvent, view) { $(this).addClass('selected-date');},
            eventClick: function(calEvent, jsEvent, view) {             
                 loadPopupModal('meetingactivity/Create&id=' +calEvent.trans_id ,'Add Activity ' +calEvent.title , 'md');
            },
            header: { left: 'prev,next today', center: 'title', right: 'month,agendaWeek,agendaDay'},
            buttonText: {
                today: 'Today',
                month: 'Month',
                agendaWeek: 'Agenda Week',
                agendaDay: 'Agenda Day'
            },
            defaultView: 'month',
            eventMouseover: function(calEvent, jsEvent) {
                      
                var tooltip = '<div class=\"tooltipevent\">ok</div>';
                $(\"#calendar-view\").append(tooltip);
                $(this).mouseover(function(e) {
                    $(this).css('z-index', 100000);
                    $('.tooltipevent').fadeIn('500');
                    $('.tooltipevent').fadeTo('10', 1.9);
                }).mousemove(function(e) {
                    $('.tooltipevent').css('top', e.pageY + 100);
                    $('.tooltipevent').css('left', e.pageX - 300);
                });
            },
            eventMouseout: function(calEvent, jsEvent) {
                $(this).css('z-index', 8);
                $('.tooltipevent').remove();
            },
 

            eventAfterRender:function (event, element) { },
            editable: true,
            eventLimit: true,
            //timeFormat: '',
            eventRender: function (calEvent, jsEvent) {
                var tooltip = calEvent.tooltip;
                var type=calEvent.type;
                $(jsEvent).attr('data-original-title', tooltip);
                $(jsEvent).tooltip({ container: 'body',html:true});
                // $(jsEvent).find('.fc-event-time').remove();
                return ['all', calEvent.type].indexOf($('#filter_selector').val()) != ''
            },
            
            loading: function( isLoading, view ) {
            if(isLoading) {// isLoading gives boolean value
                $('#loader').show();
            } else {
                 $('#loader').hide();
            }
        },
            
            
        events: {
                url : '" . Yii::app()->createUrl('meeting/getCalendarDetails') . "',
            },            
        });
        
        
    }
", CClientScript::POS_READY);
?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-map"></i> Meeting 


        <div class="pull-right">
            <div class="pull-left">
                <select class="btn-sm" onchange="ChangeView(this.value)" >
                    <option value="1">Summary</option>
                    <option value="2">Detail</option>
                    <option value="3">Calendar</option>
                </select>
                <?php if (isset(Yii::app()->user->havePermissionOn['meeting_add']) || Yii::app()->user->authorised_user == '1') { ?>                    
                    <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('meeting/create', 'Add', 'xl')"><i class="fa fa-plus"></i> ADD</button>
                <?php } ?>
            </div><div class="pull-left">
                &nbsp;<input type="button" value="Back" onclick="window.history.back();return false;" class='btn btn-sm btn-danger' style="margin-right: 10px;" />
            </div>
        </div>

    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <div id="meeting_summary">
                <table class="table table-hover table-bordered personal-task" id="table_meeting_summary">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Title</th>                            
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>#</th>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Title</th>                            
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <div id="meeting_deatils" style="display: none">
                <table  class="table table-hover table-bordered personal-task" id="table_meeting_details">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Meeting</th>
                            <th>Date</th>
                            <th>Title</th>
                            <th>Details</th>  
                             <th>Action Taken</th>  
                            <th>Person</th>
                            <th>Closing</th>
                            <th>Status</th>                          
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>#</th>
                            <th>Meeting</th>
                            <th>Date</th>
                            <th>Title</th>
                            <th>Details</th>  
                             <th>Action Taken</th>  
                            <th>Person</th>
                            <th>Closing</th>
                            <th>Status</th>                          
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <div id="calendar-view" style="padding:  50px;" style="display: none">
                <div id='calendar-container'>
                    <div id='calendar'></div>
                </div>
            </div>
        </div>
    </div>
</section>
<script type="text/javascript">

    function ChangeView(val) {
        if (val == "1") {
            $("#meeting_deatils").hide();
            $("#calendar-view").hide();
            $("#meeting_summary").show();
            $('#table_meeting_summary').DataTable().ajax.reload();
        } else if (val == "2") {
            $("#meeting_deatils").show();
            $("#meeting_summary").hide();
            $("#calendar-view").hide();
            $('#table_meeting_details').DataTable().ajax.reload();
        } else if (val == "3") {
            $("#meeting_deatils").hide();
            $("#meeting_summary").hide();
            $("#calendar-view").show();
        }
    }
    function CloseTransation(val) {
        var dr = confirm("Do you want to Close this item?");
        if (dr) {
            jQuery.ajax({
                dataType: 'json',
                data: {'id': val},
                type: 'post',
                url: '<?= Yii::app()->createUrl('meeting/CloseTransation') ?>',
                'cache': false,
                'success': function (data) {
                    if (data.status == "success") {
                        t8.success("Closed");
                        $('#table_meeting_details').DataTable().ajax.reload();
                    }
                }
            });
        }
    }

    $(document).ready(function () {
    $("#calendar-view").hide(); 
        var table_details_id = "#table_meeting_details";
        var table_details = $(table_details_id).DataTable({
            scrollY: "450px",
            "bAutoWidth": true,
            pageLength: 50,
            ajax: {
                url: "<?= Yii::app()->createUrl('meeting/GetDetailsList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            order: [[7, "asc"]],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {


                if (aData[8] == "Closed") {
                    $("td", nRow).addClass("bg-success");
                }
                if (aData[10] == true) {
                    $("td", nRow).addClass("bg-danger");
                }
            }
        });
        $(".dataTables_scrollFoot").hide();
    });
</script>
<script>
    function sendMail(id) {
        var dr = confirm("Do you want to send the notification?");
        if (dr) {
            jQuery.ajax({
                dataType: 'json',
                data: {'id': id},
                type: 'post',
                url: 'index.php?r=meeting/MailSend',
                'cache': false,
                'success': function (data) {
                    if (data.status == "success") {
                        t8.success("Notification Mails sent");

                    }
                }
            });
        }
    }
    
</script>