
<?php

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$status = Array(1 => "Pending", 2 => "Completed");
$cs->registerScript("getAllLocations", "
    function getAllLocations(val){
    
        jQuery.ajax({
            'dataType': 'json',
            'data' : {'countryid':val},
            'type':'post',
            'url': '".Yii::app()->createUrl('meeting/getAllLocations')."',
            'cache': false,
            'success': function(data) {
                $('#meeting_location_li').html(data.location);
            }
        });
    }", CClientScript::POS_HEAD);
$cs->registerScript("getAllEmployee", "
    function getAllEmployee(val){
    
        jQuery.ajax({
            'dataType': 'json',
            'data' : {'location_id':val},
            'type':'post',
            'url': '".Yii::app()->createUrl('meeting/getAllEmployee')."',
            'cache': false,
            'success': function(data) {
                $('#meeting_conducted_by_li').html(data.conducted);
                $('#meeting_attendees_li').html(data.attendees);
            }
        });
    }", CClientScript::POS_HEAD);
$emp_details = array ();

if( $model->meeting_id != ""){

    $meeting_model = new Meeting;
    $meeting_model = $meeting_model->findByPk($model->meeting_id);
    $person_list = $meeting_model->conducted_by. "," . $meeting_model->attendees;
    $condition= " t.isActive = 'Y' and t.id IN (" . $person_list . ")";
    $emp_model = new Employee;
    $model_emp = $emp_model->findAll(array('condition' => $condition));
    $emp_details  = CHtml::listData($model_emp, 'id', 'name');
    $person = $model->person;
    $person_by_arr = explode(",", $conducted_by);
    foreach ($person_by_arr as $eachValue)
        $selectedOptions[$eachValue] = array('selected' => 'selected');
}
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'remarks-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
 ?>


    <div class="tab-content">
        <div class="tab-pane active">
             <ul class="clearfix form-ul material">
                <li class="col-sm-12">
                    <?php echo $form->hiddenField($model, 'id'); ?>
                    <?php echo $form->hiddenField($model, 'meeting_id'); ?>
                    <?php echo $form->hiddenField($model, 'serial_no'); ?>
                    <?php echo $form->textField($model, 'heading', array('class' => 'tooltipster','data-label'=>'Heading  <span style="color:red;">*</span>' )); ?>                    
                </li>
                <li class="col-sm-12">               
                    <?php echo $form->textArea($model, 'meeting_details', array('class' => 'tooltipster','data-label'=>'Meeting Details <span style="color:red;">*</span>' )); ?>                 
          
                </li>
 
   
                <li  class="col-sm-4">
                    <?php echo $form->textField($model, 'closing_date', array('class' => 'datepicker tooltipster','data-label'=>'Closing date')); ?>
                </li>
         
                <!-- <li class="col-sm-4"  id= "meeting_person_by_li">
                    <?php 
                    echo CHtml::dropDownList('person',"", $emp_details, array( "name" =>"person" , 'class' => 'tooltipster','data-label'=>'Conducted by <span style="color:red;">*</span>','multiple'=>true, 'options' => $selectedOptions)); ?>
                </li> -->
                <li class="col-sm-4" >
                    <?php 
                    echo $form->dropDownList($model,"person", $emp_details, array( 'class' => 'tooltipster','data-label'=>'Person <span style="color:red;">*</span>')); ?>
                </li>
                <li class="col-sm-4" >
                    <?php 
                    echo $form->dropDownList($model,"complete_status", $status, array( 'class' => 'tooltipster','data-label'=>'Status <span style="color:red;">*</span>')); ?>
                </li>
     
     

            </ul>
        </div>        
    </div> 
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <?php
                $url = Yii::app()->createUrl('meeting/SaveMeetingTransaction');
                echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                    if(data.status=="success"){  
                                        $(".x.close").click();
                                        $("#loader").hide();
                                        t8.success("Saved!!");
                                        reloadTable("#table_remark_type");
                                    } else { 
                                        $("#loader").hide();
                                        $.each(data, function(key, val) {
                                            t8.error(""+val+""); 
                                        }); 
                                    } 
                            }',
                            'beforeSend' => 'function(){
                                //$("#loader").show();
                            }',
                            
                    ), array('id' => 'mybtn' . rand(), 'class' => 'customer1-save-btn btn btn-theme'));
           
    ?>
    </div>
    <?php $this->endWidget(); ?>
