<style>
.workspace-card{
    color:gray;
    width: 200px;
    float: left;
    min-height: 5000px;
    margin: 5px;
    border: solid 1px #ebe3e3;
    padding-bottom: 30px;
}
.card-header{
    display: block;
    font-weight: 450;
    width: 100%;
    text-align: center;
    color: #828181;
}
.card-body{
    display: block;
    width: 100%;
    height: 100%;
    min-height:470px;
}
.label{
    height: 102px;
    margin: 2px;
    font-size: 14px
}
.itemclose{
    text-decoration: none;
    text-shadow: 0 1px 0 gray;
    opacity: 0.75;
}
.itemclose:hover{
    text-decoration: none;
    color: whitesmoke;
    opacity: 1;
}
.inner-card{
    top:16px;
    position: relative;
}
.label-list{
    text-align: start;
    margin: 0px;
    list-style: none;
    width: 100%;
    padding: 0px;
}
#quotation_drop, #lead_drop{
    border: dashed 2px #6c8c96;
    padding: 8px;
    width: 220px;
    text-align: center;
    color: #4669ad;
    margin-left: 50px;
    background: #ecf5fd;
}
.ws-avatar{
    border-radius: 50%;
    font-size: 10px;
    opacity: 0.8;
    font-weight: 600;
    color:white;
    width: 30px;
    height: 30px;
    text-align: center;
    float: left;
    padding-top:  7px;
    margin: 2px;
}
.ws-avatar:hover{
    opacity: 1;
    padding-top:  8px;
    width: 34px;
    height: 34px;
    margin: 0px;
}
</style>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.1.4/Chart.bundle.min.js"></script>
<script>
const DISPLAY_ITEM_LIMIT = 5000;
function reloadCalendar() {//alert('reload');
    $.ajax({
        //url: "index.php?r=workspace/space/getlist",
        url: "index.php?r=workspace/purchaseSpace/getrequisitionlist",
        type: 'POST',
        dataType: 'json',
        data: {
            "through_id": $("#through_id").val(),
            "group_id": $("#group_id").val(),
            "from_date": $("#from_date").val(),
            "to_date": $("#to_date").val(),
            "search_word": $("#search_word").val()
        },
        beforeSend: function (xhr) {
            $("#loader").show();
        },
        success: function (data, textStatus, jqXHR) {
            $(".card-body").html("");
            $(data).each((i, el) => {

                addItem(el);
                //console.log(el);
            });
            //updateTotalAmount();
            $("#loader").hide();
        }
    });
}
window.reloadCalendar = reloadCalendar;
function allowDrop(ev) {
    ev.preventDefault();
}

function drag(ev, obj) {
    console.log(ev);
    console.log(obj);
    console.log(obj.attr('workspaceid'));
    var workspace_id = ev.target.id.split('_')[2];
    var data = ev.dataTransfer.getData("text");
    var item_id = data.split('_')[2];
    console.log(workspace_id);console.log(item_id);console.log('wpid-'+obj.attr('workspaceid'));
    ev.dataTransfer.setData("text", ev.target.id);
    ev.dataTransfer.setData("sourceWorkspaceid", obj.attr('workspaceid'));
}

function dragUser(ev) {
    ev.dataTransfer.setData("user", ev.target.id);
}

function drop(ev, obj) {console.log(ev);console.log(obj);
    var _target = $("#" + ev.target.id);
    var data = ev.dataTransfer.getData("text");console.log(data);
    var sourceWorkspaceid = ev.dataTransfer.getData("sourceWorkspaceid");
    console.log('sourceid='+sourceWorkspaceid);
    if (data == "") {
        var user = ev.dataTransfer.getData("user");
        if (user != "") {
            addUserto(user, ev.target.id)
        }
        ev.preventDefault();
        return false;
    } else {

    }
    console.log('tareget id='+ev.target.id);
    //console.log('wpid drop-'+ev.firstElementChild.workspace);
    //console.log('wpid drop-'+ev.lastChild.workspace);
    var workspace_id = ev.target.id.split('_')[2];
    var item_id = data.split('_')[2];
    console.log('workspace_id 1='+workspace_id);
    
    if ($(_target).hasClass("noDrop")) {
        ev.preventDefault();
        var card_body = $(ev.target).parent('.card-body');
        $(card_body).append(document.getElementById(data));
        var workspace_id = $(ev.target).parent('.card-body').prop('id').split('_')[2];
        //updateItem(workspace_id, item_id);
        console.log('workspace_id 2='+workspace_id);
    } else {
        ev.preventDefault();
        ev.target.appendChild(document.getElementById(data));
        //updateItem(workspace_id, item_id);
    }

    console.log('workspace_id='+workspace_id);console.log('item_id='+item_id);
    if (sourceWorkspaceid == 9) {
        loadPopupModal('enquiry/create&req_id='+item_id+'&workspace_id=' + sourceWorkspaceid + '&item_id=' + item_id, "Convert to Enquiry", 'xl');
    } else if (sourceWorkspaceid == 11) {
        loadPopupModal('purchasingorder/create&enq_id='+item_id+'&vendor_id=2001&workspace_id=' + sourceWorkspaceid + '&item_id=' + item_id, "Convert to Order", 'xl');
    } else if (sourceWorkspaceid == 14) {
        loadPopupModal('materialreceipt/create&order_id='+item_id+'&file_id=10043&workspace_id=' + sourceWorkspaceid + '&item_id=' + item_id, "Convert to Material Receipt", 'xl');
    } else if (sourceWorkspaceid == 17) {
        loadPopupModal('purchaseinvoice/create&mr_id='+item_id+'&file_id=10078&workspace_id=' + sourceWorkspaceid + '&item_id=' + item_id, "Convert to Purchase Invoice", 'xl');
    }
    //debitnote/printfile&id=80001&tax=Y

    $("#" + data).tooltip('hide');
    //updateTotalAmount();
    //rearrangeItems(workspace_id);
    
}

function rearrangeItems(workSpaceId) {
    var hasHiddenItems = false;
    var items = $("#workspace_id_" + workSpaceId).find(".note-item");
    var totalItems = items.length;
    var remaining = 0;
    if (totalItems > DISPLAY_ITEM_LIMIT) {
        hasHiddenItems = true;
        remaining = totalItems - DISPLAY_ITEM_LIMIT;
        var index = 0;
        for (var item in items) {
            try {
                var id = "#" + items[index].id;
                if (index < (totalItems - DISPLAY_ITEM_LIMIT)) {
                    $(id).hide();
                } else {
                    $(id).show();
                }
            } catch (exception) {}
            index++;
        }
    } else {
        hasHiddenItems = false;
        $("#workspace_id_" + workSpaceId).find(".note-item").show();
    }
    $("#show-all-" + workSpaceId).remove();
    if (hasHiddenItems) {
        var showMore = "<div style='text-align: center;' id ='show-all-" + workSpaceId + "' ><a href='#' onclick='showAll(" + workSpaceId + ")' >Show  All(+" + remaining + ")</a></div>";
        $("#workspace_id_" + workSpaceId).append(showMore);
        console.log(showMore);
    } else {}
    console.log("#workspace_id_ => " + workSpaceId);
}

function showAll(id) {
    var through_id = $("#through_id").val();
    loadPopupModal("workspace/space/viewall&ws_id=" + id + "&through_id=" + through_id, "Workspace", "xl");
}

/*function dropOnCard(ev) {
    ev.preventDefault();
}*/

function updateItem(workspace_id, item_id) {
    $.ajax({
        url: "index.php?r=workspace/space/CheckQtnexist",
        type: 'POST',
        dataType: 'json',
        data: {
            workspace_id: workspace_id, item_id: item_id
        },
        success: function (data, textStatus, jqXHR) {
            if (data == '1') {
                loadPopupModal('workspace/space/Changeworkspace&workspace_id=' + workspace_id + '&item_id=' + item_id, "Reason");
            } else if (data == '2') {
                $.ajax({
                    url: "index.php?r=workspace/space/UpdateWorkspace",
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        workspace_id: workspace_id, item_id: item_id
                    },
                    success: function (data, textStatus, jqXHR) {
                        rearrangeItems(data.prev);
                        updateTotalAmount();
                    }
                });
            } else {
                location.reload();
            }
            rearrangeItems(workspace_id);
            updateTotalAmount();
        }
    });
}

function addItem(data) {
    //console.log(data.workspace_id);
    var closeBtn = '';
    if (data.lead_id > 0) {
        //closeBtn += '<span style=" float: left;font-size: 12px;color: ' + data.bgcolor + '">' + data.lead_id + '</span>';
    }
    //   ----------------------------
    if (data.status == "H") {
        //closeBtn += '<a  title="Priority High" class="itemclose noDrop" href="#" style=" margin-right: 8px;float: right;color: red;font-size: 14px;"><i class="fa fa-certificate"></i></a>';
    } else if (data.status == "N") {
        //closeBtn += '<a  title="Priority Normal" class="itemclose noDrop" href="#" style="margin-right: 8px;float: right;color: green;font-size: 14px;"><i class="fa fa-certificate"></i></a>';
    } else {
        //closeBtn += '<a  title="Priority Low" class="itemclose noDrop" href="#" style="margin-right: 8px;float: right;color: yellow;font-size: 14px;"><i class="fa fa-certificate"></i></a>';
    }
    //   ----------------------------
    //  closeBtn = '<a  onclick="loadPopupModal(\'activity/activity/detailsActivity&frm=WS&customer_id='+data.customer_id+'&header_id=' + data.id + '\',\'Activity\',\'xl\')" class="itemclose noDrop" href="#" style="margin-right: 8px;float: right;color: white;font-size: 14px;"><i class="fa fa-globe"></i></a>'+ closeBtn;
    <?php if (isset(Yii::app()->user->havePermissionOn['workspace_delete'])) { ?>
        //closeBtn = '<a title="Close" onclick="deleteItem( ' + data.id + ', this);" class="itemclose noDrop" href="#" style="margin-right: 0px;float: right;color: ' + data.bgcolor + ';font-size: 14px;"><i class="fa fa-close"></i></a>' + closeBtn;
    <?php } ?>
    //  closeBtn+= '<a  title="Activity" onclick="loadPopupModal(\'activity/activity/history&frm=WS&customer_id='+data.customer_id+'&header_id=' + data.id + '\',\'Activity\',\'xl\')" class="itemclose noDrop" href="#" style="margin-right: 8px;float: right;color:'+data.bgcolor+' ;font-size: 14px;"><i class="fa fa-certificate"></i></a>';
    //  closeBtn+= '<a  title="Details" onclick="loadPopupModal(\'workspace/space/getsummary&ws_id='+data.id+'&customer_id='+data.customer_id+'&header_id=' + data.id + '\',\'Summary - '+data.customer_name+'\',\'xl\')" class="itemclose noDrop" href="#" style="margin-right: 8px;float: right;color: '+data.bgcolor+';font-size: 14px;"><i class="fa fa-list"></i></a>';
    //indhu 10 08 2022
    if (data.quotes_id > 0) {
        // closeBtn+= '<a class="itemclose noDrop" title="Print Quotation" target="_blank" href="?r=quotation/PrintQuotationReportPDF&id='+data.quotes_id+'" style="margin-right: 8px;float: right;color: '+data.bgcolor+';font-size: 14px;"><i class="fa fa-file-pdf-o"></i></a>';
    }
    //closeBtn += '<a title="Info" onclick="loadPopupModal(\'workspace/space/info&ws_id=' + data.id + '&customer_id=' + data.customer_id + '&header_id=' + data.id + '\',\'' + data.customer_name + '-' + data.workspace_created_date + '\',\'xl\')" class="itemclose noDrop" href="#" style="margin-right: 8px;float: right;color: ' + data.bgcolor + ';font-size: 14px;"><i class="fa fa-info"></i></a>';
    // end
    var share_html = getShareHtml(data.shared_to);
    var style = '';
    var draggable = 'draggable="true"';
    var dragPro = 'ondragstart="drag(event, $(this))"';
    if (data.is_approved == 'N'){
        style = 'background-color:rgb(231 172 181) !important;';
        dragPro = draggable = '';
    }
    // shred item
    var html = '<div class="label noDrop note-item" style="display: block; border-style: solid; border: 1px solid grey;'+style+'" '+draggable+' '+dragPro+' workspaceid="'+data.workspace_id+'" id="note_id_' + data.id + '" >' + closeBtn + '<div  ondrop="return false;" id="note_innerid_' + data.id + '" amount="' + data.amount + '" class="inner-card work-note-title noDrop" style="'+style+'">' + data.title + "</div>" + share_html + ' </div>';
    $("#workspace_id_" + data.workspace_id).append(html);
    var itemsCount = $("#workspace_id_" + data.workspace_id).find(".note-item").length;
    if (itemsCount > DISPLAY_ITEM_LIMIT) {
        $("#note_id_" + data.id).hide();
        //rearrangeItems(data.workspace_id);
    }
    $("#note_id_" + data.id).prop('data-toggle', 'tooltip');
    $("#note_id_" + data.id).prop('title', data.tooltip);
    $("#note_id_" + data.id).prop('lead_id', data.lead_id);
    $("#note_id_" + data.id).prop('file_id', data.file_id);
    $("#note_id_" + data.id).prop('workspace', data.workspace_id);
    $("#note_id_" + data.id).prop('itemid', data.id);
    $("#note_id_" + data.id).attr('amount', data.amount);
    $("#note_id_" + data.id).prop('html', true);
    $("#note_id_" + data.id).tooltip({title: data.tooltip, html: true, placement: "bottom"});
}

function getShareHtml(shared_to) {
    var share_item_conatinter_div = document.createElement('div');
    $(share_item_conatinter_div).addClass('share-container')
    $(share_item_conatinter_div).css({'color': 'white', 'bottom': '0px', 'position': 'relative', 'top': '15px'});
    $(shared_to).each((index, el) => {
        var share_item_span = document.createElement('div');
        share_item_span.innerHTML = el.name;
        var avatar_id = "#wsavatar_" + el.id;
        var bgcolor = $(avatar_id).css('background-color');
        var title = $(avatar_id).prop('title');
        $(share_item_span).css({
            'float': 'right',
            'border-radius': '50%',
            'border': 'solid 1px white',
            'font-size': '9px',
            'height': "20px",
            'padding': '6px',
            'width': '20px',
            'padding-left': '3px',
            'background': bgcolor,
            opacity: ' 0.8'
        });
        $(shared_to).prop('ondragover', 'return false');
        $(shared_to).prop('title', title);
        share_item_conatinter_div.appendChild(share_item_span);
    });
    $(share_item_conatinter_div).prop('ondragover', 'return false');
    return "";
    // return share_item_conatinter_div.outerHTML;
}

$(document).ready(function () {
    reloadCalendar();
    $('.btn-danger').on('click', function(){
        alert(1);
    });
});

function deleteItem(id, evt) {
    var msg = "Are you sure you want to delete this item?";
    var dr = confirm(msg);
    if (dr) {
        $.ajax({
            url: "index.php?r=workspace/space/deleteItem",
            type: 'POST',
            dataType: 'json',
            data: {id: id},
            beforeSend: function (xhr) {
                //$("#loader").show();
            },
            success: function (data, textStatus, jqXHR) {
                $(evt).parent().tooltip('hide');
                $(evt).parent().remove();
                updateTotalAmount();
                //$("#loader").hide();
            }
        });
    }
}

/*function dropLead(ev) {
    var id = ev.dataTransfer.getData("text");
    //console.log(ev.dataTransfer.getData("text"));
    var lead_id = $("#" + id).prop('lead_id');
    var note_id = id.split('_')[2];
    loadPopupModal("lead/create&id=" + lead_id + "&note_id=" + note_id, 'Lead', "lg");
    ev.preventDefault();
}*/

/*function dropQuotation(ev) {
    var id = ev.dataTransfer.getData("text");
    //console.log(ev.dataTransfer.getData("text"));
    var lead_id = $("#" + id).prop('lead_id');
    var file_id = $("#" + id).prop('file_id');
    var note_id = id.split('_')[2];
    if (lead_id == 0) {
        loadPopupModal("quotation/create&note_id=" + note_id, "Quotation", "xl");
    } else {
        loadPopupModal("quotation/create&lead_id=" + lead_id + "&file_id=" + file_id + '&note_id=' + note_id, "Convert To Quotation", "xl");
    }
    ev.preventDefault();
}*/

function addUserto(user, target) {
    var item_id = target.split('_')[2];
    var user_id = user.split('_')[1];
    $.ajax({
        url: "index.php?r=workspace/space/shareItem",
        type: 'POST',
        dataType: 'json',
        data: {id: item_id, 'user_id': user_id},
        beforeSend: function (xhr) {
            $("#loader").show();
        },
        success: function (data, textStatus, jqXHR) {
            $("#loader").hide();
            addItem(data.item);
        }
    });
}

function updateTotalAmount() {
    var cardBodyArray = $('.card-body');
    $.each(cardBodyArray, (i, cardBody) => {
        var cardBodyId = $(cardBody).prop("id").toString();
        var cardBodyIdArray = cardBodyId.split("_");
        var workSpaceId = cardBodyIdArray[2];
        var noteItems = $(cardBody).find(".work-note-title");
        var totalAmount = 0;
        for (var i = 0; i < noteItems.length; i++) {
            var noteId = $(noteItems[i]).prop("id");
            var _amountText = $("#" + noteId).attr("amount");
            var amount = parseFloat(_amountText);
            if (!isNaN(amount)) {
                totalAmount += parseFloat(_amountText);
            }
        }
        var totalLabelId = "#ws_total_" + workSpaceId;
        $(totalLabelId).html(totalAmount.toLocaleString("en-IN"));
    });
}
</script>
<?php
/*function randomColor() {
    $result = array('rgb' => '', 'hex' => '');
    foreach (array('r', 'b', 'g') as $col) {
        $rand = mt_rand(0, 255);
        $result['rgb'][$col] = $rand;
        $dechex = dechex($rand);
        if (strlen($dechex) < 2) {
            $dechex = '0' . $dechex;
        }
        $result['hex'] .= $dechex;
    }
    return "#" . $result['hex'];
}*/

function random_color_part() {
    $dt = '';
    for ($o = 1; $o <= 3; $o++) {
        $dt .= str_pad(dechex(mt_rand(0, 127)), 2, '0', STR_PAD_LEFT);
    }
    return "#" . $dt;
}

$condition = ' isActive =  "Y" AND ai_type_id = "PR" ';
$users = User::getUserModels(); ?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <div class="pull-left">
            <!-- <i class="fa fa-users"></i> -->
             Workspace
            </div>
        <!--  <div  ondrop="dropLead(event)"    ondragover="allowDrop(event)"  id ="lead_drop" class="pull-left" style="">Lead</div>
        <div  ondrop="dropQuotation(event)"    ondragover="allowDrop(event)"  id ="quotation_drop" class="pull-left" style="">Quotation</div> -->
        <div class="pull-right">
            <?php
            $user_id = (int) Yii::app()->user->id;
            if ((Yii::app()->user->authorised_user != 1) && (Yii::app()->user->havePermissionOn['workspace_view_all'] != 1)) {
                echo CHtml::hiddenField("through_id", $user_id);
            } else {
                echo CHtml::dropDownList("through_id", $user_id, User::getUser(), ['empty' => "All", 'onchange' => "reloadCalendar()"]);
            }
            echo CHtml::dropDownList("group_id", "", MasSalesGroup::getSalesGroups(), ['empty' => "All", 'onchange' => "reloadCalendar()"]);
            echo CHtml::textField("from_date", date("01/01/Y"), ['style' => "width:120px", "class" => "datepicker", 'onblur' => 'reloadCalendar()', 'placeholder' => 'From']);
            echo '&nbsp;';
            echo CHtml::textField("to_date", date("d/m/Y"), ['style' => "width:120px", "class" => "datepicker", 'onblur' => 'reloadCalendar()', 'placeholder' => 'To']);
            echo '&nbsp;';
            echo CHtml::textField("search_word", "", ['style' => "width:120px", 'onkeyup' => 'reloadCalendar()', 'placeholder' => 'Search']); ?>
            <button class="btn btn-sm btn-theme" onclick="loadPopupModal('workspace/space/create', 'Add New Workspace', 'lg')" title="Add"><i class="fa fa-plus"></i></button>
        </div>
    </header>
    <div class="panel-body">
        <div class="panel-body" style="display: none;">
            <?php foreach ($users as $value) { ?>
                <div  draggable="true" ondragstart="dragUser(event)"   title="<?= $value->getFullname() ?>" style="display: none; background: <?= random_color_part() ?>" class="ws-avatar" id="wsavatar_<?= $value->id ?>" data-id="<?= $value->id ?>"><?= $value->getAvatar() ?></div>
            <?php } ?>
        </div>
        <div class="workspace-card card" style="width: 0%;border:solid 1px #fff;">
            <div class="card-header panel-theame " style=" background-color:#fff;"></div>
            <div id="workspace_id_0" class="card-body card0" style="width: 0%;height: 100%;"></div>
        </div>
        <?php
        $workspacelist = Workspace::model()->findAll(array('condition' => $condition, 'order' => 'id'));
        foreach ($workspacelist as $value) { ?>
            <style>
                .card<?= $value->id ?> .noDrop{
                    background-color:<?= $value->color_code ?> !important;
                    color:#808080;
                }
            </style>
            <div class="workspace-card card"   >
                <div class="card-header panel-theame " style=" background-color:<?= $value->bg_color_code ?>"><b style="color: #3f3f3f; "><br><?= $value->name ?><!-- <br><span id="ws_total_<?= $value->id ?>">00.00</span> --></b></div>
                <div id="workspace_id_<?= $value->id ?>" class="card-body card<?= $value->id ?>"style="width: 100%;height: 100%;"  ondrop="drop(event, $(this))" ondragover="allowDrop(event)" ></div>
            </div>
            <div class="workspace-card card" style="width: 0%;border:solid 1px #fff;">
                <div class="card-header panel-theame " style=" background-color:#fff;"></div>
                <div id="workspace_id_0" class="card-body card0" style="width: 0%;height: 100%;"></div>
            </div>
        <?php } ?>
    </div>
</section>