<script>
    function LoadOrder() {
        var table_id = "#tble_order";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            //data.status = $("#status").val();
            return data;
        }).DataTable({
            scrollY: "450px",
            pageLength: 50,
            retrieve: true,
            processing: true,

            columnDefs: [
                {
                    //"targets": [11],
                    //"visible": false,
                },
                // {"bSortable": false, "aTargets": [8]},
            ],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('customer/getorderlist') ?>",
                type: "POST",
                cache: false,
                data: {
                    id: '<?= $id ?>'
                },
            },
            serverSide: true,
            fixedColumns: true,

        });

    }
</script>


<div class="custom-data-table">
    <!-- <table class="table table-hover table-bordered personal-task" id="tble_order">
        <thead>
            <tr>
            <th>File</th>
                           <th>Order#</th>
                           <th>Date</th>
                            <th>Customer</th>
                            <th>Sales Group</th>
                            <th>Lead Owner</th>
                            <th>Dly.Date</th>
                            <th>VAT</th>
                            <th>Total</th>
                            <th>Status</th>
                            <th>Actions</th>
            </tr>
        </thead>
    </table> -->


    <table class="alert alert-success table table-hover table-bordered personal-task" id="tbl_customer_contact"
           style="font-size:13px;">
        <thead>
        <tr>
            <th colspan="5"><span
                        style="background-color: orange;color:white;width:250px;text-align:center;border-radius:5px;"><b></b></span>
            </th>
        </tr>
        <tr>
            <th>#</th>
            <th>File</th>
            <th>Order#</th>
            <th>Date</th>
            <!-- <th>Customer</th> -->
            <th>Sales Group</th>
            <!-- <th>Lead Owner</th> -->
            <!-- <th>Dly.Date</th> -->
            <!-- <th>VAT</th> -->
            <th>Total</th>
            <th>Status</th>
            <th>Actions</th>
            <!-- <th width="5%">No</th> -->
        </tr>
        </thead>
        <tbody>
        <?php
        $model = new Order();
        $condition = 't.isActive="Y"  AND  customer.id = ' . $id;
        $order_list = $model->with('leadowner', 'crmUser', 'customer', 'file')->findAll(array('condition' => $condition, 'order' => 't.id DESC'));
        if (!empty($order_list)) {
            $i = 0;
            foreach ($order_list as $key => $order) {
                switch ($order['file']['current_process_status']) {
                    case 'PI':
                        $status = "Partially Invoiced";
                        break;
                    case 'PD':
                        $status = "Partially Delivered";
                        break;
                    case 'I':
                        $status = "Invoiced";
                        break;
                    case 'D':
                        $status = "Delivered";
                        break;
                    case 'O':
                        $status = "Order";
                        break;
                    case 'P_O':
                        $status = "Order";
                }
                $i++;
                ?>
                <tr>
                <td><?= $i ?></td>
                <td><?php echo $order['file_id']; ?></td>
                <td><?php echo $order['id']; ?></td>
                <td><?php echo date("d/m/Y", strtotime($order['order_date'])); ?></td>
                <!-- <td><?php // echo $order['customer']['customer_name']; ?></td> -->
                <td><?php echo $order['salesgroup']['group_name']; ?></td>
                <!-- <td><?php // echo $order['leadowner']['first_name'] . " " . $order['leadowner']['last_name']; ?></td> -->
                <!-- <td><?php // echo date("d/m/Y", strtotime($order['delivery_date'])) ;  ?></td> -->
                <!-- <td><?php // echo Yii::app()->numberFormatter->formatCurrency($order['total_tax_amount'], "") ;  ?></td> -->
                <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency(($order['grand_total']), ""); ?></td>
                <td><?php echo $status; ?></td>
                <td>
                    <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank"
                       href="?r=order/PrintOrderReportPDF&id=<?php echo $order->id; ?>&c_id=<?php echo $order->crm_user_id; ?>"><i
                                class="fa fa-file-pdf-o"></i></a>
                    <!-- <a class="btn btn-primary btn-xs" title="Print Proforma PDF" target="_blank" href="?r=order/PrintProformaReportPDF&id=<?php echo $order->id; ?>&c_id=<?php echo $order->crm_user_id; ?>"><i class="fa fa-file-pdf-o"></i></a> -->
                </td>
                <?php
            }
        } else {
            ?>
            <tr>
                <td class="text-center" colspan="10">No Records Found</td>
            </tr>
            <?php
        }
        ?>
        </tbody>
    </table>
</div>
