<?php
$model = new Customer();
$model = $model->findByPk($id);
?>
<div class="row">
    <div class="col-sm-3">
        <?php
        $typeArray = ActivityType::getAllActivityType();
        $sql = "SELECT `task_type` , COUNT(*) as qty FROM `crm_activity` where customer_id = {$id}  GROUP BY `task_type`";
        $rawData = Yii::app()->db->createCommand($sql)->queryAll();
        $labelArray = [];
        $countArray = [];
        foreach ($rawData as $key => $value) {
            $labelArray[] = $typeArray[$value['task_type']];
            $countArray[] = (int) $value['qty'];
        }


        //https://www.chartjs.org/docs/latest/charts/doughnut.html#doughnut
        $dataArray = [
            "type" => 'doughnut',
            "options" => [
                "responsive" => true,
                "title" => [
                    "display" => true,
                    "text" => empty($countArray) ? "Activity (No data to display)" : 'Activity'
                ],
            ],
            "data" => [
                "labels" => $labelArray,
                "datasets" => [
                    ["label" => "meeting",
                        "data" => $countArray,
                        "backgroundColor" => ['rgb(205, 40, 132)',
                            'rgb(54, 162, 235)',
                            'red',
                            'green',
                            'yellow',
                            'blue',
                            'rgb(255,  86, 205)',
                            'rgb(255, 99, 132)',
                            'rgb(52, 142, 200)',
                            'rgb(255, 205, 86)'
                        ]
                    ],
                ],
            ],
        ];
        ?>

        <canvas id="myChart10" width="100px" height="100px"></canvas>
        <script>
            function setgraph() {
                var ctx = document.getElementById('myChart10');
                new Chart(ctx, <?php echo json_encode($dataArray); ?>);

            }
        </script>

    </div>
    <div class="col-sm-3">
        <?php
        $sql = "SELECT YEAR(invoice_date) as 'y', sum(`grand_total`) as 'total', count(*) as freq  FROM `crm_invoice` WHERE crm_invoice.company_id = " . $id . " group by YEAR(invoice_date) ORDER BY YEAR(invoice_date) DESC";
        $rawData = Yii::app()->db->createCommand($sql)->queryAll();
        $labelArray = [];
        $countArray = [];
        $dataset = [];
        $no_invoice_contribution = true;
        foreach ($rawData as $key => $value) {
            $no_invoice_contribution = false;
            $sqlSum = "select sum(`grand_total`) as 'total'   FROM `crm_invoice` WHERE  crm_invoice.company_id != " . $id . " AND YEAR(invoice_date) = " . $value['y'];
            $net_total = (int) Yii::app()->db->createCommand($sqlSum)->queryScalar();
            $dataset[] = ["label" => "in " . $value['y'],
                "tooltip" => "Year",
                "data" => [(int) $value['total'], $net_total],
                "backgroundColor" => [
                    'rgb(54, 162, 235)', 'rgb(255, 255, 255)']
            ];
        }
        $dataArray = [
            "type" => 'doughnut',
            "options" => [
                "responsive" => true,
                "title" => [
                    "display" => true,
                    "text" => 'Invoice Contribution per Year'
                ],
            ],
            "data" => ["labels" => [$model->customer_name, "Total"],
                "datasets" => $dataset
        ]];
        ?>
        <canvas id="myChartInvAmount" width="100px" height="100px"></canvas>
        <script>
            function setInvgraph() {
                var ctx = document.getElementById('myChartInvAmount');
                new Chart(ctx, <?php echo json_encode($dataArray); ?>);
            }
        </script>


    </div>
    <div class="col-sm-3">
        <?php
        $sql = "SELECT YEAR(invoice_date) as 'y', sum(`grand_total`) as 'total' ,  count(*) as freq FROM `crm_invoice` WHERE crm_invoice.company_id = " . $id . " group by YEAR(invoice_date) ORDER BY YEAR(invoice_date) asc";
        $rawData = Yii::app()->db->createCommand($sql)->queryAll();
        $labelArray = [];
        $countArray = [];
        $valueArray = [];
        foreach ($rawData as $key => $value) {
            $labelArray[] = $value['y'];
            $countArray[] = (int) $value['freq'];
            $valueArray[] = (int) $value['total'];
        }
        $dataArray = [
            "type" => 'bar',
            "options" => [
                "responsive" => true,
                "title" => [
                    "display" => true,
                    "text" => 'Invoice Value (AED)'
                ],
            ],
            "data" => [
                "labels" => $labelArray,
                "datasets" => [
                    ["label" => "AED",
                        "data" => $valueArray,
                    ],
                    ["label" => "No of Invoice",
                        "data" => $countArray,
                    ],
                ],
            ],
        ];
        ?>
        <canvas id="myChartLine" width="100px" height="100px"></canvas>
        <script>
            function setInvLinegraph() {
                var ctx = document.getElementById('myChartLine');
                new Chart(ctx, <?php echo json_encode($dataArray); ?>);
            }
        </script>
    </div>
    <div class="col-sm-3">
        <?php
        $sql = "SELECT YEAR(order_date) as 'y', count(*) as freq FROM `crm_order` WHERE crm_order.company_id = " . $id . " group by YEAR(order_date) ORDER BY YEAR(order_date) asc";
        $rawData = Yii::app()->db->createCommand($sql)->queryAll();
        $labelArray = [];
        $countArray = [];

        foreach ($rawData as $key => $value) {
            $labelArray[] = $value['y'];
            $countArray[] = (int) $value['freq'];
        }
        $dataArray = [
            "type" => 'bar',
            "options" => [
                "responsive" => true,
                "title" => [
                    "display" => true,
                    "text" => empty($countArray) ? "No orders yet" : 'Orders per year'
                ],
            ],
            "data" => [
                "labels" => $labelArray,
                "datasets" => [
                    ["label" => "No of Order",
                        "data" => $countArray,
                    ],
                ],
            ],
        ];
        ?>
        <canvas id="myChartLineOrder" width="100px" height="100px"></canvas>
        <script>
            function setOrderLinegraph() {
                var ctx = document.getElementById('myChartLineOrder');
                new Chart(ctx, <?php echo json_encode($dataArray); ?>);
            }
        </script>
    </div>
</div>
<div class="row">
    <div class="col-sm-3">
        <?php
        $sql = "SELECT YEAR(qtn_start_date) as 'y', count(*) as freq FROM `crm_quotes` WHERE crm_quotes.company_id = " . $id . " group by YEAR(qtn_start_date) ORDER BY YEAR(qtn_start_date) asc";
        $rawData = Yii::app()->db->createCommand($sql)->queryAll();
        $labelArray = [];
        $countArray = [];

        foreach ($rawData as $key => $value) {
            $labelArray[] = $value['y'];
            $countArray[] = (int) $value['freq'];
        }
        $dataArray = [
            "type" => 'bar',
            "options" => [
                "responsive" => true,
                "title" => [
                    "display" => true,
                    "text" => 'Quote per year'
                ],
            ],
            "data" => [
                "labels" => $labelArray,
                "datasets" => [
                    ["label" => "No of Quote",
                        "data" => $countArray,
                    ],
                ],
            ],
        ];
        ?>
        <canvas id="myChartLineQuote" width="100px" height="100px"></canvas>
        <script>
            function setQuoteLinegraph() {
                var ctx = document.getElementById('myChartLineQuote');
                new Chart(ctx, <?php echo json_encode($dataArray); ?>);
            }
        </script>
    </div>

</div>
