<script>
    $(document).ready(function () {

        var table_id = "#tbl_pro_work_details";
        var table = $(table_id).DataTable({
            scrollY: "750px",
            // scrollX         : "true",
            // scrollCollapse  : true,
            pageLength: 50,
            processing: true,
            "order": [[ 1, "asc" ]],
            ajax: {
                url: 'index.php?r=workspace/Projectworkspace/GetList',
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        });
        $(".dataTables_scrollFoot").hide();
    });
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-users"></i> Project Workspace
        <div class="pull-right">
            <button class="btn btn-sm btn-theme" onclick="loadPopupModal('workspace/projectworkspace/create', 'Add New Workspace', 'lg')"><i class="fa fa-plus"></i> ADD</button>
        </div>


    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_pro_work_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Workspace Name</th>
                        <th>Actions</th>
                    </tr>
                </thead>
               
            </table>
        </div>
    </div>
</section>
<script>

    function deleteProjectWorkspaces(id) {
        var msg = "Are you sure you want to delete this item?";
        var dr = confirm(msg);
        if (dr) {
            $.ajax({
                url: "index.php?r=workspace/projectworkspace/deleteItem",
                type: 'POST',
                dataType: 'json',
                data: {id: id},
                beforeSend: function (xhr) {
                    $("#loader").show();
                },
                success: function (data, textStatus, jqXHR) {
                     reloadTable("#tbl_pro_work_details");
                    $("#loader").hide();
                   
                }
            });
        }
    }
</script>
