<?php

/**
 * This is the model class for table "".
 *
 * The followings are the available columns in table
 * @property string $id
 * @property string $title
 * @property string $description
 * @property string $workspace_id
 * @property string $lead_id
 * @property string $po_id
 * @property string $file_id
 * @property string $status
 */
class WorkspaceNote extends CActiveRecord {


    /**
     * @return string the associated database table title
     */
//`title`=[value-2],`description`=[value-3],`due_date`=[value-4],`workspace_id`=[value-5],`created_date_time`=[value-6],`created_by`=[value-7],`updated_date_time`=[value-8],`updated_by`=[value-9] WHERE 1
    public function tableName() {
        return '{{workspace_note}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('title, description, workspace_id,customer_id ', 'required'),
            array('title, description', 'length', 'max' => 255),
            array('due_date,amount', 'length', 'max' => 26),
            array('lead_id,po_id, file_id, sales_group_id, through_id, customer_id,workspace_qtn_id', 'numerical'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('title, description,due_date,workspace_qtn_id,lead_id,po_id,file_id,status', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation title and the related
        // class title for the relations automatically generated below.
        return array(
            'group' => array(self::BELONGS_TO, 'MasSalesGroup', 'sales_group_id'),
            'through' => array(self::BELONGS_TO, 'User', 'through_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id')
        );
    }

    /**
     * @return array customized attribute labels (title=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'title' => 'Title',
            'description' => 'Description',
            'workspace_id' => 'WorkSpace',
            'customer_id'   =>"Customer"
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);

        $criteria->compare('id', $this->id, true);
        $criteria->compare('title', $this->title, true);
        $criteria->compare('description', $this->description, true);

        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.title ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class title.
     * @return MasCompanyBranch the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getActiveWorkSpace() {
        $condition = 'isActive =  "Y" ';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'title'));
        return CHtml::listData($model, 'id', 'title');
    }

    public function getToolTip() {
        $html = "<b>" . $this->title . "</b><br>";
        $html .= "<p>" . $this->description . "</p>";
        if ($this->due_date != "0000-00-00") {
            $html .= "<p>Due " . date("d/m/yy", strtotime($this->due_date)) . "</p>";
        }
        return $html;
    }

}
