<?php

class ProductionSpaceController extends Controller
{
	public function accessRules()
	{
		return array(
			array(
				'allow', // allow all users to perform 'index' and 'view' actions
				'actions' => array('login', 'error', 'logout'),
				'users' => array('*'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array(
					'Index',
					'getlistPO',
					'getUser','UpdateWorkspace'
				),
				'expression' => '$user->isMember()',
			),
			array(
				'deny', // deny all users
				'users' => array('*'),
			),
		);
	}
	public function actionIndex()
	{
		$this->render('index');
	}

	public function actionGetlistPO()
	{

		$condition = " 1 = 1";

		$condition .= ' AND  t.isActive= "Y"';
		$user_id = Yii::app()->user->id;
		$models = ProductionOrder::model()->with()->findAll(array(
			'condition' => $condition,
			'order' => 't.created_datetime DESC'
		));

		$user_list = $this->getUser();

		$data = array();
		foreach ($models as $value) {
			$shared_to = [];
			$_temp_arr = explode(",", $value->created_by);
			foreach ($_temp_arr as $each_user) {
				if (!empty($each_user)) {
					$shared_to[] = array(
						'id' => $each_user,
						'name' => $user_list[$each_user]
					);
				}
			}
			$customer = Customer::model()->findbyPK($value->customer_id);
			$tit_name = "<div class='wrap-text' style='white-space: normal; word-wrap: break-word;word-break: break-word;max-width: 250px;display: inline-block;'>";
			$tit_name .= CHtml::encode($value->product->part_number) . '<br>';
			$tit_name .= CHtml::encode($value->product->description) . '<br>';
			//
			$tit_name .= "</div>";
			$tit_name .= "<apan style='    font-weight: 400;font-size: 12px;float: left;margin-top: 2px;'>" . CHtml::encode(substr($customer->customer_name, 0, 17)) . "</span>";
			if (strlen($customer->customer_name) > 100) {
				$tit_name .= '..';
			}
			$title = "<ul class='label-list' style='display:table'><li style='position:relative;bottom:10px'>" . $tit_name . "</li>";


			if (!empty($value->salesgroup)) {
				$title .= "<li style='font-weight:400'>" . substr($value->salesgroup->group_name, 0, 30) . "</li>";
			}
			$title .= "<li style='text-align:end'>" . number_format($value->quantity, 0) . "</li>";
			if (!empty($value->lead_owner_id)) {
				$title .= "<li style='font-weight:400' >" . $value->leadowner->fullname . "</li>";
			}

			if (!empty($value->created_datetime)) {

				$title .= "<li style='font-weight:400;font-size:12px' >" . date("d/m/Y", strtotime($value->created_datetime)) . "</li>";
			}

			$modelSpaceNote = WorkspaceNote::model()->find(array('condition' => 'po_id=' . $value->id));
			$note_id = 0;
			$space_id = 1;
			if (!empty($modelSpaceNote)) {
				$note_id = $modelSpaceNote->id;
				$space_id = $modelSpaceNote->workspace_id;
				$modelColor = Workspace::model()->findByPk($modelSpaceNote->workspace_id);
			}

			$modelCustomer = Customer::model()->findByPk($value->customer_id);

			// $modelLead = Lead::model()->find(array('condition' => 'workspace_note_id=' . $value->id));
			if (!empty($value->file_id)) {
				$model_Quotes = Quotes::model()->find(array('condition' => 'file_id=' . $value->file_id));
			}


			if (!empty($value->created_datetime)) {
				$created_date = date("d/m/Y", strtotime($value->created_datetime));
			} else {
				$created_date = '00/0/0000';

			}


			$title .= "</ul>";
			$data[] = array(
				'workspace_created_date' => $created_date,
				'workspace_id' => $space_id,
				'quotes_id' => $model_Quotes->id,
				'title' => $title,
				'status' => "N",//$value->status,
				'customer_id' => $value->customer_id,
				'customer_name' => $customer->customer_name,
				'po_id' => $value->id,
				'file_id' => $value->file_id,
				'amount' => $value->items->amount,
				'id' => $note_id,
				'bgcolor' => $modelColor->bg_color_code,
				'quantity' => $value->quantity,
				'shared_to' => $shared_to,
				'product_det' => $value->product->part_number
			);
		}
		echo json_encode($data);
	}
	function getUser()
	{

		$model = User::getUserModels();
		$array = [];
		foreach ($model as $value) {
			$array[$value->id] = $value->getAvatar();
		}
		return $array;
	}
	public function actionUpdateWorkspace()
	{

		$workspace_id = (int) Yii::app()->request->getParam('workspace_id');


		$workspace_qtn_id = $_POST['WorkspaceQtns']['details'];


		$previousWorkSpace_id = 0;
		if ($workspace_id > 0) {
			$item_id = (int) Yii::app()->request->getParam('item_id');
			$model = WorkspaceNote::model()->findByPk($item_id);
			$previousWorkSpace_id = $model->workspace_id;
			$model->workspace_id = $workspace_id;
			$model->workspace_qtn_id = $workspace_qtn_id;
			$model->save();
			echo json_encode(array('status' => 'success', 'prev' => $previousWorkSpace_id, 'po_id' => $model->po_id));
		} else {
			echo json_encode(array('status' => 'failed'));
		}
	}

}