<?php



class MastersubmoduleController extends Controller {



    public function accessRules() {

        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array('login', 'error', 'logout'),

                'users' => array('*'),

            ),

            array('allow', // allow authenticated user to perform 'create' and 'update' actions

                'actions' => array('Index', 'GetList', 'Create', 'Save','savequestions','deleteQuestion', 'Disable','getmoduledetails','getMainModuleFilter','getProjecttype','RemovelineItem','DeleteType'),

                'expression' => '$user->isMember()',

            ),

            array('deny', // deny all users

                'users' => array('*'),

            ),

        );

    }



    public function filters() {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }



    public function actionIndex() {

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->render('index');

    }



   public function actionGetList() {

        $model = new MasProjectModuleDetails();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',

            1 => 'module_details',

        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = '1=1';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition = "  (proj_detail.project LIKE '%" . $searchString . "%')";

        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->with('proj_detail')->findAll(array('condition' => $condition, 'limit' => $limit, 'group'=>'project_id','offset' => $offset,'order' => 'proj_detail.project'));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {

             $div = '';

            $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'workspace/mastersubmodule/create&id=' . $row->project_id . '\',\'Sub Module\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            $div .= ' <button class="btn btn-primary btn-xs" onclick="DeleteType('.$row->id.')"><i class="fa fa-close"></i></button>';

           // $rowData[] = array($m, $row->module, $row->id);

            $rowData[] = array($m,

                $row->proj_detail->project,

                '<div class="btn-wrap text-center">' . $div . '</div>',

                $row->id,

            );

            $m++;

        }

        $data['data'] = $rowData;

        echo json_encode($data);

    }





     public function actionCreate() {

        $model = array(new MasProjectModuleDetails());

        $id = (int)Yii::app()->request->getParam('id');

        if ($id>0) {

            $model = MasProjectModuleDetails::model()->findAll(array('condition'=>'project_id="'.$id.'"'));

            if(empty($model)){

                $model = array(new MasProjectModuleDetails());

            }

        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('create', array('model' => $model,'id'=>$id), false, true);

    }



    

 public function actionSave() {

        if (isset($_POST['MasProjectModuleDetails'])) {   

            $total=0;

            $other_error=array();

            $validate=true;

          //  $key_value=$this->nextkeyvalue();

            foreach ($_POST['MasProjectModuleDetails'] as $i => $itm) {  

                if ($itm['id'] > 0) {

                    $model[$i] = MasProjectModuleDetails::model()->findByPK($itm['id']);

                    $model[$i]->updated_by = Yii::app()->user->id;

                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');

                }else{

                    $model[$i] = new MasProjectModuleDetails();

                    $model[$i]->created_by = Yii::app()->user->id;

                    $model[$i]->created_date_time = date('Y-m-d H:i:s');

                  //  $model[$i]->key_value = $key_value;

                }

                $model[$i]->project_id = $_POST['project'];

                $model[$i]->main_module_id  = $_POST['MasProjectModuleDetails_0_main_module_id'];

                $model[$i]->module_details = $itm['module_details'];

                $model[$i]->weightage_percent = $itm['weightage_percent'];

                $total+=$itm['weightage_percent'];

                $validate=$model[$i]->validate() && $validate;

            }

            if($total!=100){

                $validate=false;

                $other_error[]='Total Weightage must be equal to 100';

            }

          

            if ($validate) {                

                if (!empty($model)) {

                    foreach ($model as $eachModel) {

                        $eachModel->save();

                    }

                }

                $jsonData['status'] = 'success';

                echo CJSON::encode($jsonData);

            } else {             

                $error1 = json_decode(CActiveForm::validateTabular($model, '', false), true);

                $error = CJSON::encode(array_merge_recursive($error1, $other_error));

                if ($error != '[]')

                    echo $error;

            }

        }

        Yii::app()->end();

    }







    public function actiondeleteQuestion(){

        $id = $_POST['id'];

        if($id>0){

            $model = new MasProjectModuleDetails();                

            $model->deleteByPk($id);

            $jsonData['status'] = 'success';

        }

        else{

           $jsonData['status'] = 'error';

        }

        echo CJSON::encode($jsonData);

    }

    public function actionDisable() {

        $id = Yii::app()->request->getparam('id');

        $status = Yii::app()->request->getparam('status');

        $new_status=($status == "Y" ) ? "N" : "Y";

        HrAppraisalQuestions::model()->updateAll(array('isActive' =>$new_status), 'department_id="'.$id.'"');

        echo json_encode(array("status" => "success"));

    }

    public function actiongetmoduledetails() {

        $id = Yii::app()->request->getparam("module");

        if (!empty($id)) {

            $model_type= MasProjectModule::model()->findAll(array('condition'=>'module="'.$id.'"'));

            $model = MasProjectModuleDetails::model()->findAll(array('condition'=>'submodule_id="'.$model_type->id.'"'));

            if(empty($model)){

                $model = array(new MasProjectModuleDetails());

            }

            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);

            $this->render('module_data', array('model' => $model,'module' => $id));

        }else{

            throw new CHttpException(404, 'Page not found.');

        }



    }





     public function actiongetMainModuleFilter() {

        $project_id = $_POST['id'];

        $arr_modules = MasProjectModule::getmoduleList($project_id);

        $model_type= new MasProjectModuleDetails();

        if(!empty($arr_modules)){

        $data['subloc'] = CHtml::activeDropDownList($model_type, "[0]main_module_id", $arr_modules, array('data-label' => 'Module','onChange' => 'getProjecttype()'));

    }

        echo CJSON::encode($data);



    }

     public function actiongetProjecttype() {

        $id = Yii::app()->request->getparam("project");

        $module_id = Yii::app()->request->getparam("module_id");

        $condition = "1=1";

        if (!empty($id)) {



            $condition .= ' AND project_id="'.$id.'"';

        }



        if (!empty($module_id )) {



            $condition .= " AND main_module_id = " . $module_id;

        }

        if (!empty($id)) {

            $model= MasProjectModuleDetails::model()->findAll(array('condition'=> $condition));

            if(empty($model)){

                $model = array(new MasProjectModuleDetails());

            }

            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);

            $this->render('sub_module_details', array('model' => $model,'module' => $id));

        }else{

            throw new CHttpException(404, 'Page not found.');

        }



    }

    public function actionRemovelineItem(){

        $id = $_POST['id'];

        if($id>0){

            MasProjectModuleDetails::model()->deleteByPk($id);

           $status['status'] = 'success';

        }

        else{

           $status['status'] = 'error';

        }

        echo CJSON::encode($status);

    }
    public function actionDeleteType(){

        $id = $_POST['id'];

        if($id>0){

            MasProjectModuleDetails::model()->deleteByPk($id);

           $status['status'] = 'success';

        }

        else{

           $status['status'] = 'error';

        }

        echo CJSON::encode($status);

    }


}

