<?php
//Created by DIkson R on 27/4/2022
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'siteattendance-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo CHtml::dropDownList('project_title_id', '', WsProject::getProject(), array('data-label' => 'Project', 'empty' => 'Select')); ?>
            </li>
             <li class="col-sm-3">
                <input type="hidden" id="max_date" value="<?php echo date("d/m/Y"); ?>" />   
                <?php echo CHtml::textfield('project_date', '', array('data-label' => 'Date','class'=>'datepicker')); ?>
            </li>
            <li class="col-sm-3">
                <button type="button" class="btn btn-theme " onclick="loaddetails();">Load</button>    
            </li>
        </ul>
    </div>
</div>
<br/>
<div id="employee_site_attendance"></div>
<?php
$this->endWidget(); 
$cs = Yii::app()->getClientScript();
$cs->registerScript("datepickerfield", "$(document).ready(function() {
    var max_date = $('#max_date').val().split('/');
    var max_date = new Date(max_date[2], max_date[1] - 1, max_date[0]);
    $('#project_date').datetimepicker({maxDate: max_date, format: 'DD/MM/YYYY'});
});", CClientScript::POS_HEAD);
$cs->registerScript("loaddetails", "function loaddetails() {
        var project_id  = $('#project_title_id').val();
        var project_date  = $('#project_date').val();
        if(project_id!='' && project_date!=''){
            jQuery.ajax({
                'data' : {'project_id':project_id,'project_date':project_date},
                'type':'post',
                'url': '" . Yii::app()->createUrl('workshop/projecttimesheet/loademployeedetails') . "',
                'cache': false,
                'success': function(data) {
                    $('#employee_site_attendance').html(data);
                }, 
                'beforeSend':function(){
                  $('#loader').show();                      
                },
                'complete':function(){
                    $('#loader').hide();   
                }
            });     
        }else{
            if(project_id==''){
                t8.error('Select Project'); 
            }else if(project_date==''){
                t8.error('Select Date'); 
            }
        }
    };", CClientScript::POS_HEAD);
?>

