<?php
$cs = Yii::app()->getClientScript();
?>

<script>
    $(document).ready(function () {
        
    var table_id = "#tble_bill_material";
    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
    
    return data;
    }).DataTable({
    scrollY: "645px",
            pageLength: 50,
            processing: true,
            "order": [[ 1, "asc" ]],
            ajax: {
            url: "<?php echo Yii::app()->createUrl('workshop/billofmaterial/GetBill') ?>",
                    type: "POST",
                    cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) 
            {
                AddContextMenu(nRow, aData);
            }
            
    });
    });
 function AddContextMenu(row, datas) {
        var mas_edit=0;
        var mas_disable=0;
        <?php if (isset(Yii::app()->user->havePermissionOn['master_country_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_edit=1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['master_country_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_disable=1;
        <?php } ?> 
        $(row).contextMenu({
        selector: 'td',
            items: {
            "edit": {

                name: "Edit",
                        icon: "edit",
                        accesskey: "e",
                        callback: function () {
                        loadPopupModal("workshop/billofmaterial/create&id="  + datas[5]['id'],"Edit - "+datas[5]['part_number'], "xl");
                        }, 
                    disabled: function(key, opt) { 
                        // this references the trigger element
                        if(mas_edit=='0'){
                            return !this.data('editDisabled'); 
                        }
                    }
                },
                 "print": {

                name: "Print Bill Of Material",
                        icon: "fa-print",
                        accesskey: "e",
                        callback: function () {
                        window.open($('#liveSite').val()+"/index.php?r=workshop/billofmaterial/PrintBillofmaterialReportPDF&id="+datas[5]['id'],"_blank");
                        }, 
                    disabled: function(key, opt) { 
                        // this references the trigger element
                        if(mas_edit=='0'){
                            return !this.data('editDisabled'); 
                        }
                    }
                },
                

            }
    });
    }
</script>

<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-bank"></i> Bill Of Materials
        <div class="top_controls_select col-sm-8 pull-right">                
            <div class="col-sm-1 pull-right">
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('workshop/billofmaterial/create', 'Add New Bill', 'lg')"> <i class="fa fa-plus"></i> ADD</button>
            </div>
            
            
        </div>

    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tble_bill_material" style="font-size:13px;">

                      <thead>
                        <tr>
                           <th>No.</th>
                           <th>Product</th>
                            <th>Description</th>
                            <th>Quantity</th>
                        </tr>
                    </thead>
                </table>
        </div>
    </div>
</section>