<?php

/**
 * This is the model class for table "{{ws_project_time_sheet}}".
 *
 * The followings are the available columns in table '{{ws_project_time_sheet}}':
 * @property integer $id
 * @property integer $project_id
 * @property integer $task_category_id
 * @property integer $task_subcategory_id
 * @property string $project_date
 * @property string $task_start_date_time
 * @property string $task_end_date_time
 * @property integer $assigned_person_id
 * @property string $project_task_hours
 * @property string $time_sheet_notes
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class WsProjectTimeSheet extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	 
	public $task_category;
	public function tableName()
	{
		return '{{ws_project_time_sheet}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('task_category_id', 'required'),
			array('project_id, task_category_id, task_subcategory_id, assigned_person_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('task_category_id, task_subcategory_id, project_date, task_start_date_time, task_end_date_time, assigned_person_id, project_task_hours, time_sheet_notes, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		   
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'project_id' => 'Project',
			'task_category_id' => 'Task Category',
			'task_subcategory_id' => 'Task Subcategory',
			'project_date' => 'Project Date',
			'task_start_date_time' => 'Task Start Date Time',
			'task_end_date_time' => 'Task End Date Time',
			'assigned_person_id' => 'Assigned Person',
			'project_task_hours' => 'Project Task Hours',
			'time_sheet_notes' => 'Time Sheet Notes',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('project_id',$this->project_id);
		$criteria->compare('task_category_id',$this->task_category_id);
		$criteria->compare('task_subcategory_id',$this->task_subcategory_id);
		$criteria->compare('project_date',$this->project_date,true);
		$criteria->compare('task_start_date_time',$this->task_start_date_time,true);
		$criteria->compare('task_end_date_time',$this->task_end_date_time,true);
		$criteria->compare('assigned_person_id',$this->assigned_person_id);
		$criteria->compare('project_task_hours',$this->project_task_hours,true);
		$criteria->compare('time_sheet_notes',$this->time_sheet_notes,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return WsProjectTimeSheet the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
