<?php

/**
 * This is the model class for table "{{project_estimation_details}}".
 *
 * The followings are the available columns in table '{{project_estimation_details}}':
 * @property integer $id
 * @property integer $project_estimation_id
 * @property integer $product_id
 * @property integer $estimation_phase_id
 * @property string $description
 * @property string $size
 * @property integer $brand
 * @property integer $quantity
 * @property integer $unit
 * @property string $support_cost
 * @property string $material_price
 * @property string $percentage_wastage
 * @property string $unit_price
 * @property string $total_material_cost
 * @property string $hours_per_person
 * @property string $labour_cost_per_item
 * @property string $labour_contingency
 * @property string $labour_cost
 * @property string $total_cost_for_labour
 * @property string $total_amount
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $markup_price
 * @property string $total_sale_value
 */
class WsProjectEstimationDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */

	public function tableName()
	{
		return '{{`ws_project_estimation_details`}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
     public $brand_name;
        public $unit_name;
        public $description_1;
        public $size_1;
        public $brand_name_1;
        public $quantity_1;
        public $unit_name_1;
        public $total_material_cost_1;
        public $total_cost_for_labour_1;

	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(

			//array('project_estimation_id,product_id,estimation_phase_id,description,size,brand,quantity,unit,support_cost,material_price,percentage_wastage,unit_price,total_material_cost,hours_per_person,labour_cost_per_item,labour_contingency,labour_cost,total_cost_for_labour,total_amount,created_by, created_date_time, updated_by, updated_date_time', 'required'),

			array('description,product_id,phase_id,quantity,unit,unit_price', 'required'),
			array('project_id, product_id, phase_id,category_id, brand, quantity, unit, created_by, updated_by,markup_price', 'numerical', 'integerOnly'=>true),
			array('description,size', 'length', 'max'=>255),
			array(' material_price, unit_price, total_material_cost,total_sale_value,labour_cost', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, project_id, product_id, phase_id, description, size, brand, quantity, unit,  material_price,  unit_price, total_material_cost,total_sale_value,markup_price,labour_cost, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'brand_detail' => array(self::BELONGS_TO, 'MasInvBrand','brand'),
            'unit_detail' => array(self::BELONGS_TO, 'Unit', 'unit'),
            //'phase_detail' => array(self::BELONGS_TO, 'WsProjectPhaseDetails','phase_id'),
            'phase_detail' => array(self::BELONGS_TO, 'WsProjectPhase','phase_id'),
            'category_detail' => array(self::BELONGS_TO, 'MasGeneric','category_id'),
            'product_details' => array(self::BELONGS_TO, 'Store','product_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'project_id' => 'Project',
			'product_id' => 'Product',
			'phase_id' => 'Phase',
			'category_id' => 'Category Id',
			'description' => 'Description',
			'size' => 'Size',
			'brand' => 'Brand',
			'quantity' => 'Quantity',
			'unit' => 'Unit',
			'material_price' => 'Material Price',
			'unit_price' => 'Unit Price',
			'total_material_cost' => 'Total Material Cost',
			'hours_per_person' => 'Hours Per Person',
			'labour_cost_per_item' => 'Labour Cost Per Item',
			'labour_contingency' => 'Labour Contingency',
			'labour_cost' => 'Labour Cost',
			'total_cost_for_labour' => 'Total Cost For Labour',
			'total_amount' => 'Total Amount',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('project_id',$this->project_estimation_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('phase_id',$this->estimation_phase_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('size',$this->size,true);
		$criteria->compare('brand',$this->brand);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('unit',$this->unit);
		$criteria->compare('material_price',$this->material_price,true);
		$criteria->compare('unit_price',$this->unit_price,true);
		$criteria->compare('total_material_cost',$this->total_material_cost,true);
		$criteria->compare('hours_per_person',$this->hours_per_person,true);
		$criteria->compare('labour_cost_per_item',$this->labour_cost_per_item,true);
		$criteria->compare('labour_contingency',$this->labour_contingency,true);
		$criteria->compare('labour_cost',$this->labour_cost,true);
		$criteria->compare('total_cost_for_labour',$this->total_cost_for_labour,true);
		$criteria->compare('total_amount',$this->total_amount,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	
	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProjectEstimationDetails the static model class
	 */

	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
