<?php

/**
 * This is the model class for table "{{ws_project_activities}}".
 *
 * The followings are the available columns in table '{{ws_project_activities}}':
 * @property integer $id
 * @property integer $project_id
 * @property string $activities_details
 * @property string $total_value
 *   @property string $previous_work_progress
 *  @property string $present_work_progress


 * @property integer $created_by
 * @property integer $phase_id

 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class WsProjectActivities extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ws_project_activities}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
        return array(
			array('project_id,present_work_progress,previous_work_progress,phase_id,activities_details', 'required'),
			array('project_id,phase_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('id, project_id,total_value,phase_id,reload_activity,activities_details,present_work_progress,previous_work_progress, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'project' => array(self::BELONGS_TO, 'WsProject', 'project_id'),
					'phase_detail' => array(self::BELONGS_TO, 'WsProjectActivityPhase','phase_id'),

                  
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'project_id' => 'Project',
                        'activities_details' => ' description',
						'present_work_progress' => ' Present work progress',
						'previous_work_progress' => ' Previous work progress',
                      

		
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('project_id',$this->project_id);
		$criteria->compare('activities_details',$this->activities_details);

		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return WsProjectWorkTime the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
