<?php

/**
 * This is the model class for table "{{ws_job_process_details}}".
 *
 * The followings are the available columns in table '{{ws_job_process_details}}':
 * @property integer $id
 * @property integer $job_id
 * @property integer $process_id
 * @property integer $user_id
 * @property string $process_date_time
 * @property string $is_completed
 * @property string $remarks
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class JobProcessDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	 public $stage_id;
	public $user_name; 
	public function tableName()
	{
		return '{{ws_job_process_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('job_id, process_id,process_date_time', 'required'),
			array('job_id, process_id, user_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('is_completed', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, job_id, process_id, user_id, process_date_time, is_completed, remarks, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'jobstage_details' => array(self::BELONGS_TO, 'MasterProcessStages','process_id'),
            'user_details' => array(self::BELONGS_TO, 'User','user_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_id' => 'Job',
			'process_id' => 'Process',
			'user_id' => 'User',
			'process_date_time' => 'Process Date Time',
			'is_completed' => 'Is Completed',
			'remarks' => 'Remarks',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_id',$this->job_id);
		$criteria->compare('process_id',$this->process_id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('process_date_time',$this->process_date_time,true);
		$criteria->compare('is_completed',$this->is_completed,true);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return JobProcessDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
