<?php

/**
 * This is the model class for table "{{ws_compressor_time}}".
 *
 * The followings are the available columns in table '{{ws_compressor_time}}':
 * @property integer $id
 * @property integer $compressor_id
 * @property string $type
 * @property string $description
 * @property string $part_number
 * @property string $service_time
 * @property string $production_time
 * @property string $stage_id
 * @property string $normal_time
 * @property integer $created_by
 * @property string $created_date_time
 */
class CompressorTime extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{ws_compressor_time}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('compressor_id', 'required'),
			array('id, compressor_id, created_by', 'numerical', 'integerOnly'=>true),
			array('type, description, part_number, service_time, production_setup,production_time, normal_time', 'length', 'max'=>255),
			array('created_date_time', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, compressor_id, type, description,stage_id, part_number, service_time, production_time, normal_time, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'compressor_stages' => array(self::BELONGS_TO, 'MasterCompressorStages','description'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'compressor_id' => 'Compressor',
			'type' => 'Type',
			'description' => 'Description',
			'part_number' => 'Part Number',
			'stage_id' => 'Stage Id',
			'service_time' => 'Service Time',
			'production_time' => 'Production Time',
			'normal_time' => 'Normal Time',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('compressor_id',$this->compressor_id);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('part_number',$this->part_number,true);
		$criteria->compare('service_time',$this->service_time,true);
		$criteria->compare('production_time',$this->production_time,true);
		$criteria->compare('normal_time',$this->normal_time,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CompressorTime the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
