<?php
class TimesheetController extends Controller {

   public $layout = 'layout';
   

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','employeedetails','JobDetails','CheckIn','TVIndex','getTVdetails','Admin','adminemployeedetails','ProjectDetails','Proj_CheckIn'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    /*
     * function to list quotes
     * modified by jisha on 10-05-21. 
     */

    public function actionIndex() 
    {
        $this->render('index');
    }
    
    public function actionAdmin() 
    {
        $this->render('admin');
    }
    
    public function actionemployeedetails(){
        date_default_timezone_set("Asia/Dubai");
        $employee_code=$_POST['employee_code'];
        $type=$_POST['type'];
        $searchString_en=$this->ciphertext($employee_code,"e");
        $model=Employee::model()->find(array('condition'=>'employee_code = "'.$searchString_en.'"'));
        if(!empty($model)){
            $modeljobtime = new WsJobTimesheet();
            $modeljobtime =WsJobTimesheet::model()->find(array('condition'=>'status="A" AND employee_id="'.(int)$model->id.'"'));
            if(!empty($modeljobtime)){
                $json_data['in_status']='checked_in'; 
                if($type=='out'){
                    $modeljobtime->checkout_time=date('Y-m-d H:i:s');
                    $modeljobtime->status='C';
                    $modeljobtime->updated_by=Yii::app()->user->id;
                    $modeljobtime->updated_date_time=date('Y-m-d H:i:s');
                    $modeljobtime->save(false);
                    $mod_job=new JoborderHeader();
                    $mod_job =JoborderHeader::model()->find(array('condition'=>'id ="'.(int)$modeljobtime->job_id.'"'));
                    $mod_job->actual_end_date = $modeljobtime->checkout_time;
                    $mod_job->save(false);
                }
            }else{
                $json_data['in_status']='checked_out';
            }
            $json_data['status']='success';
            $json_data['emp_id']=$model->id;
            $json_data['emp_name']=$model->employeefullname;
            $json_data['emp_code']=$model->employeecode;
        }else{
            $json_data['status']='fail'; 
             $json_data['emp_code']=$employee_code;
        }
        echo json_encode($json_data);
    }
	
	public function actionadminemployeedetails(){
        date_default_timezone_set("Asia/Dubai");
        $employee_code=$_POST['employee_code'];
        $type=$_POST['type'];
        $searchString_en=$this->ciphertext($employee_code,"e");
        $model=Employee::model()->find(array('condition'=>'id = "'.$employee_code.'"'));
		//echo '<pre>'; print_r($model); exit;
        if(!empty($model)){
            $modelAdminTimesheet = new WsAdminTimesheet();
            $modelAdminTimesheet =WsAdminTimesheet::model()->find(array('condition'=>'status="A" AND employee_id="'.(int)$model->id.'"'));
            if(!empty($modelAdminTimesheet)){
                $json_data['in_status']='checked_in'; 
                if($type=='out'){
                    $modelAdminTimesheet->checkout_time=date('Y-m-d H:i:s');
                    $modelAdminTimesheet->status='C';
                    $modelAdminTimesheet->updated_by=Yii::app()->user->id;
                    $modelAdminTimesheet->updated_date_time=date('Y-m-d H:i:s');
                    $modelAdminTimesheet->save(false);
                    
                    
                    $mod_job=new WsProject();
                    $mod_job =WsProject::model()->find(array('condition'=>'id ="'.(int)$modelAdminTimesheet->proj_id.'"'));
                    $mod_job->actual_end_date = $modelAdminTimesheet->checkout_time;
                    $mod_job->save(false);
                    
                    $modelProjectTimeSheet   = new WsProjectTimeSheet();
					$modelProjectTimeSheet   = WsProjectTimeSheet::model()->find(array('condition' => 'project_id="' . $modelAdminTimesheet->proj_id . '" AND proj_det_id ="'.$modelAdminTimesheet->proj_details_id.'" '));
					
					$modelProjectTimeSheet->task_end_date_time = $modelAdminTimesheet->checkout_time;$modelProjectTimeSheet->save(false);
					$modelProjectTimeSheet->save(false);
					$modelProjectTimeSheet   = WsProjectTimeSheet::model()->find(array('condition' => 'project_id="' . $modelAdminTimesheet->proj_id . '" AND proj_det_id ="'.$modelAdminTimesheet->proj_details_id.'" '));
					$time1 = $modelProjectTimeSheet->task_end_date_time;
					$time2 = $modelProjectTimeSheet->task_start_date_time;
				    
					$timestamp1 = strtotime($time2);
						$timestamp2 = strtotime($time1);
						
						$hour = $timestamp1 - $timestamp2;
						$hours = gmdate('H:i', $hour);
					
					$modelProjectTimeSheet->project_task_hours = $hours;
					$modelProjectTimeSheet->save(false);
                }
            }else{
                $json_data['in_status']='checked_out';
            }
            $json_data['status']='success';
            $json_data['emp_id']=$model->id;
            $json_data['emp_name']=$model->employeefullname;
            $json_data['emp_code']=$model->employeecode;
        }else{
            $json_data['status']='fail'; 
             $json_data['emp_code']=$employee_code;
        }
        echo json_encode($json_data);
    }
	
	/*public function actionadminemployeedetails(){
        date_default_timezone_set("Asia/Dubai");
        $employee_code=$_POST['employee_code'];
        $type=$_POST['type'];
        $searchString_en=$this->ciphertext($employee_code,"e");
        $model=Employee::model()->find(array('condition'=>'id = "'.$employee_code.'"'));
		//echo '<pre>'; print_r($model); exit;
        if(!empty($model)){
            $modelAdminTimesheet = new WsAdminTimesheet();
            $modelAdminTimesheet =WsAdminTimesheet::model()->find(array('condition'=>'status="A" AND employee_id="'.(int)$model->id.'"'));
            if(!empty($modelAdminTimesheet)){
                $json_data['in_status']='checked_in'; 
				
                if($type=='out'){
                    $modelAdminTimesheet->checkout_time=date('Y-m-d H:i:s');
                    $modelAdminTimesheet->status='C';
                    $modelAdminTimesheet->updated_by=Yii::app()->user->id;
                    $modelAdminTimesheet->updated_date_time=date('Y-m-d H:i:s');
                    $modelAdminTimesheet->save(false);
                    $mod_job=new WsProject();
                    $mod_job =WsProject::model()->find(array('condition'=>'id ="'.(int)$modelAdminTimesheet->proj_id.'"'));
                    $mod_job->actual_end_date = $modelAdminTimesheet->checkout_time;
                    $mod_job->save(false);
                }
            }else{
                $json_data['in_status']='checked_out';
            }
            $json_data['status']='success';
            $json_data['emp_id']=$model->id;
            $json_data['emp_name']=$model->employeefullname;
            $json_data['emp_code']=$model->employeecode;
        }else{
            $json_data['status']='fail'; 
             $json_data['emp_code']=$employee_code;
        }
        echo json_encode($json_data);
    }*/
    
    public function actionJobDetails(){
        $job_card_no = $_POST['job_card_no'];
        $emp_id      = $_POST['emp_id'];
        
        $model = JoborderHeader::model()->find(array('condition'=>'id = "'.$job_card_no.'" AND (status = "S" OR status = "A")','order'=>'id DESC'));
        
        if(!empty($model)){
            $modelCustomer = Customer::model()->find(array('condition'=>'id = "'.$model->customer_id.'"'));
            $jobdetails ='Job ID - '.$model->id .' / '. 'By - '.$modelCustomer->customer_name;
            //if($model->status!=A)
            //{
                $modeldetails =JoborderDetails::model()->findAll(array('condition' => 'job_id="' . $model->id . '"', 'order' => 'id ASC'));
            //}
            /*else{
                $det_cndn='job_id="' . $model->id . '" AND proceed_to_job="Y" AND FIND_IN_SET('.$emp_id.',actual_employee_id) ';
                $modeldetails =JobOrderDetails::model()->findAll(array('condition' =>$det_cndn , 'order' => 'id ASC'));
            }*/
            if(!empty($modeldetails)){
                 $modelProcessType = MasterProcessType::model()->findAll(array('order' => 'id ASC'));
                //$json_data['drop'] ='<button type="button" id="btnckin_0" class="btn btn-sm btn-primary" style="margin-top:2px;margin-bottom:2px" data-jobdetailid="0" data-jobid="'.$model->id.'" onclick="setcheckin(this.id)">General</button>';
                foreach($modelProcessType as $each){
                    $json_data['drop'] .='<br/><button type="button" id="btnckin_'.$each->id.'" class="btn btn-sm btn-primary" style="margin-top:2px;margin-bottom:2px" data-jobid="'.$model->id.'" data-jobdetailid="'.$each->id.'" onclick="setcheckin(this.id)">'.$each->process_type.'</button>';//' / '.$each->sub_det->contract_sub_details.
                }
            }else{
                 $json_data['drop'] ='<span>No Jobs Assigned</span>';
            }
            $json_data['status']='success';
            $json_data['job_id']=$model->id;
            $json_data['jobdetails']=$jobdetails;
        }else{
            $json_data['status']='fail'; 
            $json_data['job_card']=$job_card_no;
        }
        echo json_encode($json_data);
    }
	
	
	
	public function actionProjectDetails(){
        $job_card_no = $_POST['job_card_no'];
        $emp_id      = $_POST['emp_id'];
        
        $model = WsProject::model()->find(array('condition'=>'id = "'.$job_card_no.'" AND (status = "E" OR status = "P" OR status = "PJ")','order'=>'id DESC'));
        //$model = WsProjectTaskBreakup::model()->find(array('condition'=>'project_id = "'.$job_card_no.'" AND (proj_status = "S")','order'=>'id DESC'));
		
        if(!empty($model)){
            
            $modelWsProjectTimeSheet =WsProjectTaskBreakup::model()->findAll(array('condition' => 'project_id="' . $model->id . '" AND (proj_status = "S")', 'order' => 'id ASC'));
            
            if(!empty($modelWsProjectTimeSheet)){
                 
                //$json_data['drop'] ='<button type="button" id="btnckin_0" class="btn btn-sm btn-primary" style="margin-top:2px;margin-bottom:2px" data-jobdetailid="0" data-jobid="'.$model->id.'" onclick="setcheckin(this.id)">General</button>';
                foreach($modelWsProjectTimeSheet as $each){
					$modelTaskCategory = WsMasterTaskCategory::model()->findByPk($each->task_category_id);
					$modelTaskSubCategory = WsMasterTaskSubCategory::model()->findByPk($each->task_subcategory_id);
                    $json_data['drop'] .='<br/><button type="button" id="btnckin_'.$each->id.'" class="btn btn-sm btn-primary" style="margin-top:2px;margin-bottom:2px" data-projid="'.$model->id.'" data-projdetailid="'.$each->id.'" onclick="setcheckin(this.id)">'.$each->id.'/'.$modelTaskCategory->category_name.'/'.$modelTaskSubCategory->subcategory_name.'</button>';//' / '.$each->sub_det->contract_sub_details.
                }
            }else{
                 $json_data['drop'] ='<span>No Projects Assigned</span>';
            }
            $json_data['status']='success';
            $json_data['job_id']=$model->id;
            $json_data['jobdetails']=$jobdetails;
        }else{
            $json_data['status']='fail'; 
            $json_data['job_card']=$job_card_no;
        }
        echo json_encode($json_data);
    }
	
    
    public function actionCheckIn(){
        date_default_timezone_set("Asia/Dubai");
        $job_id         = $_POST['job_id'];
        $job_detail_id  = $_POST['jobdetail_id'];
        $employee_id    = $_POST['emp_id'];
        if($job_id>0 && $employee_id>0){
            $mod_job=JoborderHeader::model()->findByPk($job_id);
            $modeljobtime   = new WsJobTimesheet ();
            $modeljobtime->checkin_time     = date('Y-m-d H:i:s');
            $modeljobtime->employee_id      = $employee_id;
            $modeljobtime->job_id     = $job_id;
            $modeljobtime->job_details_id    = $job_detail_id;
            $modeljobtime->job_status       = $mod_job->status;
            $modeljobtime->status='A';
            $modeljobtime->created_by=Yii::app()->user->id;
            $modeljobtime->created_date_time=date('Y-m-d H:i:s');
            $modeljobtime->save(false);
            $mod_job->status = "A";
            $mod_job->actual_start_date = $modeljobtime->checkin_time;
            $mod_job->save(false);
            
            
            $json_data['status']='success';
            $modelemp=Employee::model()->findByPk($employee_id);
            $json_data['msg']=$modelemp->employeefullname.' Checked in for Job('.$job_id.') at '.date('d/m/Y h:i a',strtotime(date('Y-m-d H:i:s'))); 
        }else{
            if($job_id==0){
                $json_data['msg']='Invalid Job';
            }elseif($employee_id==0){
                $json_data['msg']='Invalid Employee';
            }
            $json_data['status']='fail';
        }
        echo json_encode($json_data);
    }
	
	
	
	public function actionProj_CheckIn(){
        date_default_timezone_set("Asia/Dubai");
        $proj_id         = $_POST['proj_id'];
        $projdet_id  = $_POST['projdet_id'];
        $employee_id    = $_POST['emp_id'];
        if($proj_id>0 && $employee_id>0){
            $mod_proj=WsProject::model()->findByPk($proj_id);
            $modelAdminTimesheet   = new WsAdminTimesheet();
			$modelTaskBreakup   = new WsProjectTaskBreakup();
            $modelAdminTimesheet->checkin_time     = date('Y-m-d H:i:s');
            $modelAdminTimesheet->employee_id      = $employee_id;
            $modelAdminTimesheet->proj_id     = $proj_id;
            $modelAdminTimesheet->proj_details_id    = $projdet_id;
			
            //$modelAdminTimesheet->proj_status       = "PJ";
            $modelAdminTimesheet->status="A";
            $modelAdminTimesheet->created_by=Yii::app()->user->id;
            $modelAdminTimesheet->created_date_time=date('Y-m-d H:i:s');
			$modelTaskBreakup = WsProjectTaskBreakup::model()->findByPk($projdet_id);
			$modelTaskBreakup->proj_status = 'A';
			$modelTaskBreakup->save(false);
            $modelAdminTimesheet->save(false);
            $mod_proj->status = "PJ";
            $mod_proj->project_date = $modelAdminTimesheet->checkin_time;
            $mod_proj->save(false);
            $modelProjectTimeSheet   = new WsProjectTimeSheet();
			$modelProjectTimeSheet->project_id = $modelTaskBreakup->project_id;
			$modelProjectTimeSheet->proj_det_id = $modelAdminTimesheet->proj_details_id;
            $modelProjectTimeSheet->task_category_id = $modelTaskBreakup->task_category_id;
			$modelProjectTimeSheet->task_subcategory_id = $modelTaskBreakup->task_subcategory_id;
			$modelProjectTimeSheet->task_start_date_time = date('Y-m-d H:i:s');
			$modelProjectTimeSheet->assigned_person_id = $employee_id;
			$modelProjectTimeSheet->created_by = Yii::app()->user->id;
            $modelProjectTimeSheet->created_date_time = date("Y-m-d H:i:s");
			//echo '<pre>'; print_r($modelProjectTimeSheet); exit;
			$modelProjectTimeSheet->save(false); 
			
            $json_data['status']='success';
            $modelemp=Employee::model()->findByPk($employee_id);
            $json_data['msg']=$modelemp->employeefullname.' Checked in for Job('.$job_id.') at '.date('d/m/Y h:i a',strtotime(date('Y-m-d H:i:s'))); 
        }else{
            if($job_id==0){
                $json_data['msg']='Invalid Job';
            }elseif($employee_id==0){
                $json_data['msg']='Invalid Employee';
            }
            $json_data['status']='fail';
        }
        echo json_encode($json_data);
    }
    
    //for tv
    public function actionTVIndex() {
        $this->render('tv_index');
    }
    
    /*public function actiongetTVdetails(){
        $json_data['tbody']='';
        $condition = 't.status="A"';$m=1;
        $model_jobtime = JobTime::model()->with('employee_details', 'joborder_details')->findAll(array('condition' => $condition));
        foreach($model_jobtime as  $each_employee){ 
            $mod_vehicle = Vehicles::model()->findByPK($each_employee->joborder_details->vehicle_id);  
            $allotsql = 'SELECT SUM(TIME_TO_SEC(alotted_time)+TIME_TO_SEC(actual_time))    
                         FROM erp_job_order_details 
                         WHERE job_id='.$each_employee->job_order_id.' AND (alotted_employee_id = '.$each_employee->employee_id.' OR actual_employee_id='.$each_employee->employee_id.')';
            $total_allotted_time =Yii::app()->db->createCommand($allotsql)->queryScalar();
            
            $sql = 'SELECT IFNULL(SUM(TIME_TO_SEC(TIMEDIFF(checkout_time,checkin_time))),"0") From erp_job_time  WHERE DATE(checkout_time)!="0000-00-00" and job_order_id='.$each_employee->job_order_id.' AND employee_id = '.$each_employee->employee_id;
            $sql1 = 'SELECT IFNULL(SUM(TIME_TO_SEC(TIMEDIFF(NOW(),checkin_time))),"0") From erp_job_time  WHERE DATE(checkout_time)="0000-00-00" and job_order_id='.$each_employee->job_order_id.' AND employee_id = '.$each_employee->employee_id;
            $timeinsec= Yii::app()->db->createCommand($sql)->queryScalar()+Yii::app()->db->createCommand($sql1)->queryScalar();
            $json_data['tbody'] .='<tr>';
                $json_data['tbody'] .='<td style="width:2%">'.$m.'</td>';
                if($each_employee->employee_details->profile_photo==""){
                    $each_employee->employee_details->profile_photo="emp.jpg";
                }
                $json_data['tbody'] .='<td style="width:20%">'.$each_employee->employee_details->employeefullname.'</td>';
                $json_data['tbody'] .='<td style="width:8%"><img src="'.$baseUrl.'/uploads/profilephotos/'.$each_employee->employee_details->profile_photo.'"  width="70" height="70"></td>';
                $json_data['tbody'] .='<td style="width:8%">'.$each_employee->joborder_details->id.'</td>';
                $json_data['tbody'] .='<td style="width:25%">'.$mod_vehicle->registration_no.' / '.$mod_vehicle->make_det->vehicle_make_name. ' / ' . $mod_vehicle->model_det->vehicle_model_name.' / '.$mod_vehicle->year.'</td>';
                $complete_percent = $timeinsec/$total_allotted_time*100;
                $class='progress-bar-success';
                if((int)$complete_percent> 80 && (int)$complete_percent<=100)
                    $class='progress-bar-warning ';
                if((int)$complete_percent> 100)
                    $class='progress-bar-danger ';
                $json_data['tbody'] .='<td>
                                    <div class="progress">
                                  <div class="progress-bar progress-bar-striped '.$class.'" role="progressbar"  aria-valuenow="40"
                                  aria-valuemin="0" aria-valuemax="100"  style="width:'.(int)$complete_percent.'%">'.(int)$complete_percent.'</div>
                                </div></td>';
            $json_data['tbody'] .='</tr>';
            $m++;
        }
        $json_data['status']='success';
        echo json_encode($json_data);
    }*/
}