<?php

class TasksubcategoryController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','Save','Blocktasksubcategory','UnBlocktasksubcategory','Disable'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionIndex()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['projects_mas_task_subcategory_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['projects_mas_task_subcategory_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
        }
	
        public function actionGetList()
        {
                $model = new WsMasterTaskSubCategory();
                $draw   = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'t.id',
                   1 => 'task_cat_details.category_name',
                   2 => 't.subcategory_name',
                   3 => 'hourly_rate'
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (task_cat_details.category_name LIKE '%".$searchString."%' OR  t.subcategory_name LIKE '%".$searchString."%')";
                }
                $count = $model->with('task_cat_details')->count(array('condition'=>$condition));
                $model=$model->with('task_cat_details')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                 foreach ($model as $row)
                {
                    $div = '';
                    if(isset(Yii::app()->user->havePermissionOn['projects_mas_task_subcategory_edit']) ||  Yii::app()->user->authorised_user == 1)
                    {
                        $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'workshop/tasksubcategory/create&id=' . $row['id'] . '\',\'Edit Project SubCategory\',\'lg\')"><i class="fa fa-pencil"></i></button>';             
    
                    }
                    // if(isset(Yii::app()->user->havePermissionOn['projects_mas_task_subcategory_disable']) ||  Yii::app()->user->authorised_user == 1)
                    // {
    
                    //   if ($row->is_active == "Y") 
                    //   {
                    //     $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disabletasksubcategory(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                    //   }
                    //   if ($row->is_active == 'N') 
                    //   {
                    //         $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enabletasksubcategory(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                    //   }            
                    
                    // }
                    $rowData[]=array($m,
                    $row['task_cat_details']['category_name'],
                    $row['subcategory_name'],
                    $row['hourly_rate'],
                    $row['isDefault'],
                    array('id' => $row['id'],'code'=>$row['task_cat_details']['category_name'], 'status' => $row->is_active));
                    $m++;
                    
                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
        public function actionCreate()
        {
            $model = new WsMasterTaskSubCategory();         
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);               
            }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('create', array('model' => $model), false);
        }
       
  
        public function actionSave()
        {
            $model  = new WsMasterTaskSubCategory();     
            if (isset($_POST['WsMasterTaskSubCategory']))
            {
    		if (!empty($_POST['WsMasterTaskSubCategory']['id']))
                { 
                        $id= (int) @$_POST['WsMasterTaskSubCategory']['id'];
                        $model=$model->findByPk($id); 
                        $model->updated_by = Yii::app()->user->id; 
                        $model->updated_date_time = date('Y-m-d h:i:s');                  
                }else{
                        $model->created_by = Yii::app()->user->id; 
                        $model->created_date_time = date('Y-m-d h:i:s');
                }
                if($_POST['WsMasterTaskSubCategory']['isDefault'] == "Y"){
                	WsMasterTaskSubCategory::model()->updateAll(array( 'isDefault' => 'N' ), 'isDefault = "Y"' );
            	}
                $model->isDefault = $_POST['WsMasterTaskSubCategory']['isDefault'];
                $model->attributes=$_POST['WsMasterTaskSubCategory'];
                
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['category_form'];
                        $jsonData['id'] = $model->id;
                       
	                echo CJSON::encode($jsonData);
                }
                else
                {
					
					
				
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }


    public function actionBlocktasksubcategory() {
        $id = $_POST['id'];
        if ($id > 0) {
            WsMasterTaskSubCategory::model()->updateByPK($id, array('is_active' => "N"));
             // inserting to audit log
             $model=new WsMasterTaskSubCategory();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'TASKSUBCATEGORY',
                 Yii::app()->user->id,
                 'BLOCKED',
                 " with Sub name: - {$upt->subcategory_name}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionUnBlocktasksubcategory() 
    
    {
        $id = $_POST['id'];
        if ($id > 0) {
            WsMasterTaskSubCategory::model()->updateByPK($id, array('is_active' => "Y"));
             // inserting to audit log
             $model=new WsMasterTaskSubCategory();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'TASKSUBCATEGORY',
                 Yii::app()->user->id,
                 'UNBLOCKED',
                 " with sub name: - {$upt->subcategory_name}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new WsMasterTaskSubCategory();
        $model = $model->findByPk($id);
        $model->is_active = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}