<?php



class ProjectworktimeController extends Controller {



    public function accessRules() {

        return array(

            array(

                'allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array('login', 'error', 'logout'),

                'users' => array('*'),

            ),

            array(

                'allow', // allow authenticated user to perform 'create' and 'update' actions

                'actions' => array('Index', 'GetList', 'Worksheet','GetTasktimelist'),

                'expression' => '$user->isMember()',

            ),

            array(

                'deny', // deny all users

                'users' => array('*'),

            ),

        );

    }



    public function actionIndex()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['project_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['project_work_time_view_view']) &&
            Yii::app()->user->havePermissionOn['project_menu_view'] && 
            Yii::app()->user->havePermissionOn['project_work_time_view_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
        }



    public function filters() {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }

//Modified by DIkson on 10/5/2022

    public function actionGetList() {

        /* code added by Rahul v s

         * 29-04-2022

         * Fetch Data from erp_ws_project_work_time

         */

        $model = new WsProjectWorkTime();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $project_id = $_POST['project_id'];

        $employee_id = $_POST['employee_id'];

        $columns = array(

            // datatable column index  => database column name

            0 => 'id',

            1 => 'project_id',

            2 => 'id',

            3 => 'employee_id',

            4 => 'work_date',

        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy   = $filterColumn." ".$filterOrder;

        $condition = 'task_type="O"';

        if($project_id > 0){    

           $condition .= ' AND project_id = '.$project_id;

        }

        if($employee_id > 0){

            $condition .= ' AND employee_id = '.$employee_id;

        }

        if(isset($_POST['work_date']) && $_POST['work_date']!=""){

            $work_date       = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['work_date'])));

            $condition .= ' AND (DATE(t.work_date) ="' . $work_date .'")';

        }

        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")

        {

          $searchString = $_POST['search']['value'];

          $searchString_en=$this->ciphertext($searchString,"e");

          $condition .=" (labourdetail.employee_name LIKE '%".$searchString."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";

        }
        // echo $condition;
        // die();
        $count = $model->with('employeedetail','labourdetail')->count(array('condition' => $condition));

        $model = $model->with('employeedetail','labourdetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m=$offset;

        foreach ($model as $row) {

            $employee_name=$company_name='';

            if($row->employee_type=='C'){

                $employee_name=$row->employeedetail->employeefullname;

                $company_name=$row->employeedetail->branch_sponsor->branch_or_sponsor_name;

            }else if($row->employee_type=='E'){

                $employee_name=$row->labourdetail->employee_name;

                $company_name=$row->labourdetail->company_name;

            }

            $rowData[] = array(++$m,$row->project->project_name,$company_name,$employee_name,date('d/m/Y', strtotime($row->work_date)),$row['start_time'],$row['end_time'],$row['total_time'],$row['worked_hrs'],$row['travel_hrs'],$row['idle_hrs'],$row['employee_type']);

        }

        $data['data'] = $rowData;

        echo json_encode($data);

    }

    //Admin Time Sheet

    public function actionWorksheet()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['project_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['project_work_time_admin_view']) &&
            Yii::app()->user->havePermissionOn['project_menu_view'] && 
            Yii::app()->user->havePermissionOn['project_work_time_admin_view']
        )
    ) {
        $this->render('worksheet_index');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
        }
    public function actionGetTasktimelist() {

        $model = new WsProjectWorkTime();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $project_id = $_POST['project_id'];

        $columns = array(

            // datatable column index  => database column name

            0 => 'id',

            1 => 'project_id',

            2 => 'employee_id',

            3 => 'work_date',
            
            4 =>'employeedetail.firstname'

        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy   = $filterColumn." ".$filterOrder;

        $condition = 'task_type="A"';

        if($project_id > 0){    

           $condition .= ' AND project_id = '.$project_id;

        }

//        if(isset($_POST['work_date']) && $_POST['work_date']!=""){

//            $work_date       = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['work_date'])));

//            $condition .= ' AND (DATE(t.work_date) >="' . $work_date. '" AND DATE(t.work_date) <="' . $work_date. '")';

//        }


 if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.first_name LIKE '%".$searchString_en."%' 
            OR employeedetail.middle_name LIKE '%".$searchString_en."%' 
            OR employeedetail.last_name LIKE '%".$searchString_en."%')";      
        
        }


        $count = $model->with('employeedetail')->count(array('condition' => $condition));

        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m=$offset;
      


        
        
        
        
        foreach ($model as $row) {
              $worked_hrs=$row['worked_hrs'];
        $worked_hrs = explode(":", $worked_hrs);


      unset($worked_hrs[2]);

// Concatenate the remaining fields back into a time string
$worked_hrss = implode(":", $worked_hrs);

    $rowData[] = array(++$m,date('d/m/Y', strtotime($row->work_date)),$row->project->id,$row->project->project_name,$row->employeedetail->employeefullname,
$row->taskcategory_details->category_name,$row->taskcategory_sub_details->subcategory_name,$worked_hrss);

        }

        $data['data'] = $rowData;

        echo json_encode($data);

    }

}



