<?php
//Created on 27/4/2022 by Dikson R

 // ----------commented-on 18-08-2022-------------
     Yii::import('application.modules.hr.controllers.AttendanceController'); 
//end
class ProjecttimesheetController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','loademployeedetails','Savetimesheet','CalculatetimeDifference','RemovelineItem','GetEmployeeTime','WorkSheet','GetprojectTask','GetWorkedHours','SavetaskTimesheet','GetprojectTaskemployee','GetprojecsubtTask'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    //Created on 27/4/2022 by DIkson r for Creating Timesheet 
    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }
    //loading employee based on supervisor
    public function actionloademployeedetails() {
        $project_date= $_POST['project_date'];
        $project_id= $_POST['project_id'];
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($model_user->connected_employee_id>0){
            $model_employee = Employee::model()->findAll(array('condition' => 'attendance_manager="'.$model_user->connected_employee_id.'" and isActive!="B"')); 
            $arr_employee=array();
            foreach ($model_employee as $key => $value) {
                $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d"). ' ' . $value['employeecode']]=$value['id'];
            }
            ksort($arr_employee);
            $project_date_1=date("Y-m-d", strtotime(str_replace('/', '-', $project_date)));
            $model_work_time = WsProjectWorkTime::model()->with('employeedetail')->findAll(array('condition' => 'work_date="'.$project_date_1.'" and t.created_by="'.$model_user->id.'" AND employeedetail.attendance_manager!="'.$model_user->connected_employee_id.'" AND t.employee_type="C" and project_id="'.$project_id.'"')); 
            //External Labour
            $model_external_labour_work_time = WsProjectWorkTime::model()->with('labourdetail')->findAll(array('condition' => 'work_date="'.$project_date_1.'" AND t.employee_type="E" and project_id="'.$project_id.'"'));
            if(empty($model_external_labour_work_time)){
                $model_external_labour_work_time= array(new WsProjectWorkTime());
            }
            $this->render('create', array('arr_employee' => $arr_employee,'project_id' => $project_id,'project_date' => $project_date,'attendance_manager'=>$model_user->connected_employee_id,'model_work_time'=>$model_work_time,'model_external_labour_work_time'=>$model_external_labour_work_time));
        }else{
            $project_date_1=date("Y-m-d", strtotime(str_replace('/', '-', $project_date)));
            $model_work_time = WsProjectWorkTime::model()->with('employeedetail')->findAll(array('condition' => 'work_date="'.$project_date_1.'" AND t.employee_type="C" and project_id="'.$project_id.'"'));
//            $model_work_time = WsProjectWorkTime::model()->with('employeedetail')->findAll(array('condition' => 'work_date="'.$project_date_1.'" and t.created_by="'.$model_user->id.'" AND employeedetail.attendance_manager!="'.$model_user->connected_employee_id.'" and project_id="'.$project_id.'"'));
            if(empty($model_work_time)){
                $model_work_time= array(new WsProjectWorkTime());
            }
            //External Labour
            $model_external_labour_work_time = WsProjectWorkTime::model()->with('labourdetail')->findAll(array('condition' => 'work_date="'.$project_date_1.'" AND t.employee_type="E" and project_id="'.$project_id.'"'));
            if(empty($model_external_labour_work_time)){
                $model_external_labour_work_time= array(new WsProjectWorkTime());
            }
            $this->render('create', array('arr_employee' => $arr_employee,'project_id' => $project_id,'project_date' => $project_date,'attendance_manager'=>0,'model_work_time'=>$model_work_time,'model_external_labour_work_time'=>$model_external_labour_work_time));
        }
    }
    //Saving timesheet
    public function actionSavetimesheet() {       
    

        if (isset($_POST['WsProjectWorkTime'])) {
            $validate=true;
            date_default_timezone_set("Asia/Dubai");
            $i=0;
            foreach ($_POST['WsProjectWorkTime'] as $j => $items) {
                if( $items['start_time']!='' &&  $items['end_time']!=''){
                    if ($items['id'] > 0) {
                        $model[$i] = WsProjectWorkTime::model()->findByPK($items['id']);
                        $model[$i]->updated_by = Yii::app()->user->id;
                        $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $model[$i] = new WsProjectWorkTime();
                        $model[$i]->created_by = Yii::app()->user->id;
                        $model[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $model[$i]->scenario = 'timesheet';
                    $model[$i]->project_id = $items['project_id'];
                    $model[$i]->employee_id = $items['employee_id'];
                    $model[$i]->start_time = $items['start_time'];
                    $model[$i]->end_time = $items['end_time'];
                    $model[$i]->total_time = $items['total_time'];               
                    $model[$i]->worked_hrs = $items['worked_hrs'];
                    $model_employee = Employee::model()->findByPK($items['employee_id']);
                    
                    // ----------commented-on 18-08-2022-------------
                         if ($model_employee->overtime == "Y"){
                            $model[$i]->overtime_type = AttendanceController::overtimetype($items['employee_id'],$items['work_date']);
                             $model[$i]->overtime_hrs =AttendanceController::overtimehours($items['employee_id'],$items['work_date'],$items['start_time'],$items['end_time']);
                         }
                    // ------------end--------------



//                    $model[$i]->travel_hrs = $items['travel_hrs'];
//                    $model[$i]->idle_hrs = $items['idle_hrs'];//added on 29/4/2022
                    $model[$i]->work_date  = $items['work_date'];
                    $model[$i]->employee_type  ='C';
                    $validate = $model[$i]->validate() && $validate; 
                    $i++;
                }
            }
            //Created on 10/5/2022 by DIkson R
            foreach ($_POST['WsLabourWorkTime'] as $j => $items) {
                if( $items['start_time']!='' &&  $items['end_time']!=''){
                    if ($items['id'] > 0) {
                        $model[$i] = WsProjectWorkTime::model()->findByPK($items['id']);
                        $model[$i]->updated_by = Yii::app()->user->id;
                        $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $model[$i] = new WsProjectWorkTime();
                        $model[$i]->created_by = Yii::app()->user->id;
                        $model[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $model[$i]->scenario = 'timesheet';
                    $model[$i]->project_id = $items['project_id'];
                    $model[$i]->employee_id = $items['employee_id'];
                    $model[$i]->start_time = $items['start_time'];
                    $model[$i]->end_time = $items['end_time'];
                    $model[$i]->total_time = $items['total_time'];               
                    $model[$i]->worked_hrs = $items['worked_hrs'];
//                    $model[$i]->travel_hrs = $items['travel_hrs'];
//                    $model[$i]->idle_hrs = $items['idle_hrs'];//added on 29/4/2022
                    $model[$i]->work_date  = $items['work_date'];
                    $model[$i]->employee_type  ='E';
                    $validate = $model[$i]->validate() && $validate; 
                    $i++;
                }
            }
            if(empty($model)){
                $validate=false;
            }
            if ($validate) {
                foreach ($model as $eachModel) {
                    $eachModel->save();
                    if($eachModel->employee_type=='C'){
                        //For Updating Attendance Table
                        // ----------commented-on 18-08-2022-------------
                            // AttendanceController::updatesiteattendance($eachModel->employee_id,$eachModel->work_date,$eachModel->start_time,$eachModel->end_time);
                        //end
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error_array = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode($error_array);
                if ($error != '[]') {
                    echo $error;
                }
            }
        }
    }
    //To delete
    public function actionRemovelineItem(){
        $id = $_POST['id'];
        if($id>0){
            WsProjectWorkTime::model()->deleteByPk($id);
            $status['status'] = 'success';
        }
        else{
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actionGetEmployeeTime() {
        $employee_id = $_POST['employee_id'];
        $work_date = $_POST['work_date'];
        if($employee_id!='' && $work_date!=''){
            $work_date=date("Y-m-d", strtotime(str_replace('/', '-', $work_date)));
            $model_attendance = EmployeeAttendance::model()->find(array('condition' => 'employee_id="'.$employee_id. '" and attendance_date="'.$work_date.'"'));
            if($model_attendance->id>0 && $model_attendance->status = 1){
                $jsonData['login'] =date("H:i", strtotime($model_attendance->login_time));;
                $jsonData['logout'] =date("H:i", strtotime($model_attendance->logout_time));
                $jsonData['status'] ='success';
            }else{
                $jsonData['status'] ='error';
            }
        }else{
            $jsonData['status'] ='error';
        }
        echo CJSON::encode($jsonData);
     }
    //calculating time difference
    public function actionCalculatetimeDifference() {
        $start_time = $_POST['start_time'];
        $end_time = $_POST['end_time'];
        $total_working='00:00';
        if($start_time!='' && $start_time!='0:00' && $start_time!='00:00' && $end_time!='' && $end_time!='0:00' && $end_time!='00:00'){
            $working_stop_time = strtotime($start_time);
            $working_start_time = strtotime($end_time);
            if($working_stop_time>$working_start_time){
                $diff = ($working_stop_time - $working_start_time);
            }else{
                $diff = ($working_start_time-$working_stop_time);
            }
            $total_working = gmdate('H:i', $diff); 
        }
        $jsonData['hourDiff'] =$total_working;
        echo CJSON::encode($jsonData);
     }
     //created on 11/5/2022 by DIkson R
     public function actionWorkSheet() {
        $model=new WsProjectWorkTime();
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($model_user->connected_employee_id>0){
            $model_employee = Employee::model()->findbyPK($model_user->connected_employee_id);
            $this->render('work_sheet', array('model'=>$model,'model_employee'=>$model_employee));
        }else{
            $this->render('employee_work_sheet', array('model'=>$model,'model_employee'=>$model_employee));
        }
    }
    public function actionGetprojectTask() {
        $employee_id = $_POST['employee_id'];
        $project_id = $_POST['project_id'];
        $row_field = $_POST['row_field'];
        $model=new WsProjectWorkTime();
        $jsonData['projecttask'] = CHtml::activedropdownlist($model,"[$row_field]task_id",WsProjectTaskBreakup::gettasklist($project_id,$employee_id), array('class' => 'form-control', 'empty' => 'Select','onchange'=>'checkemployeexist(this.id);'));
        echo CJSON::encode($jsonData);
     }
     
      public function actionGetprojecsubtTask() {
       
        $task_id = $_POST['task_id'];
        
       /* $modelWsProjectWorkTime=new WsProjectTaskBreakup();
        $modelWsProjectWorkTime = $modelWsProjectWorkTime->findByPk($task_id);
        $task_id =$modelWsProjectWorkTime->task_category_id;*/
        //echo $task_id;exit;
        
        $model=new WsProjectWorkTime();
        $jsonData['projectsubtask'] = CHtml::activedropdownlist($model,"[$row_field]sub_task_id",WsMasterTaskSubCategory::getsubtasklist($task_id), array('class' => 'form-control', 'empty' => 'Select','onchange'=>'checkemployeexist(this.id);'));
        echo CJSON::encode($jsonData);
     }
     
     
     //Created on 13/5/2022
    public function actionGetWorkedHours() {
       $employee_id = $_POST['employee_id'];
       $work_date = $_POST['work_date'];
       $project_id= $_POST['project_id'];
       $task_id = $_POST['task_id'];
       if($employee_id!='' && $work_date!='' && $project_id!='' && $task_id!=''){
           $work_date=date("Y-m-d", strtotime(str_replace('/', '-', $work_date)));
           $model_worked_hrs = WsProjectWorkTime::model()->find(array('condition' => 'employee_id="'.$employee_id. '" and work_date="'.$work_date.'" and project_id="'.$project_id.'" and task_id="'.$task_id.'" AND task_type="A"'));
           if($model_worked_hrs->id>0){
               $jsonData['id'] =$model_worked_hrs->id;
               $jsonData['hrs'] =date("H:i", strtotime($model_worked_hrs->worked_hrs));
               $jsonData['status'] ='success';
           }else{
               $jsonData['status'] ='error';
           }
       }else{
           $jsonData['status'] ='error';
       }
       echo CJSON::encode($jsonData);
    }
    public function actionSavetaskTimesheet() {        
        if (isset($_POST['WsProjectWorkTime'])) {
            $validate=true;
            date_default_timezone_set("Asia/Dubai");
            foreach ($_POST['WsProjectWorkTime'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model[$i] = WsProjectWorkTime::model()->findByPK($items['id']);
                    $model[$i]->updated_by = Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model[$i] = new WsProjectWorkTime();
                    $model[$i]->created_by = Yii::app()->user->id;
                    $model[$i]->created_date_time = date('Y-m-d H:i:s');
                }
                $model[$i]->scenario = 'tasktimesheet';
                $model[$i]->project_id = $items['project_id'];
                $model[$i]->task_id = $items['task_id'];
                $model[$i]->sub_task_id = $items['sub_task_id'];
                $model[$i]->employee_id = $items['employee_id']; 
                $model[$i]->worked_hrs = $items['worked_hrs'];
                if ($items['work_date']!= '0000-00-00' && $items['work_date']!= '') {
                    $model[$i]->work_date = date("Y-m-d", strtotime(str_replace('/', '-',$items['work_date'])));
                }
                $model[$i]->employee_type  ='C';
                $model[$i]->task_type  ='A';
                $validate = $model[$i]->validate() && $validate; 
            }
            if(empty($model)){
                $validate=false;
            }
            if ($validate) {
                foreach ($model as $eachModel) {
                    $eachModel->save();
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error_array = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode($error_array);
                if ($error != '[]') {
                    echo $error;
                }
            }
        }
    }
    //To get details of employees assigned for the task
    public function actionGetprojectTaskemployee() {
        $task_id = $_POST['task_id'];
        $row_field = $_POST['row_field'];
        $model=new WsProjectWorkTime();
        $jsonData['employee'] = CHtml::activedropdownlist($model,"[$row_field]employee_id",WsProjectTaskBreakup::getEmployeedetail($task_id), array('class' => 'form-control', 'empty' => 'Select','onchange'=>'checkemployeexist(this.id);'));
        echo CJSON::encode($jsonData);
     }
}
