<?php

class MasterprocessstagesController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Getlist', 'Create', 'Save', 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetList() {

        $model = new MasterProcessStages();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'process_stage',
            2 => 'is_active',
            3 => 'id',
            4 => 't.sort_order'
           
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy        = $filterColumn . " " . $filterOrder;
       
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (process_stage LIKE '%" . $searchString . "%' OR sort_order LIKE '%" . $searchString . "%')";
        }
        else { $condition      = '1=1';   }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $rowData[] = array($m,
                $row['process_stage'],
                $row['is_active'],
                array('id'=>$row['id'],'status'=>$row['is_active']),
                $row['sort_order']
            );

            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
     public function actionCreate() {
        $model = new MasterProcessStages();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionSave() 
    {
        $model = new MasterProcessStages();
        if (isset($_POST['MasterProcessStages'])) 
        {

		    $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date("Y-m-d H:i:s");
            if ((int) @$_POST['MasterProcessStages']['id'] > 0) 
            {
                $id = (int) @$_POST['MasterProcessStages']['id'];
                $model = $model->findByPk($id);
            }
           
            $model->attributes = $_POST['MasterProcessStages'];
			
            if ($model->save()) 
            {
                
                $jsonData['status'] = 'success';
                //$jsonData['frm'] = $_POST['Song'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionDisable() 
    {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
       
        $model = new MasterProcessStages();
        $model = $model->findByPk($id);
        $model->is_active = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
        
    }
}