<?php

class MastercompressorinformationController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Getlist', 'Create', 'Save', 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetList() {

        $model = new MasterCompressorInformation();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'compressor_information',
            2 => 't.id',
            3 => 't.sort_order'
           
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy        = $filterColumn . " " . $filterOrder;
       
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (compressor_information LIKE '%" . $searchString . "%' OR sort_order LIKE '%" . $searchString . "%')";
        }
        else { $condition      = '1=1';   }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $rowData[] = array($m,
                $row['compressor_information'],
                array('id'=>$row['id'],'code' => $row['compressor_information'], 'status'=>$row['is_active']),$row['sort_order']
                
            );

            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
     public function actionCreate() {
        $model = new MasterCompressorInformation();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionSave() 
    {
        $model = new MasterCompressorInformation();
        if (isset($_POST['MasterCompressorInformation'])) 
        {

		    $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date("Y-m-d H:i:s");
            if ((int) @$_POST['MasterCompressorInformation']['id'] > 0) 
            {
                $id = (int) @$_POST['MasterCompressorInformation']['id'];
                $model = $model->findByPk($id);
		        $model->updated_by = Yii::app()->user->id;
		        $model->updated_date_time = date("Y-m-d H:i:s");
            }
           
            $model->attributes = $_POST['MasterCompressorInformation'];
			
            if ($model->save()) 
            {
                
                $jsonData['status'] = 'success';
                //$jsonData['frm'] = $_POST['Song'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionDisable() 
    {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
       
        $model = new MasterCompressorInformation();
        $model = $model->findByPk($id);
        $model->is_active = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
        
    }
}