<?php
class JoborderController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Getlist', 'Create', 'Save', 'Disable','Addjoborder','GetParentChildList','GetCompressorDetails','PrintJoborderReportPDF','PrintWarrantyCertificatePDF',
                'PrintCertificateofConformancePDF','PrintInspectionReportPDF','PrintTestCertificatePDF','PrintPickingListPDF','CreateProcess','TabSave','Workinprogress','Workonhold',
                'Workcompleted','GetWipList','GetHoldList','GetCompletedList','CheckQuantityListPDF','PrintPreInspectionReportPDF','PrintBillofMaterialPDF','GetPartDetails','GetProducts','DeleteJobOrderBillofMaterialItem',
                'UploadTestImage','DeleteTimeDetails','PrintBillofMaterialItemPDF','DeleteProcess','PrintPreInspecReportPDF','GetJobDetails'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionAddjoborder() {
        $this->render('addjoborder');
    }
    
    public function actionDeleteTimeDetails(){
        $id = $_POST['id'];
        if($id>0){
            JoborderTestresults::model()->deleteByPk($id);
            $status['status'] = 'success';
        }else{
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
     
    }   
    
    
     public function actionIndex() {
        $this->render('index');
    }

    public function actionGetList() {
        $model = new JoborderHeader();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'customer_id',
            2 => 'job_date',
            3 => 'remarks',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy        = $filterColumn . " " . $filterOrder;
       
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            
            $condition = "  (customer_id LIKE '%" . $searchString . "%' OR job_date LIKE '%" . $searchString . "%' OR remarks LIKE '%" . $searchString . "%' )  ";
        }
        else { $condition      = 't.status="S"';   }
        $count = $model->with('customer_details')->count(array('condition' => $condition));
        $model = $model->with('customer_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $rowData[] = array(
                $row['id'],
                $row['customer_details']['customer_name'],
                date("d/m/Y ", strtotime($row['job_date'])),
                $row['remarks'],
                array('id'=>$row['id'],'code' => $row['customer_details']['customer_name'],'status'=>$row['status'],),
            );

            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
     public function actionCreate() {
        $model = new JoborderHeader();
        $modelDetails = array(new JoborderDetails);
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelDetails = JoborderDetails::model()->with('compressor_details','compressor_stagedetails')->findAll(array('condition' => 'job_id=' . $id));
            
            if (empty($modelDetails)) {
                $modelDetails = array(new JoborderDetails());
                //$stage_type = $modelDetails->compressor_details->stage_type;
            }
            
            // else{
             //   $modelDetails->compressor_name = $modelDetails->compressor_details->compressor_name;
              //  $modelDetails->stage_type = $modelDetails->compressor_stages->stage_type;
          //  }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model,'modelDetails' => $modelDetails), false, true);
    }
    
    public function actionSave() 
    {
        $model = new JoborderHeader();
        $modelDetails = array(new JoborderDetails);
        
        if(isset($_POST['JoborderHeader'])) 
        {
            
            if ((int) @$_POST['JoborderHeader']['id'] > 0) 
            {
                $id = (int) @$_POST['JoborderHeader']['id'];
                $model = $model->findByPk($id);
		        $model->updated_by = Yii::app()->user->id;
		        $model->updated_date_time = date("Y-m-d H:i:s");
            }
            else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date("Y-m-d H:i:s");
            }
           
            $model->attributes = $_POST['JoborderHeader'];
			if ($_POST['JoborderHeader']['job_date'] != '') 
            {
                $model->job_date = str_replace('/', '-', $_POST['JoborderHeader']['job_date']);
                $model->job_date = date("Y-m-d", strtotime($model->job_date));
            }
            $valid= $model->validate();
            
            $p=0;
            
            if (is_array($_POST['JoborderDetails'])) 
            {
                foreach ($_POST['JoborderDetails'] as $i => $item) 
                {
                    $modelDetails[$p]->created_by = Yii::app()->user->id;
                    $modelDetails[$p]->created_date_time = date("Y-m-d H:i:s");
                
                    $modelDetails[$p] = new JoborderDetails;
                    $modelDetails[$p]->attributes = $item;
                    
                    
                    $modelDetails[$p]->job_id = 0;
                    $valid = $modelDetails[$p]->validate() && $valid;
                    $p++;
                }
            }
            
            
            
            /* echo '<pre>';
            print_r($modelDetails);
            exit;*/ 
            
            if ($valid) 
            {
                $model->save();
                
                JoborderDetails::model()->deleteAll('job_id=:refer_id', array(':refer_id' => $model->id));
                
                if(!empty($modelDetails))
                {
                    foreach ($modelDetails as $eachModel) 
                    {
                        $eachModel->job_id = $model->id;
                        $eachModel->save(false);
                    }
                }
                
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } 
            else 
            {
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($modelDetails))
                $error2 = json_decode(CActiveForm::validateTabular($modelDetails, '', false), true);
                else
                $error2[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    
    public function actionDisable() 
    {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
       
        $model = new JoborderHeader();
        $model = $model->findByPk($id);
        $model->is_active = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
        
    }
    
    public function actionGetParentChildList(){
         
         if (Yii::app()->request->getparam('id') != '#')
         {
             
             $node_id = Yii::app()->request->getparam('id');
             $from = "";
             $arr_node_details = explode("_", $node_id);
             if(count($arr_node_details) > 1)
             {
                 $from = $arr_node_details[0];
                 $node_id = $arr_node_details[1];
             }
             
             if ($from=='CU') {
                 
                     $SQL="SELECT `compressor_id`,`compressor_name` FROM `view_compressor_stage_details` WHERE `customer_id`=".$node_id." GROUP BY compressor_id";
                     $arr_compressor_details = Yii::app()->db->createCommand($SQL)->queryAll();
                     
                     foreach($arr_compressor_details as $eachCompressor){
                     
                        echo '<ul>';
                
                        echo '<li class="jstree-closed jsdepartment" id="COM_'.$eachCompressor['compressor_id'].'">'.$eachCompressor['compressor_name'].'</li>';
                
                        echo '</ul>';
                        
                     }
             }
             elseif ($from=='COM') {
                 
                 
                     $SQL="SELECT `stage_no`,`type` FROM `view_compressor_stage_details` WHERE `compressor_id`=".$node_id." GROUP BY stage_no";
                     $arr_stage_details = Yii::app()->db->createCommand($SQL)->queryAll();
                     
                     foreach($arr_stage_details as $eachStage){
                     
                        echo '<ul>';
                
                        echo '<li class="jstree-closed jssponser" id="ST_'.$eachStage['stage_no'].'_'.$node_id.'"> Stage - '.$eachStage['stage_no'].' | '.$eachStage['type'].'</li>';
                
                        echo '</ul>';
                        
                     }
             }
             elseif ($from=='ST') {
                 
                    $compressor_id = $arr_node_details[2];
                 
                     //$SQL="SELECT `stage_type_id`,`stage_type` FROM `view_compressor_stage_details` WHERE `stage_no`=".$node_id." AND  GROUP BY compressor_id,stage_no";
                     $SQL="SELECT DISTINCT(`stage_type_id`),stage_id,`stage_type`,`part_no`,`quantity`,`product_id` FROM `view_compressor_stage_details` WHERE `stage_no`=".$node_id." AND compressor_id=".$compressor_id." ORDER BY sort_order";
                     $arr_stage_type_details = Yii::app()->db->createCommand($SQL)->queryAll();
                     
                     foreach($arr_stage_type_details as $eachStageType){
                     
                        echo '<ul>';
                
                        //echo '<li onclick="addCompressorDetails('.$eachStageType['stage_type_id'].');" class="" id="STYPE_'.$eachStageType['stage_type_id'].'_'.$node_id.'">'.$eachStageType['stage_type'].' / '.$eachStageType['part_no']. ' / '.$eachStageType['quantity'].'</li>';
                        echo '<li>' . CHtml::link($eachStageType['stage_type'].' / '.$eachStageType['part_no']. ' / '.$eachStageType['quantity'], '#popup', array('onclick' => 'addCompressorDetails('.$eachStageType['stage_id'].')')) . '</li>';

                        echo '</ul>';
                        
                     }
             }
             /*elseif ($from=='STYPE') {
                 
                     $stage_no = $arr_node_details[2];
                 
                     $SQL="SELECT `product_id`,`part_no` FROM `view_compressor_stage_details` WHERE `stage_type_id`=".$node_id." AND stage_no=".$stage_no." GROUP BY product_id";
                     $arr_product_details = Yii::app()->db->createCommand($SQL)->queryAll();
                     foreach($arr_product_details as $eachProduct)
                     {
                        echo '<ul>';
                        echo '<li class="jstree-closed jssponser" id="PR_'.$eachProduct['product_id'].'" onclick="addPartno('.$eachProduct['product_id'].');" >'.$eachProduct['part_no'].'</li>';
                        echo '</ul>';
                     }
             }*/
            
             
         }
          else{
              
                    $customer_id = (int) Yii::app()->request->getparam('customer_id');
                    
                    //$SQL="SELECT `compressor_id`,`compressor_name` FROM `view_compressor_stage_details` WHERE `customer_id`=".$customer_id." GROUP BY compressor_id";
                    $SQL="SELECT * FROM `view_compressor_stage_details` WHERE `customer_id`=".$customer_id." GROUP BY compressor_id";
                    //echo $SQL;
                     $arr_compressor_details = Yii::app()->db->createCommand($SQL)->queryAll();
                     
                     foreach($arr_compressor_details as $eachCompressor){
                     
                        echo '<ul>';
                
                        echo '<li class="jstree-closed jsdepartment" id="COM_'.$eachCompressor['compressor_id'].'">'.$eachCompressor['compressor_name']. ' | '.$eachCompressor['make'].' | '.$eachCompressor['model'].'</li>';
                
                        echo '</ul>';
                        
                     }
             
         }
    }
    
    public function actionGetCompressorDetails(){
        $stage_id = (int) Yii::app()->request->getparam('stage_id');
        $arr_compressor_details = CompressorStageDetails::model()->findByPk($stage_id);
        $jsonData = array();
        foreach($arr_compressor_details as $eachCompressorDetails){
            $jsonData['stage_no_id']             = $arr_compressor_details->id;
            $jsonData['compressor_id']    = $arr_compressor_details->compressor_details->id;
            $jsonData['compressor_name'] = $arr_compressor_details->compressor_details->compressor_name;
            $jsonData['stage_type_id']         = $arr_compressor_details->compressor_stages->id;
            $jsonData['stage_type']         = $arr_compressor_details->compressor_stages->stage_type;
            $jsonData['stage_no']           = $arr_compressor_details->stage_no;
            $jsonData['part_no']            = $arr_compressor_details->part_no;
            $jsonData['product_id']          = $arr_compressor_details->product_id;
            $jsonData['quantity']           = $arr_compressor_details->quantity;
        }
        echo CJSON::encode($jsonData);
    }
    
    public function actionPrintJoborderReportPDF(){
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.workshop.views.joborder.print_joborder_report_pdf', array('id' => $id),true));
        $mPDF1->Output("Quotation.pdf", 'I');
    }
    
    public function actionPrintWarrantyCertificatePDF(){
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.workshop.views.joborder.print_warranty_certificate_pdf', array('id' => $id),true));
        $mPDF1->Output("Quotation.pdf", 'I');
    }
    
    public function actionPrintCertificateofConformancePDF(){
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.workshop.views.joborder.print_certificate_of_conformance_pdf', array('id' => $id),true));
        $mPDF1->Output("Quotation.pdf", 'I');
    }
    
    public function actionPrintInspectionReportPDF(){
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.workshop.views.joborder.print_inspection_report_pdf', array('id' => $id),true));
        $mPDF1->Output("Quotation.pdf", 'I');
    }
    
    public function actionPrintTestCertificatePDF(){
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.workshop.views.joborder.print_test_certificate_pdf', array('id' => $id),true));
        $mPDF1->Output("Quotation.pdf", 'I');
    }
    
    public function actionPrintPickingListPDF(){
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.workshop.views.joborder.print_picking_list_pdf', array('id' => $id),true));
        $mPDF1->Output("Quotation.pdf", 'I');
    }
    
    public function actionCheckQuantityListPDF(){
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.workshop.views.joborder.check_quantity_list_pdf', array('id' => $id),true));
        $mPDF1->Output("MaterialList.pdf", 'I');
    }
    
    public function actionPrintPreInspectionReportPDF(){
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.workshop.views.joborder.pre_inspection_report_pdf', array('id' => $id),true));
        $mPDF1->Output("Quotation.pdf", 'I');
    }
    
    public function actionCreateProcess() {
        
        $id = (int) Yii::app()->request->getParam('job_id');
        $type = Yii::app()->request->getParam('type');

        $model = new JoborderHeader();
        $modelDetails = array(new JoborderDetails);
        if ($id > 0) 
        {
            $model = $model->findByPk($id);
            
            $modelDetails = JoborderDetails::model()->with('compressor_details','compressor_stagedetails')->findAll(array('condition' => 'job_id=' . $id));
            if (empty($modelDetails)) {
                $modelDetails = array(new JoborderDetails());
            }
            
            $modelJoborderTestresults = JoborderTestresults::model()->findAll(array('condition' => 'job_id=' . $id));
            
            $l = 0;
            if(empty($modelJoborderTestresults))
            {
                if (!empty($modelDetails)) {
                    
                    foreach($modelDetails as $k=>$eachdetail){
                        $stage_type_id = $eachdetail->stage_type_id;
                        
                        $modelMasterCompressorStages = new MasterCompressorStages();
                        $modelMasterCompressorStages = $modelMasterCompressorStages->findByPk($stage_type_id);
                        if($modelMasterCompressorStages->is_valve =="Y")
                        {
                            for($j=0;$j < $eachdetail->quantity; $j++)
                            {
                                $modelJoborderTestresults[$l]=new JoborderTestresults();
                                $modelJoborderTestresults[$l]->job_id=$id;
                                $modelJoborderTestresults[$l]->stage_id=$eachdetail->stage_id;
                                $modelJoborderTestresults[$l]->product_id=$eachdetail->product_id;
                                $modelJoborderTestresults[$l]->compressor_id=$eachdetail->compressor_id;
                                $modelJoborderTestresults[$l]->type=$eachdetail->compressor_stagedetails->type;
                                $modelJoborderTestresults[$l]->part_number=$eachdetail->part_number;
                                $modelJoborderTestresults[$l]->description=$eachdetail->compressor_stages->stage_type;
                                $type = $eachdetail->compressor_stagedetails->type;
                                $condition = 'type = "' . $type . '" ';
                                $modelMasterTestResult = MasterTestResult::model()->find(array('condition' => $condition));
                                $modelJoborderTestresults[$l]->allow_limit=$modelMasterTestResult->value;
                                $l++;
                            }
                        }
                    }
                }
            }
            
            
            
            $modelProcessDetails = JobProcessDetails::model()->with('jobstage_details')->findAll(array('condition' => 'job_id=' . $id));
            if(empty($modelProcessDetails))
            {
                $condition = 'is_active="Y"';
                $arr_masterprocessdetails=MasterProcessStages::model()->findAll(array('condition' => $condition,'order' =>'sort_order asc'));
                if(!empty($arr_masterprocessdetails)){
                    foreach($arr_masterprocessdetails as $k=>$eachmaster){
                        $modelProcessDetails[$k]=new JobProcessDetails();
                        $modelProcessDetails[$k]->process_id=$eachmaster->id;
                        $modelProcessDetails[$k]->process_date_time= "0000-00-00 00:00:00";
                    }
                }else{
                    $modelProcessDetails = array(new JobProcessDetails());
                }
            }
            
            /*$modelJobBillofmaterials = JoborderBillofmaterialItem::model()->findAll(array('condition' => 'job_id=' . $id));
            if (empty($modelJobBillofmaterials)) 
            {
                $k = 0;
                foreach($modelDetails as $k=>$eachdetail)
                {
                    /*for($j=0;$j < $eachdetail->quantity; $j++)
                    {
                        $part_number_id = $eachdetail->product_id;
                        $job_id = $eachdetail->job_id;
                        $part_number =  $eachdetail->part_number;
                        
                        $SQL = 'SELECT * FROM `erp_ws_billofmaterial` `t` 
                        LEFT OUTER JOIN `erp_ws_billofmaterial_item` `billdetails` ON (`t`.`id`=`billdetails`.`billofmaterial_id`)
                        WHERE (`t`.`product_id` = "'.$part_number_id.'") ';
                        
                        
                        $modelbillofmaterials = Yii::app()->db->createCommand($SQL)->queryAll();
                        foreach($modelbillofmaterials as $i => $eachbill) 
                        {
                            $modelJobBillofmaterials[$k]=new JoborderBillofmaterialItem();
                            $modelJobBillofmaterials[$k]->job_id=$id;
                            $modelJobBillofmaterials[$k]->billofmaterial_id=$eachbill['billofmaterial_id'];
                            $modelJobBillofmaterials[$k]->billofmaterial_item_id=$eachbill['id'];
                            $modelJobBillofmaterials[$k]->product_id=$eachbill['product_id'];
                            $modelJobBillofmaterials[$k]->product_name=$eachbill['product_name'];
                            $modelJobBillofmaterials[$k]->description=$eachbill['description'];
                            $modelJobBillofmaterials[$k]->quantity=$eachbill['quantity'];
                            $modelJobBillofmaterials[$k]->unit=$eachbill['unit'];
                            $k++;
                        }
                        //echo "<pre>";print_r($modelJobBillofmaterials); exit;
                }
            }*/
            
            $modelJoborderTime = JoborderTime::model()->findAll(array('condition' => 'job_id=' . $id));
            $k = 0;
            if(empty($modelJoborderTime))
            {
                if(!empty($modelDetails)) {
                    foreach($modelDetails as $k=>$eachdetails){
                        $modelJoborderTime[$k]=new JoborderTime();
                        $modelJoborderTime[$k]->job_id=$id;
                        $modelJoborderTime[$k]->compressor_id= $eachdetails->compressor_id;
                        $modelHeader = CompressorHeader::model()->findByPk(array($eachdetails->compressor_id));
                        $modelJoborderTime[$k]->compressor_name= $modelHeader->compressor_name;
                        $modelJoborderTime[$k]->stage_id= $eachdetails->stage_no_id;
                        $modelJoborderTime[$k]->stage_no= $eachdetails->stage_id;
                        $modelJoborderTime[$k]->product_id=$eachdetails->product_id;
                        $modelJoborderTime[$k]->type=$eachdetails->compressor_stagedetails->type;
                        $modelJoborderTime[$k]->part_number=$eachdetails->part_number;
                        $modelJoborderTime[$k]->quantity=$eachdetails->quantity;
                        $modelJoborderTime[$k]->description=$eachdetails->compressor_stages->stage_type;
                        $modelJoborderTime[$k]->serv_or_prod=$eachdetails->serv_or_prod;
                        $condition = 'stage_id = "' . $eachdetails->stage_no_id . '" AND compressor_id = "' . $eachdetails->compressor_id . '"';
                        $modelCompressorTime = CompressorTime::model()->find(array('condition' => $condition));
                        $modelJoborderTime[$k]->service_time = $modelCompressorTime->service_time;
                        $modelJoborderTime[$k]->production_time = $modelCompressorTime->production_time;
                        //print_r($modelHeader); exit;
                        $k++;
                    }
                }
            }
            
            
            $modelTimesheet = WsJobTimesheet::model()->findAll(array('condition' => 'job_id=' . $id));
            //First -- data search in material list
            //$modelTimesheet = array(new WsJobTimesheet());
            /*$modelJoborderMaterial = WsJoborderMaterialList::model()->findAll(array('condition' => 'job_id=' . $id,'order'=>'part_number'));
            $k = 0;
            if(empty($modelJoborderMaterial))
            {*/
                //Second -- data search in job order details if material list is empty
                
                /*$SQL="  SELECT BOM.product_id,BOM.stage_product_id,product_name,description,SUM(BOM.quantity * JO.quantity) AS quantity FROM `erp_ws_joborder_billofmaterial_item` AS BOM 
                        LEFT JOIN erp_ws_joborder_details JO ON BOM.job_id=JO.job_id AND BOM.stage_product_id=JO.product_id WHERE BOM.job_id=".$id." GROUP BY BOM.product_id";
                        */
                
                $SQL="  SELECT BOM.product_id,BOM.stage_product_id,product_name,description,SUM(BOM.quantity) AS quantity FROM `erp_ws_joborder_billofmaterial_item` AS BOM 
                        LEFT JOIN erp_ws_joborder_details JO ON BOM.job_id=JO.job_id AND BOM.stage_product_id=JO.product_id WHERE BOM.job_id=".$id." GROUP BY BOM.product_id";
                        
                
                $arr_bill_of_material = Yii::app()->db->createCommand($SQL)->queryAll();  
                
                foreach ($arr_bill_of_material as $i => $eachMaterialItem) 
                { 
                    $modelJoborderMaterial[$k]=new WsJoborderMaterialList();
                    $modelJoborderMaterial[$k]->job_id=$id;
                    $modelJoborderMaterial[$k]->product_id=$eachMaterialItem['product_id'];
                    $modelJoborderMaterial[$k]->part_number=$eachMaterialItem['product_name'];
                    $modelJoborderMaterial[$k]->description=$eachMaterialItem['description'];
                    $modelJoborderMaterial[$k]->quantity=$eachMaterialItem['quantity'];
                   
                    $k++;
                } 
                    
                    //echo '<pre>';
                    //print_r($modelJoborderMaterial);
                    
                     //Third -- data search in job order details if job order material list is empty
                   /* if(empty($modelJoborderMaterial))
                    {
                        $SQL="  SELECT SUM(BOM.quantity * JO.quantity) AS quantity,item_product_id,product_name,description FROM `view_bill_of_material` AS BOM
                                INNER JOIN erp_ws_joborder_details JO ON BOM.product_id=JO.product_id WHERE JO.job_id=".$id." GROUP BY item_product_id";
                                
                                //echo $SQL;
                                $arr_bill_of_material = Yii::app()->db->createCommand($SQL)->queryAll();  
                                
                                foreach ($arr_bill_of_material as $i => $eachMaterialItem) 
                                    {
                                        $modelJoborderMaterial[$k]=new WsJoborderMaterialList();
                                        $modelJoborderMaterial[$k]->job_id=$id;
                                        $modelJoborderMaterial[$k]->product_id=$eachMaterialItem['item_product_id'];
                                        $modelJoborderMaterial[$k]->part_number=$eachMaterialItem['product_name'];
                                        $modelJoborderMaterial[$k]->description=$eachMaterialItem['description'];
                                        $modelJoborderMaterial[$k]->quantity=$eachMaterialItem['quantity'];
                                       
                                        $k++;
                                    } 
                        
                            
                    }*/
            //}
           
            
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create_process', array('model' => $model,'modelDetails' => $modelDetails,'modelJoborderTestresults' => $modelJoborderTestresults,'modelProcessDetails' => $modelProcessDetails,
        'modelJoborderTime' => $modelJoborderTime,'modelTimesheet'=> $modelTimesheet,'modelJoborderMaterial'=>$modelJoborderMaterial,'modelJobBillofmaterials'=>$modelJobBillofmaterials,'id'=> $id,'type' => $type,'part_number'=>$part_number), false, true);
    }
    
    
    public function actionTabSave() 
    {
        $model = new JoborderHeader();
        $modelDetails = array(new JoborderDetails);
        $modelJoborderTestresults = array(new JoborderTestresults);
        if(isset($_POST['JoborderHeader'])) 
        {
            
            if ((int) @$_POST['JoborderHeader']['id'] > 0) 
            {
                $id = (int) @$_POST['JoborderHeader']['id'];
                $model = $model->findByPk($id);
		        $model->updated_by = Yii::app()->user->id;
		        $model->updated_date_time = date("Y-m-d H:i:s");
            }
            else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date("Y-m-d H:i:s");
            }
           
            $model->attributes = $_POST['JoborderHeader'];
			if ($_POST['JoborderHeader']['inspector_name'] != '') {
                        $model->inspector_name = $_POST['JoborderHeader']['inspector_name'];
                    }
			if ($_POST['JoborderHeader']['ship_to'] != '') {
				$model->ship_to = $_POST['JoborderHeader']['ship_to'];
			}
			if ($_POST['JoborderHeader']['bill_to'] != '') {
				$model->bill_to = $_POST['JoborderHeader']['bill_to'];
			}
			
			
			if ($_POST['JoborderHeader']['job_date'] != '') 
            {
                $model->job_date = str_replace('/', '-', $_POST['JoborderHeader']['job_date']);
                $model->job_date = date("Y-m-d", strtotime($model->job_date));
            }
    
            if ($_POST['JoborderHeader']['planned_start_date'] != '') 
            {
                $model->planned_start_date = str_replace('/', '-', $_POST['JoborderHeader']['planned_start_date']);
                $model->planned_start_date = date("Y-m-d", strtotime($model->planned_start_date));
            }
            
            if ($_POST['JoborderHeader']['planned_end_date'] != '') 
            {
                $model->planned_end_date = str_replace('/', '-', $_POST['JoborderHeader']['planned_end_date']);
                $model->planned_end_date = date("Y-m-d", strtotime($model->planned_end_date));
            }
            
            $valid= $model->validate();
            
            $p=0;
            
            if (is_array($_POST['JoborderDetails'])) 
            {
                foreach ($_POST['JoborderDetails'] as $i => $item) 
                {
                    $modelDetails[$p] = new JoborderDetails;
                    if((int)$item['id']>0){
                        $modelDetails[$p] = JoborderDetails::model()->findByPk((int)$item['id']);
                    }else{
                        $modelDetails[$p]->created_by = Yii::app()->user->id;
                        $modelDetails[$p]->created_date_time = date("Y-m-d H:i:s");
                    }
                
                    $modelDetails[$p]->attributes = $item;
                    $modelDetails[$p]->serv_or_prod = $item['serv_or_prod'];
                    
                    $modelDetails[$p]->job_id = 0;
                    $valid = $modelDetails[$p]->validate() && $valid;
                    $p++;
                }
            }
            $p=0;
            //echo "<pre>"; print_r($_POST['JoborderTestresults']); exit;
            if (is_array($_POST['JoborderTestresults']))
            {
                foreach ($_POST['JoborderTestresults'] as $i => $item) 
                {
                    $modelJoborderTestresults[$p] = new JoborderTestresults;
                    
                    if((int)$item['id']>0){
                        $modelJoborderTestresults[$p] = JoborderTestresults::model()->findByPk((int)$item['id']);
                    }else{
                        
                        
                        $modelJoborderTestresults[$p]->created_by = Yii::app()->user->id;
                        $modelJoborderTestresults[$p]->created_date_time = date("Y-m-d H:i:s");
                    }
                    /*if($_POST['JoborderTestresults']['status'])
                    {
                        $modelJoborderTestresults[$p]->status = $item['status'];
                    }*/
                    
                    
                    $modelJoborderTestresults[$p]->attributes = $item;
                    
                    /*if ($item['tested_date'] != '') 
                    {
                        $modelJoborderTestresults[$p]->tested_date = str_replace('/', '-', $item['tested_date']);
                        $modelJoborderTestresults[$p]->tested_date = date("Y-m-d", strtotime($modelJoborderTestresults->tested_date));
                        //print_r($modelJoborderTestresults->tested_date);exit;
                    }*/
                    
                    //$modelJoborderTestresults[$p]->attributes = $_POST['JoborderTestresults'][$p];
                    if ($item['tested_date'] != '0000-00-00' && $item['tested_date'] != '') {
                        $modelJoborderTestresults[$p]->tested_date = date("Y-m-d", strtotime(str_replace('/', '-', $item['tested_date'])));
                    }
                    
                    if ($item['upload_img'] != '') {
                        $modelJoborderTestresults[$p]->upload_img = $item['upload_img'];
                        $modelJoborderTestresults[$p]->tested_date = date("Y-m-d");
                    }
                    else 
                    {
                        $modelJoborderTestresults[$p]->tested_date = "0000-00-00";
                    }
                    
                    if ($item['remarks'] != '') {
                        $modelJoborderTestresults[$p]->remarks = $item['remarks'];
                    }
					
                    if ($item['observation'] =='Y') {
                        $modelJoborderTestresults[$p]->observation = $item['observation'];
                    }
                    if ($item['compressor_id'] != '') {
                        $modelJoborderTestresults[$p]->compressor_id = $item['compressor_id'];
                    }
                    if ($item['lube_id'] != '') {
						$arr_lube_id = implode(',',$item['lube_id']);
                        $modelJoborderTestresults[$p]->lube_id = $arr_lube_id;
                    }
					
					if ($item['dirt_type_id'] != '') {
						$arr_dirt_type_id = implode(',',$item['dirt_type_id']);
                        $modelJoborderTestresults[$p]->dirt_type_id = $arr_dirt_type_id;
                    }
					
					if ($item['failuremode_id'] != '') {
						$arr_failuremode_id = implode(',',$item['failuremode_id']);
                        $modelJoborderTestresults[$p]->failuremode_id = $arr_failuremode_id;
                    }
					
					if ($item['breakage_id'] != '') {
						$arr_breakage_id = implode(',',$item['breakage_id']);
                        $modelJoborderTestresults[$p]->breakage_id = $arr_breakage_id;
                    }
					if ($item['seat_wear_id'] != '') {
						$arr_seat_wear_id = implode(',',$item['seat_wear_id']);
                        $modelJoborderTestresults[$p]->seat_wear_id = $arr_seat_wear_id;
                    }
					
					if ($item['guard_id'] != '') {
						$arr_guard_id = implode(',',$item['guard_id']);
                        $modelJoborderTestresults[$p]->guard_id = $arr_guard_id;
                    }
					if ($item['services'] != '') {
						$arr_services = implode(',',$item['services']);
                        $modelJoborderTestresults[$p]->services = $arr_services;
                    }
					
                    $modelJoborderTestresults[$p]->job_id = 0;
                    //$valid = $modelJoborderTestresults[$p]->validate() && $valid;
                    $p++;
                }
            }
            //echo "<pre>"; print_r($modelJoborderTestresults); exit;
            
           
             if (is_array($_POST['JobProcessDetails']))
             {
                $p=0;   
                foreach ($_POST['JobProcessDetails'] as $i => $item) 
                {
                    if($item['process_id'] > 0)
                    {
                        if((int)$item['id']>0){
                            $modelProcessDetails[$p] = JobProcessDetails::model()->findByPk((int)$item['id']);
                        }else{
                            $modelProcessDetails[$p] = new JobProcessDetails();
                            $modelProcessDetails[$p]->created_by = Yii::app()->user->id;
                            $modelProcessDetails[$p]->created_date_time = date("Y-m-d H:i:s");
                            $modelProcessDetails[$p]->job_id = 0;
                        }
                        $modelProcessDetails[$p]->attributes = $_POST['JobProcessDetails'][$i];
                        if($item['is_completed']=='Y' && $item['process_date_time']=='--'){
                            $modelProcessDetails[$p]->process_date_time = date("Y-m-d H:i:s");
                        }else if($item['is_completed']=='Y' && $item['process_date_time']!='--'){
                            $modelProcessDetails[$p]->process_date_time = date("Y-m-d H:i:s", strtotime(str_replace('/', '-',$item['process_date_time'])));
                        }
                        $valid = $modelProcessDetails[$p]->validate() && $valid;
                        $p++;
                    }
                }
             }
             
            /*echo '<pre>';
            print_r($modelProcessDetails); exit;*/
            
            
            
            
            
            
            $p=0;
             if (is_array($_POST['JoborderTime']))
             {
                foreach ($_POST['JoborderTime'] as $i => $item) 
                {
                    $modelJoborderTime[$p] = new JoborderTime;
                    if((int)$item['id']>0){
                        $modelJoborderTime[$p] = JoborderTime::model()->findByPk((int)$item['id']);
                    }else{
                        $modelJoborderTime[$p]->created_by = Yii::app()->user->id;
                        $modelJoborderTime[$p]->created_date_time = date("Y-m-d H:i:s");
                    }
                    $modelJoborderTime[$p]->attributes = $item;
                     $modelJoborderTime[$p]->serv_or_prod = $item['serv_or_prod'];
                      $modelJoborderTime[$p]->quantity = $item['quantity'];
                      $modelJoborderTime[$p]->product_id = $item['product_id'];
                    
                        $modelJoborderTime[$p]->production_time = str_replace('/', '-',$item['production_time']);
                        $modelJoborderTime[$p]->production_time = date("Y-m-d H:i:s", strtotime($modelProcessDetails[$p]->process_date_time));
                    
                    $modelJoborderTime[$p]->job_id = 0;
                    $valid = $modelJoborderTime[$p]->validate() && $valid;
                    $p++;
                }
             }
             /*$p=0;
            if (is_array($_POST['WsJoborderMaterialList']))
            {
                foreach ($_POST['WsJoborderMaterialList'] as $i => $item) 
                {
                    $modelJoborderMaterial[$p] = new WsJoborderMaterialList;
                     $modelJoborderMaterial[$p]->created_by = Yii::app()->user->id;
                     $modelJoborderMaterial[$p]->created_date_time = date("Y-m-d H:i:s");
                    if((int)$item['id']>0){
                        $modelJoborderMaterial[$p] = WsJoborderMaterialList::model()->findByPk((int)$item['id']);
                        
                    }else{
                        $modelJoborderMaterial[$p]->updated_by = Yii::app()->user->id;
                    $modelJoborderMaterial[$p]->updated_date_time = date("Y-m-d H:i:s");
                       
                    }
                
                    $modelJoborderMaterial[$p]->attributes = $item;
                    $modelJoborderMaterial[$p]->job_id = 0;
                    
                    $valid = $modelJoborderMaterial[$p]->validate() && $valid;
                    $p++;
                }
            }
            */
            $p=0;
            //echo '<pre>';print_r($_POST['JoborderBillofmaterialItem']); exit;
            if (is_array($_POST['JoborderBillofmaterialItem'])) 
            {
                foreach ($_POST['JoborderBillofmaterialItem'] as $i => $item) 
                {
                   
                    $modelJoborderBillofmaterialItem[$p] = new JoborderBillofmaterialItem();
                    if((int) $item['id'] > 0){
                        $modelJoborderBillofmaterialItem[$p] = JoborderBillofmaterialItem::model()->findByPk((int) $item['id']);
                    }else{
                        $modelJoborderBillofmaterialItem[$p]->created_by = Yii::app()->user->id;
                        $modelJoborderBillofmaterialItem[$p]->created_datetime = date("Y-m-d H:i:s");
                    }
                
                    $modelJoborderBillofmaterialItem[$p]->attributes = $item;
                    $modelJoborderBillofmaterialItem[$p]->product_id = $_POST['JoborderBillofmaterialItem'][$i]['product_id'];
                    $modelJoborderBillofmaterialItem[$p]->std_or_nstd = $_POST['JoborderBillofmaterialItem'][$i]['std_or_nstd'];
                    $modelJoborderBillofmaterialItem[$p]->job_id = 0;
                    
                    $modelJoborderBillofmaterialItem[$p]->stage_product_id = $_POST['stage_product_id'];
                    //$valid = $modelJoborderBillofmaterialItem[$p]->validate() && $valid;
                    $p++;
                }
            }
            //echo '<pre>'; print_r($modelJoborderBillofmaterialItem); exit;
            
            if ($valid) 
            {
                $model->save();
               
                if(!empty($modelDetails))
                {
                    foreach ($modelDetails as $eachModel) 
                    {
                        $eachModel->job_id = $model->id;
                        $eachModel->save(false);
                    }
                }
                if(!empty($modelJoborderTestresults))
                {
                    foreach($modelJoborderTestresults as $eachresults) 
                    {
                        $eachresults->job_id = $model->id;
                        $eachresults->save(false);
                    }
                }
                
                
                if(!empty($modelProcessDetails))
                {
                    foreach ($modelProcessDetails as $eachProcessDetails) 
                    {
                        $eachProcessDetails->job_id = $model->id;
                        $eachProcessDetails->save(false);
                    }
                }
                
                if(!empty($modelJoborderTime))
                {
                    foreach ($modelJoborderTime as $eachTimeDetails) 
                    {
                        $eachTimeDetails->job_id = $model->id;
                        $eachTimeDetails->save(false);
                    }
                }
                
                /*if(!empty($modelJoborderMaterial))
                {
                    foreach ($modelJoborderMaterial as $eachmaterial) 
                    {
                        $eachmaterial->job_id = $model->id;
                        $eachmaterial->save(false);
                    }
                }*/
                
               /* echo '<pre>';
                print_r($modelJoborderBillofmaterialItem);
                exit;
                */
                if(!empty($modelJoborderBillofmaterialItem))
                {
                    foreach ($modelJoborderBillofmaterialItem as $eachmaterialitems) 
                    {
                       
                        $eachmaterialitems->job_id = $model->id;
                        $eachmaterialitems->save(false);
                    }
                }
                
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } 
            else 
            {
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($modelDetails))
                $error2 = json_decode(CActiveForm::validateTabular($modelDetails, '', false), true);
                else
                $error2[] = "Please add atleast one line item";
                if (!empty($modelJoborderTestresults))
                $error3 = json_decode(CActiveForm::validateTabular($modelJoborderTestresults, '', false), true);
                else
                $error3[] = "Please add atleast one line item";
                if (!empty($modelProcessDetails))
                $error4 = json_decode(CActiveForm::validateTabular($modelProcessDetails, '', false), true);
                else
                $error4[] = "Please add atleast one line item";
                if (!empty($modelJoborderTime))
                $error5 = json_decode(CActiveForm::validateTabular($modelProcessDetails, '', false), true);
                else
                $error5[] = "Please add atleast one line item";
                 if (!empty($modelJoborderMaterial))
                $error6 = json_decode(CActiveForm::validateTabular($modelJoborderMaterial, '', false), true);
                else
                $error6[] = "Please add atleast one line item";
                if (!empty($modelJoborderBillofmaterialItem))
                $error7 = json_decode(CActiveForm::validateTabular($modelJoborderBillofmaterialItem, '', false), true);
                else
                $error7[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$error3,$error4,$error5,$error6,$error7));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    
    public function actionWorkinprogress() {
        $this->render('workinprogress');
    }
    
    public function actionWorkonhold() {
        $this->render('workonhold');
    }
    
    public function actionWorkcompleted() {
        $this->render('workcompleted');
    }
    
    public function actionGetWipList() {
        $model = new JoborderHeader();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'customer_id',
            2 => 'job_date',
            3 => 'remarks',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy        = $filterColumn . " " . $filterOrder;
       
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
             
            $condition = "  (customer_id LIKE '%" . $searchString . "%' OR job_date LIKE '%" . $searchString . "%' OR remarks LIKE '%" . $searchString . "%') AND t.status='A' ";
        }
        else { $condition      = 't.status="A"';   }
        $count = $model->with('customer_details')->count(array('condition' => $condition));
        $model = $model->with('customer_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $rowData[] = array(
                $row['id'],
                $row['customer_details']['customer_name'],
                date("d/m/Y ", strtotime($row['job_date'])),
                $row['remarks'],
                array('id'=>$row['id'],'code' => $row['customer_details']['customer_name'],'status'=>$row['status']),
            );

            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
    
    public function actionGetHoldList() {
        $model = new JoborderHeader();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'customer_id',
            2 => 'job_date',
            3 => 'remarks',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy        = $filterColumn . " " . $filterOrder;
       
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
             
            $condition = "  (customer_id LIKE '%" . $searchString . "%' OR job_date LIKE '%" . $searchString . "%' OR remarks LIKE '%" . $searchString . "%') AND t.status='H'";
        }
        else { $condition      = 't.status="H"';   }
        $count = $model->with('customer_details')->count(array('condition' => $condition));
        $model = $model->with('customer_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $rowData[] = array(
                $row['id'],
                $row['customer_details']['customer_name'],
                date("d/m/Y ", strtotime($row['job_date'])),
                $row['remarks'],
                array('id'=>$row['id'],'code' => $row['customer_details']['customer_name'],'status'=>$row['status']),
            );

            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
    
    public function actionGetCompletedList() {
        $model = new JoborderHeader();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'customer_id',
            2 => 'job_date',
            3 => 'remarks',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy        = $filterColumn . " " . $filterOrder;
       
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
             
            $condition = " (customer_id LIKE '%" . $searchString . "%' OR job_date LIKE '%" . $searchString . "%' OR remarks LIKE '%" . $searchString . "%') AND t.status='C'";
        }
        else { $condition      = 't.status="C"';   }
        $count = $model->with('customer_details')->count(array('condition' => $condition));
        $model = $model->with('customer_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $rowData[] = array(
                $row['id'],
                $row['customer_details']['customer_name'],
                date("d/m/Y ", strtotime($row['job_date'])),
                $row['remarks'],
                array('id'=>$row['id'],'code' => $row['customer_details']['customer_name'],'status'=>$row['status']),
            );

            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
    
    public function actionPrintBillofMaterialPDF(){
        $id = Yii::app()->request->getParam('id');
        
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $modelbillofmaterial = Billofmaterial::model()->find(array('condition' => 'product_id='.$id));
        $mPDF1->WriteHTML($this->renderPartial('application.modules.workshop.views.joborder.print_bill_of_material_pdf', array('modelbillofmaterial' => $modelbillofmaterial),true));
        $mPDF1->Output("Quotation.pdf", 'I');
    }
    
     public function actionPrintBillofMaterialItemPDF(){
        $id = Yii::app()->request->getParam('id');
        
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        //$modelbillofmaterial = JoborderDetails::model()->findAll(array('condition' => 'job_id='.$id));
        $mPDF1->WriteHTML($this->renderPartial('application.modules.workshop.views.joborder.print_bill_of_material_itempdf', array('id' => $id),true));
        $mPDF1->Output("Quotation.pdf", 'I');
    }
    
    public function actionGetPartDetails()
	 {
	     $product_id = Yii::app()->request->getparam("product_id");  
	     $job_id = (int) Yii::app()->request->getparam("job_id"); 
	     
	     //$condition = 'product_id='.$product_id.' AND job_id='.$job_id;
	     //$modelJobOrderDetails = JoborderDetails::model()->find(array('condition' => $condition));
    	 //$modelJoborderBillofmaterialItem = Billofmaterial::model()->find(array('condition' => $condition));
    	 //$Billofmaterial_id = $modelJoborderBillofmaterialItem->id;   
    	 //$modelJoborderBillofmaterialItem = Billofmaterial::model()->find(array('condition' => $condition));
    	 
    	 
	     $modelBillofmaterialitem = array(new JoborderBillofmaterialItem);
	     $conditions = 'job_id= '.$job_id.' AND stage_product_id='.$product_id;
	     $modelBillofmaterialitem = JoborderBillofmaterialItem::model()->findAll(array('condition' => $conditions,'order'=>'id ASC'));
	     
	    /* echo '<pre>';
	     print_r($modelBillofmaterialitem);*/
	     
	     if(empty($modelBillofmaterialitem))
	     {
    	     $condition = 'product_id='.$product_id;
    	     $modelJoborderBillofmaterialItem = Billofmaterial::model()->find(array('condition' => $condition));
    	     $Billofmaterial_id = $modelJoborderBillofmaterialItem->id;
    	     
    	     $conditions = 'billofmaterial_id = "' . $Billofmaterial_id . '"';
    	     $modelBillofmaterialitems = BillofmaterialItem::model()->findAll(array('condition' => $conditions));
    	     $k=0;
    	     foreach($modelBillofmaterialitems as $i => $eachbill) 
             {
        	     $modelBillofmaterialitem[$k]=new JoborderBillofmaterialItem();
                 $modelBillofmaterialitem[$k]->job_id=$job_id;
                 $modelBillofmaterialitem[$k]->billofmaterial_id=$eachbill['billofmaterial_id'];
                 $modelBillofmaterialitem[$k]->billofmaterial_item_id=$eachbill['id'];
                 $modelBillofmaterialitem[$k]->product_id=$eachbill['product_id'];
                 $modelBillofmaterialitem[$k]->product_name=$eachbill['product_name'];
                 $modelBillofmaterialitem[$k]->description=$eachbill['description'];
                 $modelBillofmaterialitem[$k]->quantity=$eachbill['quantity'];
                 $modelBillofmaterialitem[$k]->std_or_nstd=$eachbill['std_or_nstd'];
                 $modelBillofmaterialitem[$k]->unit=$eachbill['unit'];
                 $k++;
             }
	     }
	     Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
	     $this->renderPartial('load_material_details', array('modelBillofmaterialitem' => $modelBillofmaterialitem,'product_id'=>$product_id,'job_id'=>$job_id),false,true);
	 }
    
   public function actionGetProducts() 
    {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = '(part_number LIKE "' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%") and t.isActive="Y"';
        $model = new Store();
        $model = $model->with('tax')->findAll(array('select' => 'id,part_number,description,unit_id,inventory_item_type,purchase_from,rate', 'condition' => $condition, 'limit' => 200));
        $i = 0;
        $data = array();
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number.' : '.$eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    
    public function actionUploadTestImage($folder = null) 
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $field_id = "";
        if(isset($_GET['field_id']))
        {
            $field_id = Yii::app()->request->getParam('field_id');
        }
        
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        $allowedExtensions = array("jpg", "jpeg", "gif","png"); //array("jpg","jpeg","gif","exe","mov" and etc...
        $sizeLimit = 2 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $imagename	=	Yii::app()->basePath.'/../uploads/testimages/'.$fileName;
       
        echo $return; // it's array
        
        
    }
    
     public function actionDeleteJobOrderBillofMaterialItem(){
        $id = $_POST['id'];
        if($id>0){
            JoborderBillofmaterialItem::model()->deleteByPk($id);
            $status['status'] = 'success';
        }else{
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    
    public function actionDeleteProcess(){
        $id = $_POST['id'];
        if($id>0){
            JobProcessDetails::model()->deleteByPk($id);
            $status['status'] = 'success';
        }else{
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
	
	public function actionPrintPreInspecReportPDF(){
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.workshop.views.joborder.pre_inspec_report_pdf', array('id' => $id),true));
        $mPDF1->Output("Quotation.pdf", 'I');
    }
    
    
    
}
