<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("DisablePaymentterm", "function Disable(id){
    var r = confirm('Are you sure to enable/disable this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=vehicle/masvehicle/Disable',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('Error while Disable');
                }else {
                      reloadTable('#tbl_masvehicle');
                    t8.success('Status Disabled/Enabled SuccessFully!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>

<script>
    $(document).ready(function () {
        var table_id = "#tbl_masvehicle";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('vehicle/masvehicle/getmasvehiclelist') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                //console.log(aData);
                // 	if ( aData[2] == "Y" )  {  
                //     $("td", nRow).addClass("bg-payment");

                //   }else{
                //       $("td", nRow).addClass("bg-test");
                //   }
                if (aData[5].status == "N") {
                    $("td", nRow).addClass("bg-danger");
                }
                AddContextMenu(nRow, aData);
            }
        });
    });
    function AddContextMenu(row, datas) {
        var mas_edit = 0;
        var mas_disable = 0;
        var mas_print = 0;
        <?php if (isset(Yii::app()->user->havePermissionOn['sales_master_vehicle_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_edit = 1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['sales_master_vehicle_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_disable = 1;
        <?php } ?>
        <?php if (isset(Yii::app()->user->havePermissionOn['sales_master_vehicle_print']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_print = 1;
        <?php } ?>
        $(row).contextMenu({
            selector: 'td',

            items: {
                "edit": {
                    name: "Edit",
                    icon: "edit",
                    accesskey: "e",
                    callback: function () {
                        loadPopupModal("vehicle/masvehicle/create&id=" + datas[5].id, datas[5].code, "lg");
                    },
                    disabled: function (key, opt) {
                        // this references the trigger element
                        if (mas_edit == '0') {
                            return !this.data('editDisabled');
                        }
                    }
                },
                "Disable_Enable": {
                    name: (datas[5].status == "Y") ? "Disable" : "Enable",
                    icon: "edit",
                    accesskey: "d",
                    callback: function () {
                        Disable(datas[5].id, datas[5].status);
                    },
                    disabled: function (key, opt) {
                        if (mas_disable == '0') {
                            return true;
                        }
                    }
                },
                "print": {
                    name: "Print",
                    icon: "fa-print",
                    accesskey: "p",
                    disabled: function (key, opt) {
                        // this references the trigger element
                        if (mas_print == '0') {
                            return !this.data('editDisabled');
                        }
                    },
                    callback: function () {
                        var url = $('#liveSite').val() + "index.php?r=vehicle/masvehicle/print&id=" + datas[5].id;
                        window.open(url, "_blank");
                    }
                }
            }
        });
    }
</script>
<script>
    function Disable(id, status) {
        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true) {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=vehicle/masvehicle/Disable',
                'cache': false,
                'success': function (data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_masvehicle').DataTable().ajax.reload()
                        if (status == 'Y') {
                            t8.success('Disabled Successfully!');
                        } else {
                            t8.success('Enabled Successfully!');
                        }
                    }
                }
            });
        }


    }
</script>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-users"></i> -->
        Vehicles
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['sales_master_masvehicle_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <a class="ad-btn" onclick="loadPopupModal('vehicle/masvehicle/create', 'Add New Vehicle', 'lg')"
                    title="Add">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                        class="pluss-ad psn-ad">
                        <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                        <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                        <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                    </svg>
                </a>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_masvehicle">
                <thead>
                    <tr>
                        <th>Sl.No</th>
                        <th>Vehicle ID</th>
                        <th>Vehicle Make</th>
                        <th>Model</th>
                        <th>VIN No.</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>