<?php 
$cs = Yii::app()->getClientScript();
$ajaxUrl = CHtml::normalizeUrl(array('masvehicle/GetDocumentList'));
$cs->registerScript("loadVehicleDocuments", "
$(document).ready(function () {
    var table_id = '#tbl_documents';
    var doc_id = $('#doc_id').val();
    var table = $(table_id).DataTable({
        scrollY: '400px',
        scrollX: true,
        pageLength: 20,
        autoWidth: false,
        processing: true,
        serverSide: true,
        ajax: {
            data: { 'doc_id': doc_id },
            url: '{$ajaxUrl}',
            type: 'POST',
            dataSrc: 'data',
            cache: false
        },
        columns: [
            { data: 'sl_no', width: '80px' },
            { data: 'document_name', width: '200px' },
            { data: 'file_name', width: '200px' },
            { data: 'download', width: '200px' }
        ],
        rowCallback: function (row, data) {
            if (data.status === 'N') {
                $('td', row).css('background-color', '#ffe6e6');
            }
        }
    });

    // Show selected file name on file input change
    $('#vehicle_doc_file_input').on('change', function () {
        var fileName = $(this).val().split('\\\\').pop();
        $('#selected-file-name').text(fileName ? fileName : 'No file chosen');
    });

    // Adjust scroll height if no records
    $(table_id).on('xhr.dt', function (e, settings, json, xhr) {
        console.log('Document List Response:', json);
        if (json.data.length === 0) {
            $(table_id + '_wrapper .dataTables_scrollBody').css('height', 'auto');
        }
    });
});
", CClientScript::POS_HEAD);
?>

<style>
    .custom-file-upload {
        display: inline-block;
        padding: 8px 20px;
        background-color: #007BFF;
        color: white;
        font-weight: 500;
        border-radius: 4px;
        cursor: pointer;
        transition: background 0.3s ease;
    }

    .custom-file-upload:hover {
        background-color: #0056b3;
    }

    .file-name-display {
        margin-left: 10px;
        font-style: italic;
        color: #777;
    }
</style>

<!-- 🔷 Upload Form -->
<ul class="clearfix form-ul material row">
    <!-- Document Name Text Field -->
    <li class="col-sm-4">
        <?php 
        if (!isset($model_doc) || $model_doc === null) {
            $model_doc = new VehicleDocFile(); // Ensure model instance
        }
        echo $form->textField($model_doc, 'document_name', array(
            'data-label' => 'Document Name <span style="color:red">*</span>',
            'placeholder' => 'Enter Document Name',
            'class' => 'form-control'
        )); 
        ?>
    </li>

    <!-- File Upload -->
    <li class="col-sm-8">
        <label for="vehicle_doc_file_input" class="custom-file-upload">
            Upload
        </label>
        <input type="file" name="VehicleDocFile[file_upload]" id="vehicle_doc_file_input" style="display: none;" />
        <span id="selected-file-name" class="file-name-display">No file chosen</span>
    </li>
</ul>

<!-- 🔷 Documents Table -->
<section class="panel">
    <div class="panel-body mt-4">
        <div class="custom-data-table">
            <input type="hidden" name="doc_id" id="doc_id" value="<?php echo CHtml::encode($model->id); ?>">
            <div class="table-responsive">
                <table class="table table-hover table-bordered" id="tbl_documents" style="width: 100% !important;">
                    <thead>
                        <tr>
                            <th>Sl.No</th>
                            <th>Document Name</th>
                            <th>File Name</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    
                </table>
            </div>
        </div>
    </div>
</section>
