<?php $cs = Yii::app()->getClientScript(); ?>

<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'masvehicle-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    'htmlOptions' => array('enctype' => 'multipart/form-data'),
));
$baseUrl = Yii::app()->baseUrl;
?>

<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li class="active"><a href="#vehicle_tab1" data-toggle="tab">General Info</a></li>
    <?php if (isset(Yii::app()->user->havePermissionOn['sales_master_masvehicle_upload']) || Yii::app()->user->authorised_user == 1) { ?>
    <li><a href="#vehicle_tab2" data-toggle="tab">Upload Documents</a></li>
    <?php } ?>
</ul>

<div class="tab-content">
    <div class="tab-pane active" id="vehicle_tab1">
        <?php $this->renderPartial('general_info', array('model' => $model, 'form' => $form)); ?>
    </div>
    <div class="tab-pane" id="vehicle_tab2">
        <?php $this->renderPartial('documents', array('model' => $model, 'model_details' => $model_details, 'form' => $form)); ?>
    </div>
</div>

<input type="hidden" name="masvehicle-form" value="">

<div class="modal-footer">
    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
    <button type="button" id="save-vehicle-btn" class="masvehicle-save-btn btn btn-theme">Save</button>
</div>

<?php $this->endWidget(); ?>

<?php
$saveUrl = Yii::app()->createUrl('vehicle/masvehicle/Savemasvehicle');

$cs->registerScript('saveVehicleAjax', "
$('#save-vehicle-btn').on('click', function(e) {
    e.preventDefault();
    var form = $('#masvehicle-form')[0];
    var formData = new FormData(form);

    $.ajax({
        url: '{$saveUrl}',
        type: 'POST',
        data: formData,
        dataType: 'json',
        processData: false,
        contentType: false,

        beforeSend: function() {
            $('#masvehicle-form .masvehicle-save-btn').prop('disabled', true)
                .addClass('btn_loding').removeClass('btn-theme');
            $('.toast8-error').hide();
        },

        success: function(data) {
            if (data.status === 'success') {
                t8.success('Vehicle Saved Successfully!');
                if (data.from !== '') {
                    loadPopupModal(data.from + '/create&masvehicle=' + data.id, 'Add New Vehicle', 'lg');
                } else {
                    $('.x.close').click();
                    reloadTable('#tbl_masvehicle');
                }
            } else {
                $('#masvehicle-form .masvehicle-save-btn').prop('disabled', false)
                    .addClass('btn-theme').removeClass('btn_loding');

                $.each(data, function(key, val) {
                    $('#masvehicle-form #' + key + '_em_').text(val).show();
                    t8.error(val);
                });
            }
        },

        error: function(xhr, status, error) {
            $('#masvehicle-form .masvehicle-save-btn').prop('disabled', false)
                .addClass('btn-theme').removeClass('btn_loding');
            t8.error('An error occurred: ' + error);
        }
    });
});
", CClientScript::POS_END);

$cs->registerScript('reloadDocumentsTab', "
$('a[data-toggle=\"tab\"]').on('shown.bs.tab', function (e) {
    var target = $(e.target).attr('href');
    if (target === '#vehicle_tab2') {
        if ($.fn.DataTable.isDataTable('#tbl_documents')) {
            $('#tbl_documents').DataTable().ajax.reload(null, false);
        } else if (typeof initVehicleDocumentsTable === 'function') {
            initVehicleDocumentsTable();
        }
    }
});
", CClientScript::POS_END);
?>
