<?php

/**
 * This is the model class for table "{{mas_vehicle_service_status}}".
 *
 * The followings are the available columns in table '{{mas_vehicle_service_status}}':
 * @property integer $id
 * @property string $status_type
 * @property string $isActive
 * @property string $isDefault
 * @property string $created_date_time
 * @property integer $created_by
 * @property string $updated_date_time
 * @property integer $updated_by
 */
class MasVehicleServiceStatus extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_vehicle_service_status}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('status_type', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('status_type', 'length', 'max'=>100),
			array('isActive, isDefault', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, status_type, isActive, isDefault, created_date_time, created_by, updated_date_time, updated_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'status_type' => 'Status Type',
			'isActive' => 'Is Active',
			'isDefault' => 'Is Default',
			'created_date_time' => 'Created Date Time',
			'created_by' => 'Created By',
			'updated_date_time' => 'Updated Date Time',
			'updated_by' => 'Updated By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('status_type',$this->status_type,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('isDefault',$this->isDefault,true);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasVehicleServiceStatus the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public static function getServiceStatuses() {


        $condition = '1=1';
        $condition .= ' AND isActive="Y" ';

        $model = self::model()->findAll(array('condition' => $condition, "order" => "status_type ASC"));

        return CHtml::listData($model, 'id', 'status_type');
    }
}
