<?php

/**
 * This is the model class for table "{{mas_vehicle}}".
 *
 * The followings are the available columns in table '{{mas_vehicle}}':
 * @property integer $id
 * @property string $vehicle_make
 * @property string $vehicle_id
 * @property string $vehicle_vin_no
 * @property string $hasPermit
 * @property string $created_date_time
 * @property integer $created_by
 * @property string $updated_date_time
 * @property integer $updated_by
 * @property string $fuel_type
 * @property string $insurance_validity_date
 * @property integer $manufacturing_year
 * @property string $vehicle_model
 * @property string $registered_state
 * @property string $isActive
 */
class MasVehicle extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_vehicle}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vehicle_id,vehicle_make, vehicle_vin_no, vehicle_model', 'required'),
			array('created_by, updated_by, manufacturing_year', 'numerical', 'integerOnly'=>true),
			array('vehicle_make, vehicle_model, registered_state', 'length', 'max'=>150),
			array('vehicle_vin_no', 'length', 'max'=>100),
			array('hasPermit, isActive', 'length', 'max'=>1),
			array('fuel_type', 'length', 'max'=>50),
			array('vehicle_model', 'unique'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, vehicle_make, vehicle_vin_no, hasPermit, created_date_time,vehicle_id, created_by, updated_date_time, updated_by, fuel_type, insurance_validity_date, manufacturing_year, vehicle_model, registered_state, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'vehicle_id' => 'Vehicle ID',
			'vehicle_make' => 'Vehicle Make',
			'vehicle_vin_no' => 'Vehicle Vin No',
			'hasPermit' => 'Has Permit',
			'created_date_time' => 'Created Date Time',
			'created_by' => 'Created By',
			'updated_date_time' => 'Updated Date Time',
			'updated_by' => 'Updated By',
			'fuel_type' => 'Fuel Type',
			'insurance_validity_date' => 'Insurance Validity Date',
			'manufacturing_year' => 'Manufacturing Year',
			'vehicle_model' => 'Vehicle Model',
			'registered_state' => 'Registered State',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('vehicle_make',$this->vehicle_make,true);
		$criteria->compare('vehicle_vin_no',$this->vehicle_vin_no,true);
		$criteria->compare('hasPermit',$this->hasPermit,true);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('fuel_type',$this->fuel_type,true);
		$criteria->compare('insurance_validity_date',$this->insurance_validity_date,true);
		$criteria->compare('manufacturing_year',$this->manufacturing_year);
		$criteria->compare('vehicle_model',$this->vehicle_model,true);
		$criteria->compare('registered_state',$this->registered_state,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasVehicle the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public static function getVehicleMakeModelList() {
    $condition = '1=1 AND isActive="Y"';

    $model = self::model()->findAll(array(
        'condition' => $condition,
        'order' => 'vehicle_make ASC'
    ));

    $list = array();
    foreach ($model as $data) {
        $list[$data->id] = $data->vehicle_make . ' - ' . $data->vehicle_model;
    }

    return $list;
}


}
