<?php

/**
 * This is the model class for table "{{mas_maintainance_service}}".
 *
 * The followings are the available columns in table '{{mas_maintainance_service}}':
 * @property integer $id
 * @property string $garage_name
 * @property string $description
 * @property integer $odometer_reading
 * @property integer $estimated_cost
 * @property string $service_status
 * @property string $isActive
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property integer $created_by
 * @property string $created_date_time
 * @property string $vehicle_name
 * @property string $sheduled_date_time
 * @property integer $maintainance_master_id
 */
class MasMaintainanceService extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_maintainance_service}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('garage_name', 'required'),
			array('odometer_reading, updated_by, created_by, maintainance_master_id', 'numerical', 'integerOnly'=>true),
			array('garage_name', 'length', 'max'=>100),
			array('service_status', 'length', 'max'=>50),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, garage_name, description,total_cost,service_notes,planned_date,odometer_reading, estimated_cost, service_status,vehicle_name, isActive, updated_by, updated_date_time, created_by, created_date_time, sheduled_date_time, maintainance_master_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
        'vehicle' => array(self::BELONGS_TO, 'MasVehicle', 'vehicle_name'),
		'school_class' => array(self::BELONGS_TO, 'MasEduSchool', 'school_id'),
		'employee' => array(self::BELONGS_TO, 'Employee', 'current_employee_id'),

    );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'garage_name' => 'Garage Name',
			'description' => 'Description',
			'vehicle_name' => 'Vehicle Name',
			'odometer_reading' => 'Odometer Reading',
			'estimated_cost' => 'Estimated Cost',
			'service_status' => 'Service Status',
			'isActive' => 'Is Active',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'sheduled_date_time' => 'Sheduled Date Time',
			'maintainance_master_id' => 'Maintainance Master',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('garage_name',$this->garage_name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('odometer_reading',$this->odometer_reading);
		$criteria->compare('estimated_cost',$this->estimated_cost);
		$criteria->compare('vehicle_name',$this->vehicle_name);
		$criteria->compare('service_status',$this->service_status,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('sheduled_date_time',$this->sheduled_date_time,true);
		$criteria->compare('maintainance_master_id',$this->maintainance_master_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasMaintainanceService the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
