<?php

class MasvehicleController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','getmasvehiclelist','Savemasvehicle','Disable','GetDocumentList','Print'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
    //     if (Yii::app()->user->authorised_user == 1 ||
    //     (
    //         isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
    //         isset(Yii::app()->user->havePermissionOn['masvehicle_view']) &&
    //         Yii::app()->user->havePermissionOn['masters_menu_view'] && 
    //         Yii::app()->user->havePermissionOn['masvehicle_view']
    //     )
    // ) {
        $this->render('index');
    // } else {
    //     $this->layout = false;
    //     $this->render('/site/unauthorised');
    //     Yii::app()->end(); // Prevent further execution
    // }
    }

    public function actionCreate()
{
    $model = new MasVehicle();
    $model_doc = new VehicleDocFile();
    $id = (int) Yii::app()->request->getParam('id');
    $from = Yii::app()->request->getParam('from');

    if ($id > 0) {
        $model = $model->findByPk($id);
    } else {
        // Auto-assign vehicle_id starting from 100
        $lastVehicle = MasVehicle::model()->find(array(
            'order' => 'vehicle_id DESC',
            'condition' => 'vehicle_id >= 100',
        ));

        if ($lastVehicle) {
            $model->vehicle_id = $lastVehicle->vehicle_id + 1;
        } else {
            $model->vehicle_id = 100;
        }
    }

    Yii::app()->clientScript->scriptMap = array(
        '*jquery.js' => false,
        '*jquery.min.js' => false,
        'jquery.min.js' => false,
        '*jquery-ui.js' => false,
        '*jquery-ui.min.js' => false,
        'jquery-2.1.4.min.js' => false
    );

    $this->render('create', array(
        'model' => $model,
        'model_doc' => $model_doc,
        'from' => $from
    ), false, true);
}


    public function actiongetmasvehiclelist()
        {
            
                $model=new MasVehicle();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'id',
                   1 =>'vehicle_id',
				   2 =>'vehicle_make',
                   3 =>'vehicle_model',
				   4 =>'vehicle_vin_no',


                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                // $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (vehicle_model LIKE '%".$searchString."%'OR vehicle_id LIKE '%".$searchString."%'OR vehicle_make LIKE '%".$searchString."%'OR vehicle_vin_no LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'vehicle_id ASC'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $rowData[]=array($m,
                        $row['vehicle_id'],
                        $row['vehicle_make'],
                        $row['vehicle_model'],
                        $row['vehicle_vin_no'],
                        array('id' => $row['id'],'code'=>$row['vehicle_model'], 'status' => $row->isActive));


                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
      
    }
    public function actionSavemasvehicle()
{
    $model = new MasVehicle();

    if (isset($_POST['MasVehicle'])) {
        $isUpdate = false;

        // Set audit info
        if ((int) @$_POST['MasVehicle']['id'] > 0) {
            $id = (int) $_POST['MasVehicle']['id'];
            $model = MasVehicle::model()->findByPk($id);
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d H:i:s');
            $audit_type = 'UPDATED';
            $isUpdate = true;
        } else {
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $audit_type = 'CREATED';
        }

        // Assign model attributes
        $model->attributes = $_POST['MasVehicle'];
        $model->hasPermit = $_POST['MasVehicle']['hasPermit'];
        $model->vehicle_id = $_POST['MasVehicle']['vehicle_id'];
        $model->lic_plate_no = $_POST['MasVehicle']['lic_plate_no'];

        // Format date fields
        $model->insurance_validity_date = self::formatDate($_POST['MasVehicle']['insurance_validity_date']);
        $model->registration_expiry_date = self::formatDate($_POST['MasVehicle']['registration_expiry_date']);
        $model->permit_expiry_date = self::formatDate($_POST['MasVehicle']['permit_expiry_date']);
        $model->pollution_expiry_date = self::formatDate($_POST['MasVehicle']['pollution_expiry_date']);

        if ($model->validate()) {
            $model->save();

            // Audit log
            AuditLog::saveAuditLogs(
                'VEHICLE',
                Yii::app()->user->id,
                $audit_type,
                " with name: - {$model->vehicle_model}"
            );

            // Handle document upload
            if (
                isset($_FILES['VehicleDocFile']['name']['file_upload']) &&
                $_FILES['VehicleDocFile']['name']['file_upload'] != ''
            ) {
                $uploadedDoc = CUploadedFile::getInstanceByName('VehicleDocFile[file_upload]');
                if ($uploadedDoc !== null) {
                    $docFileName = time() . '_' . preg_replace("/[^a-zA-Z0-9.]/", "_", $uploadedDoc->name);
                    $uploadDir = Yii::getPathOfAlias('webroot') . '/uploads/vehicle_docs/';
                    if (!is_dir($uploadDir)) {
                        mkdir($uploadDir, 0755, true);
                    }

                    $uploadPath = $uploadDir . $docFileName;
                    if ($uploadedDoc->saveAs($uploadPath)) {
                        $modelDoc = new VehicleDocFile();
                        $modelDoc->vehicle_id = $model->id;
                        $modelDoc->document_name = $_POST['VehicleDocFile']['document_name'];
                        $modelDoc->file_name = $docFileName;
                        $modelDoc->type = $_POST['VehicleDocFile']['file_name']; // if any
                        $modelDoc->created_by = Yii::app()->user->id;
                        $modelDoc->created_date_time = date('Y-m-d H:i:s');
                        $modelDoc->save(false);
                    }
                }
            }

            // Success JSON response
            echo CJSON::encode([
                'status' => 'success',
                'frm' => $_POST['masvehicle-form'],
                'from' => $_POST['from'],
                'id' => $model->id,
            ]);
            Yii::app()->end();
        } else {
            // Validation errors
            echo CActiveForm::validate($model, '', false);
            Yii::app()->end();
        }
    }
}

// Utility method for safe date parsing
private static function formatDate($dateStr)
{
    if (count(explode('/', $dateStr)) === 3) {
        return date('Y-m-d', strtotime(str_replace('/', '-', $dateStr)));
    }
    return '0000-00-00';
}

        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasVehicle();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

    public function actionGetDocumentList()
{
    $request = Yii::app()->request;

    $start = intval($request->getPost('start', 0));
    $length = intval($request->getPost('length', 10));
    $search = trim($request->getPost('search')['value']);
    $doc_id = intval($request->getPost('doc_id'));

    $condition = "vehicle_id = :vehicle_id";
    $params = [':vehicle_id' => $doc_id];

    if (!empty($search)) {
        $condition .= " AND document_name LIKE :search";
        $params[':search'] = '%' . $search . '%';
    }

    $count = VehicleDocFile::model()->count($condition, $params);

    $sql = "SELECT * FROM erp_vehicle_doc_file WHERE {$condition} ORDER BY id DESC LIMIT :limit OFFSET :offset";
    $command = Yii::app()->db->createCommand($sql);

    foreach ($params as $key => $value) {
        $command->bindValue($key, $value);
    }

    $command->bindValue(':limit', $length, PDO::PARAM_INT);
    $command->bindValue(':offset', $start, PDO::PARAM_INT);

    $rows = $command->queryAll();

    $output = [];
    $i = $start + 1;
    foreach ($rows as $row) {
        $fileUrl = Yii::app()->baseUrl . '/uploads/vehicle_docs/' . $row['file_name'];
        $output[] = [
            'sl_no' => $i++,
            'document_name' => CHtml::encode($row['document_name']),
            'file_name' => CHtml::encode($row['file_name']),
'download' => '<a href="' . $fileUrl . '" target="_blank" class="btn btn-sm btn-primary"><i class="fa fa-download"></i></a>',
        ];
    }

    echo CJSON::encode([
        "draw" => intval($request->getPost('draw')),
        "recordsTotal" => $count,
        "recordsFiltered" => $count,
        "data" => $output,
    ]);

    Yii::app()->end();
}
public function actionPrint()
{
    $id = Yii::app()->request->getParam('id');
    $model = MasVehicle::model()->findByPk($id);

    if ($model === null) {
        throw new CHttpException(404, 'The requested vehicle does not exist.');
    }

    // Load mPDF via ePdf
    $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

    // Load common PDF stylesheet
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mPDF1->WriteHTML($stylesheet, 1);

    // Render your custom PDF view
    $html = $this->renderPartial(
        'application.views.front.pdf.vehicle_print',
        array('model' => $model),
        true
    );

    $mPDF1->WriteHTML($html);

    // Output the PDF
    $mPDF1->Output("Vehicle_" . $model->vehicle_id . ".pdf", "I"); // I = open in browser
}

    
}