<?php

class MasservicestatusController extends Controller
{
	public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'Savemasservicestatus', 'Deletemasservicestatus', 'DirectAdd', 'Disable','UploadProfilePhoto'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['master_child_support_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['master_child_support_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
                $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
        }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
    $model = new MasVehicleServiceStatus();
    $draw = $_POST['draw'];
    $offset = $_POST['start'];
    $limit = $_POST['length'];

    $columns = array(
        0 => 'id',
        1 => 'status_type',
       
    );

    $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                // $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (status_type LIKE '%".$searchString."%')";
                }

    $count = $model->count(array('condition' => $condition));
    $modelList = $model->findAll(array(
        'condition' => $condition,
        'limit' => $limit,
        'offset' => $offset,
        'order' => 'status_type ASC'
    ));

    $data['draw'] = $draw;
    $data['recordsTotal'] = $count;
    $data['recordsFiltered'] = $count;

    $rowData = array();
    $m = 1;
    foreach ($modelList as $row) {
        $rowData[] = array(
            $m,
            $row['status_type'],
			$row['isDefault'],
            array(
                'id' => $row['id'],
                'code' => $row['status_type'],
                'status' => $row->isActive
            )
        );
        $m++;
    }

    $data['data'] = $rowData;
    echo json_encode($data);
}



    public function actionCreate() {
        $model = new MasVehicleServiceStatus();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actionSavemasservicestatus() {
        $model = new MasVehicleServiceStatus();
    
        if (isset($_POST['MasVehicleServiceStatus'])) {
            $isNew = true;
    
            // Check if it's an update
            if ((int) $_POST['MasVehicleServiceStatus']['id'] > 0) {
                $model = MasVehicleServiceStatus::model()->findByPk((int) $_POST['MasVehicleServiceStatus']['id']);
                if ($model === null) {
                    echo CJSON::encode(array('status' => 'error', 'message' => 'Invalid MasVehicleServiceStatus ID'));
                    return;
                }
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
                $audit_type = 'UPDATED';
                $isNew = false;
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $audit_type = 'CREATED';
            }
    
            // Set attributes first
            $model->attributes = $_POST['MasVehicleServiceStatus'];
            $model->isDefault = $_POST['MasVehicleServiceStatus']['isDefault'];
    
            //Reset all other defaults if this isDefault is Y
            if ($model->isDefault == "Y") {
                MasVehicleServiceStatus::model()->updateAll(array('isDefault' => 'N'), 'isDefault = "Y" AND id != :id', array(':id' => $model->id ? $model->id : 0));
            }
            // Save model
            if ($model->save()) {
                // Audit log
                AuditLog::saveAuditLogs(
                    'MasVehicleServiceStatus',
                    Yii::app()->user->id,
                    $audit_type,
                    " with code : - {$model->status_type}"
                );
    
                echo CJSON::encode(array(
                    'status' => 'success',
                    'id' => $model->id
                ));
            } else {
                echo CActiveForm::validate($model);
            }
        }
    }
    
            public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasVehicleServiceStatus();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    
    
}
