<?php

class MasmaintainanceController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','getMasMaintainancelist','Savemasmaintainance','Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['masmaintainance_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['masmaintainance_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
    }

    public function actionCreate()
    {
        $model=new MasMaintainance();
        $id = (int) Yii::app()->request->getParam('id');
        $from =  Yii::app()->request->getParam('from');
        if($id>0){
            $model=$model->findByPk($id);
        }
     Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);   
    $this->render('create', array('model' => $model,'from' =>$from), false, true);
    }

    public function actiongetMasMaintainancelist()
        {
            
                $model=new MasMaintainance();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'id',
				   1 =>'maintainance_type',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                // $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (maintainance_type LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'maintainance_type ASC'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $rowData[]=array($m,
                        $row['maintainance_type'],
                        $row['isDefault'],
                        array('id' => $row['id'],'code'=>$row['maintainance_type'], 'status' => $row->isActive));

                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
      
    }
    public function actionSavemasmaintainance()
    {
    $model = new MasMaintainance();
        if (isset($_POST['MasMaintainance']))
        {
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time =date('Y-m-d h:i:s');
            if ((int) @$_POST['MasMaintainance']['id'] > 0)
            {   $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time =date('Y-m-d h:i:s');
                $id= (int) @$_POST['MasMaintainance']['id'];
                $model=$model->findByPk($id);
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
            }
            $model->attributes=$_POST['MasMaintainance'];
			if($_POST['MasMaintainance']['isDefault'] == "Y"){
                MasMaintainance::model()->updateAll(array( 'isDefault' => 'N' ), 'isDefault = "Y"' );
            }
            $model->isDefault = $_POST['MasMaintainance']['isDefault'];
            if($model->validate())
               
            {
                 $model->save();
                  // inserting to audit log
                  AuditLog::saveAuditLogs(
                    'MAINTAINANACE',
                    Yii::app()->user->id,
                    $audit_type,
                    " with name: - {$model->maintainance_type}  "
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['status-form'];
                $jsonData['from'] = $_POST['from'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            }
            else
            {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
            echo $error;
            }
        }
    }
        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasMaintainance();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}