<?php

class TruncateController extends Controller
{

	public $layout = 'layout';

	public function accessRules()
	{
		return array(
			array(
				'allow', // allow all users to perform 'index' and 'view' actions
				'actions' => array('login', 'error', 'logout'),
				'users' => array('*'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array(
					'SettingsLogin',
					'Index',
					'SavemoduleDetails',
					'Index',
					'package',
					'SavePackageDetails',
					'SaveSettings',
					'SavecurrentPackage',
					'SaveuploadSize',
					'RestorePackage',
					'MasSettingsLogin'
				),
				'expression' => '$user->isMember()',
			),
			array(
				'deny', // deny all users
				'users' => array('*'),
			),
		);
	}
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	public function actionSettingsLogin()
	{
		$model = new HrMasSettingsLogin();
		Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
		$this->render('settings_login_form', array('model' => $model));
	}


	public function actionIndex()
	{
		$this->render('index');

	} 

	public function actionMasSettingsLogin()
	{
		$model = new HrMasSettingsLogin();
		if (isset($_POST['HrMasSettingsLogin'])) {
			$salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
			$password = crypt($_POST['HrMasSettingsLogin']['password'], $salt);
			$model_login = HrMasSettingsLogin::model()->find();
			if ($model_login->password != $password) {
				$error['status'] = "error";
				$error['msg'] = "Invalid password!";
			} else {
				Yii::app()->session['master_settings_login'] = $model_login->id;
				$error['status'] = "success";
				$error['msg'] = "Login Success";
			}
			echo CJSON::encode($error);
		} else {
			$error = CActiveForm::validate($model, '', false);
			if ($error != '[]')
				echo $error;
		}
	}
}