<?php
$stock_count_file = (int) StockCountFile::model()->count(array('condition'=>'active_stock_count="Y"'));

$cs = Yii::app()->getClientScript();
$cs->registerScript("disableStockCountFile", "function disableStockCountFile(id){
    var r = confirm('Are you sure to block this StockCountFile?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=stockcount/StockCountFile/BlockStockCountFile',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                    t8.error('Error while Delete');
                }else {
                     reloadTable('#tbl_stockcountfile_details');

                    t8.success('Bank blocked SuccessFully');
                }
               }
            });
        }


};", CClientScript::POS_HEAD);
$cs->registerScript("enableStockCountFile", "function enableStockCountFile(id){
    var r = confirm('Are you sure to unblock this StockCountFile?');
        if(r==true)
        {
            jQuery.ajax({
                'type'  : 'post',
                'dataType'  : 'json',
                'data'  : 'id=' + id,
                'url'  : $('#liveSite').val()+'index.php?r=stockcount/StockCountFile/UnBlockStockCountFile',
                'cache': false,
                'success':function(data){
                    if(data.status=='success'){
                        reloadTable('#tbl_stockcountfile_details');
                        t8.success('Bank Unblocked SuccessFully!');

                    }else {
                        t8.error('This Bank cant be Unblocked');
                    }
                 }
            });
        }
};", CClientScript::POS_END);

 $cs->registerScript("DeletePhysicalStock", "function DeletePhysicalStock(id){
    var r = confirm('Are you sure you want to delete the Physical Quantity?');
    if (r == true)
    {
            jQuery.ajax({
            'type'  : 'post',
                    'datatype' :'json',
                    'data'  : 'id=' + id,
                    'url'  : $('#liveSite').val() + 'index.php?r=stockcount/stockcount/DeletePhysicalStock',
                    'cache': false,
                    'success':function(data){
                    if (data.status == 'fail'){
                        t8.error('Error while Delete');
                    } else {
                            t8.success('Physical Qunatity deleted SuccessFully!');
                        }
                    }
            });
        }

    }", CClientScript::POS_END);
 
?>
<script>
    var imageBase64Logo = null;
    $(document).ready(function () {
        var table_id = "#tbl_stockcountfile_details";
        table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            //scrollY: "450px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('stockcount/StockCountFile/GetStockCountFileList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            columnDefs: [
                       {
                          "targets": [4],"visible": false,
                       },
            ],

            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                if ( aData[5] == "N" )  
                {  
                   $("td", nRow).addClass("bg-danger");

                }
                         
                  
            }
        });

    });</script>



    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-university"></i> Stock Transactions
            <div class="pull-right">
                <?php  if ($stock_count_file==0) {?>
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('stockcount/StockCountFile/create','Add New Stock Transaction','lg')"><i class="fa fa-plus"></i> ADD</button>
                <?php } ?>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_stockcountfile_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Date</th>
                            <th>File Name</th>
						    <th class="noExport">Action</th>
                        </tr>
                    </thead>
                  
                </table>
            </div>
        </div>
    </section>
