<?php

/**
 * This is the model class for table "{{stock_physical_quantity}}".
 *
 * The followings are the available columns in table '{{stock_physical_quantity}}':
 * @property integer $id
 * @property integer $product_id
 * @property string $part_number
 * @property string $description
 * @property string $physical_quantity
 * @property integer $uploaded_by
 * @property string $upload_date_time
 */
class StockPhysicalQuantity extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{stock_physical_quantity}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, part_number, description, physical_quantity,current_qty, transaction_id,uploaded_by, upload_date_time', 'required'),
			array('product_id, uploaded_by', 'numerical', 'integerOnly'=>true),
			array('part_number, description', 'length', 'max'=>255),
			array('physical_quantity', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, part_number, description, physical_quantity, transaction_id,uploaded_by, upload_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'part_number' => 'Part Number',
			'description' => 'Description',
			'physical_quantity' => 'Physical Quantity',
			'uploaded_by' => 'Uploaded By',
			'upload_date_time' => 'Upload Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('part_number',$this->part_number,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('physical_quantity',$this->physical_quantity,true);
		$criteria->compare('uploaded_by',$this->uploaded_by);
		$criteria->compare('upload_date_time',$this->upload_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return StockPhysicalQuantity the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
