<?php

class StockcountController extends Controller
{

	public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','DownloadStockCountCsv','UploadStockCount','DownloadStockCount','Upload','SaveStockCount',
                'UnblockStockLockFlag','BlockStockLockFlag','UpdateStock','PhysicalStock','DeletePhysicalStock','ViewStockDifference'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

	public function actionIndex()
	{
		$this->render('index');
	}
	
	public function actionPhysicalStock()
	{
		$this->render('physical_stock');
	}

    public function actionUpdateStock() {
        
        $modelWarehouse = new MasInventoryWarehouse();
        $modelWarehouse = $modelWarehouse->getDefaultWarehouse();
        
        $arr_stock_count_file_name =  StockCountFile::model()->find(array('condition'=>'active_stock_count="Y"'));
        
        $stock_count_file_name = $arr_stock_count_file_name['file_name'];
        
        $transaction_id=$arr_stock_count_file_name['id'];
        
        foreach($_POST['InventoryGoodsReceiptItem'][0] as $gr=>$eachReceiptItem){
              $product_id   = (int) $eachReceiptItem['product_id'];
              $product_name =  $eachReceiptItem['product_name'];
              $description  =  $eachReceiptItem['description'];
              $quantity     =  $eachReceiptItem['picked_qty'];
            
              $modelStore = new Store();
              $modelStore = $modelStore->findByPk($product_id);

              $modelUOM = new UnitOfMeasurement();
              $modelUOM = $modelUOM->find(array('condition'=>'product_id='.$product_id));
              
              $physical_stock_gr_id = $_POST['physical_stock_gr_id_0_'.$gr];
              
              //echo $physical_stock_gr_id."<br>";
            
             if($gr==0){
                   //update InventoryGoodsReceipt
                    $modelInventoryGoodsReceipt = new InventoryGoodsReceipt;
                    $modelInventoryGoodsReceipt->goods_receipt_date  = date('Y-m-d');
                    $modelInventoryGoodsReceipt->file_id  = 0;
                    $modelInventoryGoodsReceipt->customer_id = 0;
                    $modelInventoryGoodsReceipt->project_id = 0;
                    $modelInventoryGoodsReceipt->ticket_id = 0;
                    $modelInventoryGoodsReceipt->contract_id = 0;
                    $modelInventoryGoodsReceipt->project_classification_id = 0;
                    $modelInventoryGoodsReceipt->warehouse_id= $modelWarehouse->id;
                    $modelInventoryGoodsReceipt->notes = 'Auto receipt voucher for stock adjustment - '.$stock_count_file_name;
                    $modelInventoryGoodsReceipt->terms_and_conditions = '';
                    $modelInventoryGoodsReceipt->remarks = 'Auto receipt voucher for stock adjustment - '.$stock_count_file_name;
                    $modelInventoryGoodsReceipt->reference= $physical_stock_gr_id;
                    $modelInventoryGoodsReceipt->receipt_notification = '';
                    $modelInventoryGoodsReceipt->posted= 'N';
                    $modelInventoryGoodsReceipt->receipt_type = 0;
                    $modelInventoryGoodsReceipt->stock_updated= 'Y';
                    $modelInventoryGoodsReceipt->isActive = 'Y';
                    $modelInventoryGoodsReceipt->updated_by= Yii::app()->user->id;
                    $modelInventoryGoodsReceipt->updated_date_time = date('Y-m-d h:i:s');
                    $modelInventoryGoodsReceipt->save(false);
                    
                    $header_id = $modelInventoryGoodsReceipt->id;
                  }
                  
                  
                  //update InventoryGoodsReceiptItem
                    
                    $modelInventoryGoodsReceiptItem = new InventoryGoodsReceiptItem();
                    $modelInventoryGoodsReceiptItem->inventory_goods_receipt_id   = $header_id;
                    $modelInventoryGoodsReceiptItem->product_id   = $product_id;
                    $modelInventoryGoodsReceiptItem->product_name = $product_name;
                    $modelInventoryGoodsReceiptItem->description = $description;
                    $modelInventoryGoodsReceiptItem->unit = $modelUOM->id;
                    $modelInventoryGoodsReceiptItem->rate = $modelStore->rate;
                    $modelInventoryGoodsReceiptItem->old_rate = 0;
                    $modelInventoryGoodsReceiptItem->picked_qty= abs($quantity);
                    $modelInventoryGoodsReceiptItem->updated_by = Yii::app()->user->id;
                    $modelInventoryGoodsReceiptItem->updated_date_time = date('Y-m-d h:i:s'); 
                    $modelInventoryGoodsReceiptItem->save(false);
                    $header_item_id = (int) $modelInventoryGoodsReceiptItem->id;
                    
                    $transaction_from = 'INVENTORY_GOODS_RECEIPT';
                    $transaction_type = 'IN';
                    
                    $modelStockLedger = new StockLedger();
                    $modelStockLedger->file_id = 0;
                    $modelStockLedger->header_id = $header_id;
                    $modelStockLedger->header_item_id= $header_item_id;
                    $modelStockLedger->ticket_id = 0;
                    $modelStockLedger->project_classification_id = 0;
                    $modelStockLedger->contract_id = 0;
                    $modelStockLedger->customer_vendor_id = 0;
                    $modelStockLedger->customer_vendor_name= '';
                    $modelStockLedger->product_id = $product_id;
                    $modelStockLedger->product_name = $product_name;
                    $modelStockLedger->product_description = $description;
                    $modelStockLedger->brand_id= $modelStore->brand_class_id ;
                    $modelStockLedger->brand_name = $modelStore->brand_detail->brand_name;
                    $modelStockLedger->warehouse_id= $modelWarehouse->id;
                    $modelStockLedger->warehouse_name = $modelWarehouse->warehouse_name;
                    $modelRack = new MasInvRack();
                    $modelStockLedger->rack_id = $modelRack->getDefaultRackId();
                    $modelStockLedger->rack_name = $modelRack->getRackName((int) $modelStockLedger->rack_id);
                    $modelBin = new MasInvBin();
                    $modelStockLedger->bin_id = $modelBin->getDefaultBinId();
                    $modelStockLedger->bin_name = $modelBin->getBinName((int) $modelStockLedger->bin_id);
                    $modelStockLedger->unit_id = $modelUOM->id;
                    $modelStockLedger->unit_name = $modelUOM->name;
                    $modelStockLedger->unit_factor = $modelUOM->factor;
                    $modelStockLedger->quantity = $quantity;
                    $modelStockLedger->available_status = 'Y';
                    $modelStockLedger->batch_no= '';
                    $modelStockLedger->serial_no = '';
                    $modelStockLedger->manufacturing_date= '0000-00-00';
                    $modelStockLedger->expiry_date = '0000-00-00';
                    $modelStockLedger->buying_price = $modelStore->rate;
                    $modelStockLedger->cost_price= $modelStore->rate;
                    $modelStockLedger->sales_price = 0;
                    $modelStockLedger->stock_after_transaction = 0;
                    $modelStockLedger->stock_value_after_transaction= 0;
                    $modelStockLedger->transaction_date  = date('Y-m-d');
                    $modelStockLedger->transaction_cost_rate = $modelStore->rate;
                    $modelStockLedger->updated_cost_rate= 0;
                    $modelStockLedger->transaction_from = $transaction_from;
                    $modelStockLedger->transaction_type = $transaction_type;
                    $modelStockLedger->master_stock_ledger_id  = 0;
                    $modelStockLedger->stock_updated = 'Y';
                    $modelStockLedger->remarks= 'Auto receipt voucher for stock adjustment - '.$stock_count_file_name;
                    $modelStockLedger->old_cost_price = 0;
                    $modelStockLedger->created_by = Yii::app()->user->id;
                    $modelStockLedger->created_date = date('Y-m-d h:i:s');
                    $modelStockLedger->save(false);
                    
                    //$modelStockPhysicalQuantity = new StockPhysicalQuantity();
                    
                    //$modelStockPhysicalQuantity->updateByPk($physical_stock_gr_id, array('updated_flag' => "Y"));
        }
        
        
        foreach($_POST['InventoryGoodsReceiptItem'][1] as $grwr=>$eachReceiptItem){
              $product_id   = (int) $eachReceiptItem['product_id'];
              $product_name =  $eachReceiptItem['product_name'];
              $description  =  $eachReceiptItem['description'];
              $quantity     =  $eachReceiptItem['picked_qty'];
            
              $modelStore = new Store();
              $modelStore = $modelStore->findByPk($product_id);

              $modelUOM = new UnitOfMeasurement();
              $modelUOM = $modelUOM->find(array('condition'=>'product_id='.$product_id));
              
              $physical_stock_grwr_id = $_POST['physical_stock_gr_id_1_'.$grwr];
              
              //echo $physical_stock_gr_id."<br>";
            
             if($grwr==0){
                   //update InventoryGoodsReceipt
                    $modelInventoryGoodsReceiptWithoutRate = new InventoryGoodsReceipt;
                    $modelInventoryGoodsReceiptWithoutRate->goods_receipt_date  = date('Y-m-d');
                    $modelInventoryGoodsReceiptWithoutRate->file_id  = 0;
                    $modelInventoryGoodsReceiptWithoutRate->customer_id = 0;
                    $modelInventoryGoodsReceiptWithoutRate->project_id = 0;
                    $modelInventoryGoodsReceiptWithoutRate->ticket_id = 0;
                    $modelInventoryGoodsReceiptWithoutRate->contract_id = 0;
                    $modelInventoryGoodsReceiptWithoutRate->project_classification_id = 0;
                    $modelInventoryGoodsReceiptWithoutRate->warehouse_id= $modelWarehouse->id;
                    $modelInventoryGoodsReceiptWithoutRate->notes = 'Auto receipt voucher for stock adjustment - '.$stock_count_file_name;
                    $modelInventoryGoodsReceiptWithoutRate->terms_and_conditions = '';
                    $modelInventoryGoodsReceiptWithoutRate->remarks = 'Auto receipt vocher for stock adjustment - '.$stock_count_file_name;
                    $modelInventoryGoodsReceiptWithoutRate->reference= $physical_stock_grwr_id;
                    $modelInventoryGoodsReceiptWithoutRate->receipt_notification = '';
                    $modelInventoryGoodsReceiptWithoutRate->posted= 'N';
                    $modelInventoryGoodsReceiptWithoutRate->receipt_type = 0;
                    $modelInventoryGoodsReceiptWithoutRate->stock_updated= 'N';
                    $modelInventoryGoodsReceiptWithoutRate->isActive = 'Y';
                    $modelInventoryGoodsReceiptWithoutRate->updated_by= Yii::app()->user->id;
                    $modelInventoryGoodsReceiptWithoutRate->updated_date_time = date('Y-m-d h:i:s');
                    $modelInventoryGoodsReceiptWithoutRate->save(false);
                    
                    $header_id = $modelInventoryGoodsReceiptWithoutRate->id;
                  }
                  
                  
                  //update InventoryGoodsReceiptItem
                    
                    $modelInventoryGoodsReceiptWithoutRateItem = new InventoryGoodsReceiptItem();
                    $modelInventoryGoodsReceiptWithoutRateItem->inventory_goods_receipt_id   = $header_id;
                    $modelInventoryGoodsReceiptWithoutRateItem->product_id   = $product_id;
                    $modelInventoryGoodsReceiptWithoutRateItem->product_name = $product_name;
                    $modelInventoryGoodsReceiptWithoutRateItem->description = $description;
                    $modelInventoryGoodsReceiptWithoutRateItem->unit = $modelUOM->id;
                    $modelInventoryGoodsReceiptWithoutRateItem->rate = $modelStore->rate;
                    $modelInventoryGoodsReceiptWithoutRateItem->old_rate = 0;
                    $modelInventoryGoodsReceiptWithoutRateItem->picked_qty= abs($quantity);
                    $modelInventoryGoodsReceiptWithoutRateItem->updated_by = Yii::app()->user->id;
                    $modelInventoryGoodsReceiptWithoutRateItem->updated_date_time = date('Y-m-d h:i:s'); 
                    $modelInventoryGoodsReceiptWithoutRateItem->save(false);
                    $header_item_id = (int) $modelInventoryGoodsReceiptWithoutRateItem->id;
                    
                   
                    
                    //$modelStockPhysicalQuantity = new StockPhysicalQuantity();
                    
                    //$modelStockPhysicalQuantity->updateByPk($physical_stock_grwr_id, array('updated_flag' => "Y"));
        }
        
        foreach($_POST['InventoryGoodsIssueItem'] as $gi=>$eachIssueItem){
              $product_id   = (int) $eachIssueItem['product_id'];
              $product_name =  $eachIssueItem['product_name'];
              $description  =  $eachIssueItem['description'];
              $quantity     =  $eachIssueItem['picked_qty'];
            
              $modelStore = new Store();
              $modelStore = $modelStore->findByPk($product_id);

              $modelUOM = new UnitOfMeasurement();
              $modelUOM = $modelUOM->find(array('condition'=>'product_id='.$product_id));
              
              $physical_stock_gi_id = $_POST['physical_stock_gi_id_'.$gi];
            
             if($gi==0){
                   //update InventoryGoodsIssue
                    $modelInventoryGoodsIssue = new InventoryGoodsIssue();
                    $modelInventoryGoodsIssue->goods_issue_date  = date('Y-m-d');
                    $modelInventoryGoodsIssue->file_id  = 0;
                    $modelInventoryGoodsIssue->ticket_id = 0;
                    $modelInventoryGoodsIssue->ledger_id = 0;
                    $modelInventoryGoodsIssue->subledger_id = 0;
                    $modelInventoryGoodsIssue->customer_id = 0;
                    $modelInventoryGoodsIssue->project_id = 0;
                    $modelInventoryGoodsIssue->project_classification_id = 0;
                    $modelInventoryGoodsIssue->contract_id = 0;
                    $modelInventoryGoodsIssue->warehouse_id= $modelWarehouse->id;
                    $modelInventoryGoodsIssue->notes = 'Auto issue voucher for stock adjustment - '.$stock_count_file_name;
                    $modelInventoryGoodsIssue->terms_and_conditions = '';
                    $modelInventoryGoodsIssue->remarks = 'Auto issue voucher for stock adjustment - '.$stock_count_file_name;
                    $modelInventoryGoodsIssue->reference= $physical_stock_gi_id;
                    $modelInventoryGoodsIssue->issue_notification = '';
                    $modelInventoryGoodsIssue->posted= 'N';
                    $modelInventoryGoodsIssue->issue_type = 0;
                    $modelInventoryGoodsIssue->stock_updated= 'Y';
                    $modelInventoryGoodsIssue->isActive = 'Y';
                    $modelInventoryGoodsIssue->updated_by= Yii::app()->user->id;
                    $modelInventoryGoodsIssue->updated_date_time = date('Y-m-d h:i:s');
                    $modelInventoryGoodsIssue->save(false);
                    
                    $header_id = $modelInventoryGoodsIssue->id;
                    
                    $transaction_from = 'GOODS_ISSUE';
                    $transaction_type = 'OUT';
                  }
                  
                  
                  //update InventoryGoodsIssueItem
                    
                    
                    $modelInventoryGoodsIssueItem = new InventoryGoodsIssueItem();
                    $modelInventoryGoodsIssueItem->inventory_goods_issue_id    = $header_id;
                    $modelInventoryGoodsIssueItem->product_id   = $product_id;
                    $modelInventoryGoodsIssueItem->product_name = $product_name;
                    $modelInventoryGoodsIssueItem->description = $description;
                    $modelInventoryGoodsIssueItem->unit = $modelUOM->id;
                    $modelInventoryGoodsIssueItem->rate = $modelStore->rate;
                    $modelInventoryGoodsIssueItem->picked_qty= $quantity;
                    $modelInventoryGoodsIssueItem->updated_by = Yii::app()->user->id;
                    $modelInventoryGoodsIssueItem->updated_date_time = date('Y-m-d h:i:s'); 
                    $modelInventoryGoodsIssueItem->save(false);
                    $header_item_id = (int) $modelInventoryGoodsIssueItem->id;
                    
                    $modelStockLedger = new StockLedger();
                    $modelStockLedger->file_id = 0;
                    $modelStockLedger->header_id = $header_id;
                    $modelStockLedger->header_item_id= $header_item_id;
                    $modelStockLedger->ticket_id = 0;
                    $modelStockLedger->project_classification_id = 0;
                    $modelStockLedger->contract_id = 0;
                    $modelStockLedger->customer_vendor_id = 0;
                    $modelStockLedger->customer_vendor_name= '';
                    $modelStockLedger->product_id = $product_id;
                    $modelStockLedger->product_name = $product_name;
                    $modelStockLedger->product_description = $description;
                    $modelStockLedger->brand_id= $modelStore->brand_class_id ;
                    $modelStockLedger->brand_name = $modelStore->brand_detail->brand_name;
                    $modelStockLedger->warehouse_id= $modelWarehouse->id;
                    $modelStockLedger->warehouse_name = $modelWarehouse->warehouse_name;
                    $modelRack = new MasInvRack();
                    $modelStockLedger->rack_id = $modelRack->getDefaultRackId();
                    $modelStockLedger->rack_name = $modelRack->getRackName((int) $modelStockLedger->rack_id);
                    $modelBin = new MasInvBin();
                    $modelStockLedger->bin_id = $modelBin->getDefaultBinId();
                    $modelStockLedger->bin_name = $modelBin->getBinName((int) $modelStockLedger->bin_id);
                    $modelStockLedger->unit_id = $modelUOM->id;
                    $modelStockLedger->unit_name = $modelUOM->name;
                    $modelStockLedger->unit_factor = $modelUOM->factor;
                    $modelStockLedger->quantity = $quantity;
                    $modelStockLedger->available_status = 'Y';
                    $modelStockLedger->batch_no= '';
                    $modelStockLedger->serial_no = '';
                    $modelStockLedger->manufacturing_date= '0000-00-00';
                    $modelStockLedger->expiry_date = '0000-00-00';
                    $modelStockLedger->buying_price = $modelStore->rate;
                    $modelStockLedger->cost_price= $modelStore->rate;
                    $modelStockLedger->sales_price = 0;
                    $modelStockLedger->stock_after_transaction = 0;
                    $modelStockLedger->stock_value_after_transaction= 0;
                    $modelStockLedger->transaction_date  = date('Y-m-d');
                    $modelStockLedger->transaction_cost_rate = $modelStore->rate;
                    $modelStockLedger->updated_cost_rate= 0;
                    $modelStockLedger->transaction_from = $transaction_from;
                    $modelStockLedger->transaction_type = $transaction_type;
                    $modelStockLedger->master_stock_ledger_id  = 0;
                    $modelStockLedger->stock_updated = 'Y';
                    $modelStockLedger->remarks= 'Auto issue voucher for stock adjustment - '.$stock_count_file_name;
                    $modelStockLedger->old_cost_price = 0;
                    $modelStockLedger->created_by = Yii::app()->user->id;
                    $modelStockLedger->created_date = date('Y-m-d h:i:s');
                    $modelStockLedger->save(false);
                    
                    //$modelStockPhysicalQuantity = new StockPhysicalQuantity();
                    
                    //$modelStockPhysicalQuantity->updateByPk($physical_stock_gi_id, array('updated_flag' => "Y"));
        }
        
        $modelStockPhysicalQuantity = new StockPhysicalQuantity();
                    
        
        $modelStockPhysicalQuantity->updateAll(array('updated_flag' => "Y"), 'transaction_id=' . (int) $transaction_id);
        
           
       $status['status'] = 'success';
       
       echo CJSON::encode($status);
        
    }

    public function actionUnblockStockLockFlag() {
        $id = (int) Yii::app()->user->master_user_company_id;
        if ($id > 0) {
            MasCompanySettings::model()->updateByPK($id, array('stock_lock_flag' => "Y"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionBlockStockLockFlag() {
        $id = (int) Yii::app()->user->master_user_company_id;
        if ($id > 0) {
            MasCompanySettings::model()->updateByPK($id, array('stock_lock_flag' => "N"));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionUploadStockCount() {
        $model=new StockPhysicalQuantity();
        $id = (int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('upload_stock_count', array('model' => $model, 'id' => $id), false, false);
    }

    public function actionDownloadStockCount(){
        $filename= 'STOCK_COUNT_LIST.csv'; 
        $path = Yii::getPathOfAlias('webroot')."/upload/stockcount/".$filename;
        if(!empty($path)){ 
                header("Content-type:application/force-download"); //for txt file
                header('Content-Disposition: attachment; filename="'.basename($path).'"'); 
                header('Content-Length: ' . filesize($path));
                readfile($path);
                Yii::app()->end();
        }
    } 



    public function actionDownloadStockCountCsv() {

       $condition = '1=1';
       $total = Yii::app()->db->createCommand('SELECT SUM(quantity*rate)  AS total_rate ,SUM(quantity)  AS total_quantity   FROM view_warehousewise_stock  WHERE ' . $condition)->queryAll();
       $query = 'SELECT * FROM (SELECT product_id,part_number,description,bar_code,brand_id,brand,SUM(quantity) AS quantity,isActive,inventory_item_type,rate,selling_price_1,unit_name, SUM(quantity*rate) AS amount
           FROM view_warehousewise_stock 
           WHERE ' . $condition . ' 
           GROUP BY product_id
           )A' . $qtycondition . ' ORDER BY part_number ASC ';
       $model = Yii::app()->db->createCommand($query)->queryAll();
       

        $file = fopen("uploads/csvs/test.csv", "w");
        $j = 0;
        $k =1;
        $list[$j++] = 'No!Part No!Description!Qty!Physical Qty!';
        foreach ($model as $i => $row) {

            $list[$j++] = $k. '!' . $row['part_number'] . '!'. $row['description']. '!' . $row['quantity']. '!' . '';
            $k++;
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"stockcount_" . date('dmY_His') . ".csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function readCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            if ($contents[1] == "")
                $contents = explode(';', $contents[0]);
            $line_of_text[] = $contents;
            //print_r($line_of_text);
            //die();
        }
        fclose($file_handle);
        return $line_of_text;
    }
    /*public function actionSaveStockCount()
    {
            $stockcount_file_name = $_POST['stockcount_filename'];
            $transaction_id   = (int) $_POST['transaction_id'];
            
            
            if($stockcount_file_name!=''){
            
                $cnt_transaction_exist = (int) StockPhysicalQuantity::model()->count(array('condition'=> 'transaction_id='.$transaction_id));
                
                if($cnt_transaction_exist==0){
            	$pricing_list = $this->readCSV("upload/stockcount/" . $stockcount_file_name);
            	$jsonData = array();
            	$arr_part_number=array();
            	$arr_price_updated_part_number=array();
            	foreach (array_slice($pricing_list, 1) as $i => $eachItem) {
            		$part_number = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
                    $description = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
                    $current_qty = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[3]), '"'));
                    $physical_quantity = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[4]), '"'));
                    $condition='part_number="'.$part_number.'"';
                    if (strlen($part_number) > 0) {
    
            	    $arr_model_history = StockPhysicalQuantity::model()->find(array('condition'=> $condition));
                    $product_model = Store::model()->find('LTRIM(RTRIM(part_number))="' . $part_number . '"');
    	    		$product_id = $product_model->id;
                   
                    if(!empty($arr_model_history)){
                        $model= new StockPhysicalQuantity();	
                        $model=	$model->findByPk($arr_model_history->id);
                        $model->description=$description;
                        $model->current_qty=$current_qty;
                        $model->physical_quantity=$physical_quantity;
                        $model->transaction_id=$transaction_id;
                        $model->save(false);
    
                    }
                    else
                    {
                        $model= new StockPhysicalQuantity();
                        $model->transaction_id=$transaction_id;
                        $model->product_id=$product_id;
                        $model->part_number=$part_number;
                        $model->description=$description;
                        $model->current_qty=$current_qty;
                        $model->physical_quantity=$physical_quantity;
                        $model->uploaded_by = Yii::app()->user->id;
                        $model->upload_date_time = date('Y-m-d h:i:s');
                       $model->save(false);
                    }
                }
            }
            
                
            	$modelStockCountFile = new StockCountFile();
            	$modelStockCountFile = $modelStockCountFile->updateByPk($transaction_id,array('lock_flag'=>'Y'));
            	
            	$jsonData['model'] = $model;
            	$jsonData['status'] = "success";
            	echo CJSON::encode($jsonData);
                }
                else{
                    $jsonData['status'] = "failed";
                    $jsonData['msg'] = "Physical Quantity already uploaded! Please remove transaction";
            	    echo CJSON::encode($jsonData);
                }
            }
             else{
                    $jsonData['status'] = "failed";
                    $jsonData['msg'] = "Please Upload a csv file";
            	    echo CJSON::encode($jsonData);
                }
    }*/
    
    public function actionSaveStockCount()
    {
            $stockcount_file_name = $_POST['stockcount_filename'];
            $transaction_id   = (int) $_POST['transaction_id'];
            
            
            if($stockcount_file_name!=''){
            
                $cnt_transaction_exist = (int) StockPhysicalQuantity::model()->count(array('condition'=> 'transaction_id='.$transaction_id));
                
                if($cnt_transaction_exist==0){
            	$pricing_list = $this->readCSV("upload/stockcount/" . $stockcount_file_name);
            	$jsonData = array();
            	$arr_part_number=array();
            	$arr_price_updated_part_number=array();
            	
            	foreach (array_slice($pricing_list, 1) as $i => $eachItem) {
            		$part_number = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
                    $description = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
                    $current_qty = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[3]), '"'));
                    $physical_quantity = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[4]), '"'));
                    $condition='part_number="'.$part_number.'"';
                    if (strlen($part_number) > 0) {
    
            	    $arr_model_history = StockPhysicalQuantity::model()->find(array('condition'=> $condition));
                    $product_model = Store::model()->find('LTRIM(RTRIM(part_number))="' . $part_number . '"');
    	    		$product_id = $product_model->id;
    	    		
    	    		$model[$i] = new StockPhysicalQuantity();
                    //$model= new StockPhysicalQuantity();
                    $model[$i]->transaction_id=$transaction_id;
                    $model[$i]->product_id=$product_id;
                    $model[$i]->part_number=$part_number;
                    $model[$i]->description=$description;
                    $model[$i]->current_qty=$current_qty;
                    $model[$i]->physical_quantity=$physical_quantity;
                    $model[$i]->uploaded_by = Yii::app()->user->id;
                    $model[$i]->upload_date_time = date('Y-m-d h:i:s');
                    
                    $arr_part_number[$i] = trim($part_number[0]); //For checking Duplicate part_number
                }
            }
            
                
            	$modelStockCountFile = new StockCountFile();
            	$modelStockCountFile = $modelStockCountFile->updateByPk($transaction_id,array('lock_flag'=>'Y'));
            	
            	$jsonData['model'] = $model;
            	$jsonData['status'] = "success";
            	echo CJSON::encode($jsonData);
                }
                else{
                    $jsonData['status'] = "failed";
                    $jsonData['msg'] = "Physical Quantity already uploaded! Please remove transaction";
            	    echo CJSON::encode($jsonData);
                }
            }
             else{
                    $jsonData['status'] = "failed";
                    $jsonData['msg'] = "Please Upload a csv file";
            	    echo CJSON::encode($jsonData);
                }
    }
    
    
    
     public function actionSaveSalaryComponents() {
        $file_name = Yii::app()->request->getParam('filename');
        $month = Yii::app()->request->getParam('month');
        $year = Yii::app()->request->getParam('year');
        $branch = Yii::app()->request->getParam('branch');
        $model_salary_already_locked = SalaryProcessing::model()->find(array('condition' => 'payroll_branch_or_sponsor_id="' . $branch . '" AND MONTH(payroll_enddate)="' . $month . '" AND YEAR(payroll_enddate)="' . $year . '"'));
        $model_salary_exist = HrMonthlySalaryComponent::model()->find(array('condition' => 'branch_id="' . $branch . '" AND salary_month="' . $month . '" AND salary_year="' . $year . '"'));
        if (empty($model_salary_already_locked) && empty($model_salary_exist)) {
            $jsonData['status'] = "success";
            $url = Yii::app()->basePath . '/../uploads/monthlysalary/' . $file_name;
            $error_url = Yii::app()->basePath . '/../uploads/monthlysalary/error/' . $file_name;
            $file = fopen($url, "r");
            $data = fgetcsv($file);
            $validate = TRUE;
            $error_list = array();
            $salary_list = $this->readEmployeeCSV("uploads/monthlysalary/" . $file_name);
            $salarytype_code_error = array();
            foreach (array_slice($salary_list, 1) as $i => $data) {
                if (!empty($data[0]) || !empty($data[1]) || !empty($data[2]) || !empty($data[3])) {
                    $model_salary[$i] = new HrMonthlySalaryComponent();
                    $model_salary[$i]->scenario = "excelupload";
                    if (!empty($data[0])) {
                        $employee_code = $this->ciphertext(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0]), '"')), "e");
                        // AND branch_or_sponsor_id="' . $branch . '"  condion removed branch checking by nisha on 25/09/2024
                        $model_employee = Employee::model()->find(array('condition' => 'employee_code="' . $employee_code . '"'));
                        if (!empty($model_employee) && $model_employee->id > 0) {
                            $model_salary[$i]->employee_id = $model_employee->id;
                        } else {
                            $model_salary[$i]->employee_id = '';
                        }
                    } else {
                        $model_salary[$i]->employee_id = '';
                    }
                    $model_salary[$i]->emp_code = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0]), '"'));
                    if (!empty($data[1])) {
                        $condition = '(salary_name="' . trim($data[1]) . '" AND salary_occurence="1" AND isActive ="Y")';
                        $model_salarytype[$i] = MasSalarytype::model()->find(array('select' => 'id', 'condition' => $condition));
                        if (isset($model_salarytype[$i])) {
                            $model_salary[$i]->salary_type = $model_salarytype[$i]->id;
                        }
                    } else {
                        $model_salary[$i]->salary_type = 0;
                    }
                    $salarytype_code_error[$i] = trim($data[0]) . '-' . strtoupper(str_replace(' ', '', trim($data[1]))); //For checking Duplicate Component-28/3/2023 by DR
                    $model_salary[$i]->salary_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[1]), '"'));
                    $model_salary[$i]->amount = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[2]), '"'));
                    $model_salary[$i]->remarks = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[3]), '"'));
                    $model_salary[$i]->branch_id = $branch;
                    $model_salary[$i]->salary_month = $month;
                    $model_salary[$i]->salary_year = $year;
                    $model_salary[$i]->created_by = Yii::app()->user->id;
                    $model_salary[$i]->created_date_time = date('Y-m-d H:i:s');
                    $validate = $model_salary[$i]->validate() && $validate;
                }
            }

            function array_not_unique($raw_array) {
                $dupes = array();
                natcasesort($raw_array);
                reset($raw_array);
                $old_key = NULL;
                $old_value = NULL;
                foreach ($raw_array as $key => $value) {
                    if ($value === NULL) {
                        continue;
                    }
                    if ($old_value != NULL) {
                        if (strcasecmp($old_value, $value) === 0) {
                            $dupes[$old_key] = $old_value;
                            $dupes[$key] = $value;
                        }
                    }
                    $old_value = $value;
                    $old_key = $key;
                }
                return $dupes;
            }

            //            echo '<pre>';print_r($salarytype_code_error); die();
            $check_duplicate_component = array_not_unique($salarytype_code_error);
            //            echo '<pre>';print_r($check_duplicate_component); die();
            if ($validate && empty($check_duplicate_component)) {
                if (!empty($model_salary)) {
                    foreach ($model_salary as $eachModel) {
                        $eachModel->save();
                    }
                    $jsonData['error'] = "";
                }
            } else {
                if (!empty($model_salary)) {
                    foreach ($model_salary as $s => $data_model) {
                        $error_list[$s]['emp_code'] = $data_model['emp_code'];
                        $error_list[$s]['salary_name'] = $data_model['salary_name'];
                        $error_list[$s]['amount'] = $data_model['amount'];
                        $error_list[$s]['salarycomponentduplicate'] = trim($data_model['emp_code']) . '-' . strtoupper(str_replace(' ', '', trim($data_model['salary_name'])));
                        if ($data_model->validate()) {
                            $error_list[$s]['remarks'] = "correct";
                        } else {
                            $error_list[$s]['remarks'] = $data_model->getErrors();
                        }
                    }
                }
            }
            $j = 0;
            fclose($file);
            $list = array();
            if (!empty($error_list)) {
                $file_error = fopen($error_url, "w+");
                $list[$j++] = 'Employee Code *,Salary Type *,Amount*,Remarks';
                foreach ($error_list as $i => $error_detail) {
                    if (!empty($error_detail)) {
                        if (!empty($error_detail['remarks'])) {
                            $error_view[$i] = '';
                            foreach ($error_detail['remarks'] as $p => $error_value) {
                                $error_view[$i] .= $error_value[0] . " / ";
                            }
                        } else {
                            $error_view[$i] .= '';
                        }
                        if (in_array($error_detail['salarycomponentduplicate'], $check_duplicate_component)) {
                            $error_view[$i] .= " Duplicate Salary Component Exist /";
                        } else {
                            $error_view[$i] .= '';
                        }
                        $list[$j++] = $error_detail['emp_code'] . ',' . $error_detail['salary_name'] . ',' . $error_detail['amount'] . ',' . $error_view[$i];
                    }
                }
                foreach ($list as $line) {
                    fputcsv($file_error, explode(',', $line));
                }
                fclose($file_error);
            }
            $jsonData['error_url'] = $error_url;
            $jsonData['filename'] = $file_name;
            $jsonData['link'] = CHtml::link('Download log', array('salary/DownloadErrorCsv', 'id' => $file_name), array('target' => '_blank', 'style' => 'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;' . ''));
        } else {
            $jsonData['status'] = "error";
            if (!empty($model_salary_already_locked)) {
                $jsonData['error'] = 'Salary Calculated already for this month';
            } else if (!empty($model_salary_exist)) {
                $jsonData['error'] = 'Salary Component Details already uploaded.Please delete and try again';
            }
        }
        echo CJSON::encode($jsonData);
    }


    public function actionUpload($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
		// make the directory to store the pic:
            if (!is_dir($folder)) {
                mkdir($folder, 0777, TRUE);
				//chmod($folder, 0755);
            }
        $allowedExtensions = array();
        $sizeLimit = 2 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $this->CropIfImage($folder, $fileName, 100, 100);
        echo $return; // it's array
    }
    
    public function actionDeletePhysicalStock(){
        $transaction_id = (int) $_POST['id'];
        if ($transaction_id > 0) {
            
            // Execute the delete
            StockPhysicalQuantity::model()->deleteAll(array('condition'=>'transaction_id='.$transaction_id));
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
	
	public function actionViewStockDifference()
	{
		$this->render('view_stock_difference');
	}
}