<?php

class StockCountFileController extends Controller
{
	
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetStockCountFileList','Create','SaveStockCountFile','BlockStockCountFile','UnBlockStockCountFile'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }
	

    public function actionGetStockCountFileList() {
       
        $model=new StockCountFile();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
            0 =>'id',
            1 =>'lock_transaction_date',
            2 =>'file_name',
            3 =>'id',
           );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = '1=1';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition.=" and (lock_transaction_date LIKE '%".$searchString."%' OR file_name LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $lock_transaction_date=date("d/m/Y", strtotime($row->lock_transaction_date));
            $lock_transaction_date=date("d/m/Y", strtotime($row->lock_transaction_date));
            $div = '';
               // if(isset(Yii::app()->user->havePermissionOn['bank_edit']) ||  Yii::app()->user->authorised_user == 1)
                //{
                    $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'stockcount/StockCountFile/create&id=' . $row['id'] . '\',\'Edit Stock Transaction\',\'lg\')"><i class="fa fa-pencil"></i></button>';             

                //}
                
                if($row->lock_flag=='N'){
                    $div .= ' <a  title="upload Stock" class="btn btn-primary btn-xs" onclick="loadPopupModal(\'stockcount/stockcount/UploadStockCount&id=' . $row['id'] . '\',\'Upload Stock\',\'lg\')"><i class="fa fa-upload"></i></a>';             
                }
           

               // if(isset(Yii::app()->user->havePermissionOn['bank_disable']) ||  Yii::app()->user->authorised_user == 1)
               // {

                 /* if ($row->isActive == "Y") 
                  {
                    $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disableStockCountFile(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                  }
                  if ($row->isActive == 'N') 
                  {
                        $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enableStockCountFile(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                  }            
                
                //}
            $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="DeletePhysicalStock(' . $row['id'] . ')"><i class="fa fa-trash"></i></a>';*/
            $rowData[]=array($m,
                $lock_transaction_date,
                $row['file_name'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
                $row['isActive'],
            );

            $m++;
        }
        $data['draw'] = $draw;
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $model=new StockCountFile(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        } 
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSaveStockCountFile()
    {
        $model = new StockCountFile();
        if (isset($_POST['StockCountFile']))
        {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime =date('Y-m-d h:i:s');

            if ((int) @$_POST['StockCountFile']['id'] > 0)
            {
                $id= (int) @$_POST['StockCountFile']['id'];
                $model=$model->findByPk($id); 
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime =date('Y-m-d h:i:s');
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
            }
            $model->attributes=$_POST['StockCountFile'];
            if ($_POST['StockCountFile']['lock_transaction_date'] != '' && $_POST['StockCountFile']['lock_transaction_date'] != '0000-00-00') {
                $model->lock_transaction_date = str_replace('/', '-', $_POST['StockCountFile']['lock_transaction_date']);
                $model->lock_transaction_date = date("Y-m-d h:i", strtotime($model->lock_transaction_date));
           }
            if($model->save())
            {       
                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'Stockcountfile',
                        Yii::app()->user->id,
                        $audit_type,
                        " with name: - {$model->file_name}  "
                    );
                    // end audit log 
                    $jsonData['status'] = 'success';
                    $jsonData['frm'] = $_POST['create'];
                    $jsonData['id'] = $model->id;
                    echo CJSON::encode($jsonData);
            }
            else
            {
                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                           echo $error;
            }
          
        }
    }

    public function actionBlockStockCountFile() {
        $id = $_POST['id'];
        if ($id > 0) {
            StockCountFile::model()->updateByPK($id, array('isActive' => "N"));
             // inserting to audit log
             $model=new StockCountFile();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'StockCountFile',
                 Yii::app()->user->id,
                 'BLOCKED',
                 " with name: - {$upt->file_name}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    
    public function actionUnBlockStockCountFile() {
        $id = $_POST['id'];
        if ($id > 0) {
            StockCountFile::model()->updateByPK($id, array('isActive' => "Y"));
             // inserting to audit log
             $model=new StockCountFile();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'StockCountFile',
                 Yii::app()->user->id,
                 'UNBLOCKED',
                 " with name: - {$upt->file_name}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
}