<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>
<?php
$model_settings = new MasCompanySettings();
$crm_login_company_id = Yii::app()->user->master_user_company_id;
$model_settings = $model_settings->find(array('condition' => 'crm_company_id=' . $crm_login_company_id));
$allow_change = $model_settings->allow_change_description;
$bonus_quantity = $model_settings->bonus_quantity;
echo CHtml::hiddenField('allow_change', $allow_change);
echo CHtml::hiddenField('bonus_quantity', $bonus_quantity);
echo $form->error($model_master, 'current_process_status');
if ($model->id == '') {
    $status = true;
}
?>
<table class="table table-hover table-bordered personal-task" id="quotes_item_table">
    <tr>
        <th><?php echo CHtml::checkBox("ckbCheckAll", $status, array('onchange' => 'checkall($("#quotes_item_table"));')); ?></th>
        <th>No</th>
        <th>Product</th>
        <th>Description</th>
        <th>Quantity</th>
        <?php if ($sales_group_id == 2) { ?>
            <th>Bill Type</th>
        <?php
        } else {
            ?>
            <th>Unit</th>
        <?php } ?>
        <th>Unit Price</th>
        <th>Amount</th>
        <th>Tax(%)</th>
        <th class="bg-success text-center">+/-</th>
        <th class="bg-danger text-center">Discount</th>
        <th>Net</th>
        <th class="text-center">
            <a class="btn btn-xs btn-theme " href="javascript:void(0);" onclick="addTableRow($('#quotes_item_table'));"><i class="fa fa-plus"></i></a></th>
    </tr>

    <?php foreach ($modelQuoteItems as $i => $modelQuoteItems): ?>
        <tr class="<?php echo $i; ?>">
            <?php
            $product_inventory_type = "";
            if ($modelQuoteItems->id > 0) {
                if ($modelQuoteItems->product_id == 999999) {
                    $value = 'memo';
                    $disabled = true;
                } else {
                    $value = $modelQuoteItems->product->part_number;
                    $disabled = false;
                }
                $product_inventory_type = $modelQuoteItems->product->inventory_item_type;
            } else {
                $value = $modelQuoteItems->product->part_number;
            }
            if ($modelQuoteItems->checked == 1) {
                $status = true;
            } else {
                $status = false;
            }
            if ($model->id == '' && $duplicate != 1) {
                $status = true;
                $va = '1.00';
            }if ($duplicate == "1")
                $modelQuoteItems->id = '';
            ?>
            <td><?php echo $form->checkBox($modelQuoteItems, "[" . $i . "]checked", array('class' => "checkBoxClass", 'checked' => $status, 'onclick' => 'checkquotesitem(this.id);')); ?></td>
            <td><label><?php echo ($i + 1); ?></label></td>
            <td>
                <?php echo $form->textField($modelQuoteItems, "[" . $i . "]product_name", array('class' => 'tooltipster go', 'value' => $value, 'placeholder' => 'Type & Select', 'onKeyup' => 'js:autoCompleteProduct(this.id,"quotation");', 'title' => 'Select product')); ?>
                <?php echo $form->hiddenField($modelQuoteItems, "[" . $i . "]product_id"); ?>
                <?php echo $form->hiddenField($modelQuoteItems, "[" . $i . "]id"); ?>
                <?php echo $form->error($modelQuoteItems, "[" . $i . "]product_id"); ?>
                <?php //echo CHtml::link('<i class="fa fa-info-circle"><div class="triangle-right"></div></i>', 'javascript:;', array('class' => 'quotation-helper-trigger', 'title' => 'Quotation Helper','id'=>"quotation_".$i,'onclick' => 'showquotation(this,this.id)'));  ?>
                <?php //echo CHtml::link('<i class="fa fa-shopping-cart "><div class="triangle-right"></div></i>', 'javascript:;', array('class' => 'stock-helper-trigger', 'title' => 'Stock Helper','id'=>"stockhlp_".$i,'onclick' => 'showstockdetails(this,this.id)'));  ?>
                <?php echo CHtml::hiddenField('product[' . $i . '][inventorytype]', $product_inventory_type); ?>
            </td>
            <td>
                <?php
                if ($allow_change == "N") {
                    echo $form->textArea($modelQuoteItems, "[" . $i . "]description", array('class' => 'tooltipster desc desc2 go en-text-area', 'title' => 'Add Description here'));
                } else {
                    echo $form->textArea($modelQuoteItems, "[" . $i . "]description", array('class' => 'tooltipster desc desc2 go en-text-area', 'title' => 'Add Description here'));
                }
                ?>
                <?php echo $form->error($modelQuoteItems, "[" . $i . "]description"); ?>
            </td>
            <td>
                <?php echo $form->textField($modelQuoteItems, "[" . $i . "]quantity", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'return isPositiveInteger(event)', 'onkeydown' => 'nextline(event)', 'onkeyup' => 'calculatequoteValue($("#quotes_item_table"));', 'readonly' => $disabled)); ?>
                <?php echo $form->error($modelQuoteItems, "[" . $i . "]quantity"); ?> 
            </td>
            
            <td id="unit_<?php echo $i; ?>">
                <?php
                ($modelQuoteItems->product_id > 0) ? $data = UnitOfMeasurement::getUnits($modelQuoteItems->product_id) : $data = array();
                ?>
                <?php
                if ($sales_group_id == 2) {
                    echo $form->hiddenField($modelQuoteItems, "[" . $i . "]unit_id");
                    echo $form->dropdownlist($modelQuoteItems, "[" . $i . "]bill_type", array('1' => 'Daily', '2' => 'Monthly', '3' => 'Yearly'), array('class' => 'qty go'));
                } else {
                    echo $form->dropdownlist($modelQuoteItems, "[" . $i . "]unit_id", $data, array('class' => 'qty go'));
                }
                ?>

            </td>

            <td>
                <?php echo $form->textField($modelQuoteItems, "[" . $i . "]rate", array('class' => 'rate go text-right to_be_calculated', 'onkeypress' => 'return isPositiveNumber(event)', 'onkeydown' => 'nextline(event)', 'onkeyup' => 'calculatequoteValue($("#quotes_item_table"));', 'readonly' => $disabled)); ?>
                <?php echo $form->error($modelQuoteItems, "[" . $i . "]rate"); ?>
            </td>
            <td>
                <?php echo $form->textField($modelQuoteItems, "[" . $i . "]amount", array('class' => 'amt go text-right', 'onkeypress' => 'return isNumberKey(event)', 'readonly' => true, 'disabled' => $disabled)); ?>
                <?php echo $form->error($modelQuoteItems, "[" . $i . "]amount"); ?>
            </td>
            <td>
                <?php
                if ($modelQuoteItems->product_id > 0) {
                    $modelQuoteItems->tax_vat_percentage = $modelQuoteItems->product->tax->percentage;
                    $modelQuoteItems->tax_vat_amount = ($modelQuoteItems->net_amount * $modelQuoteItems->product->tax->percentage) / 100;
                    $model->total_tax_amount += $modelQuoteItems->tax_vat_amount;
                }
                ?>
                <?php echo $form->textField($modelQuoteItems, "[" . $i . "]tax_vat_percentage", array('class' => 'rate go text-right to_be_calculated', 'readonly' => true)); ?>                    
                <?php echo $form->hiddenField($modelQuoteItems, "[" . $i . "]tax_vat_amount"); ?>
                <?php echo $form->error($modelQuoteItems, "[" . $i . "]tax_vat_percentage"); ?>  
                <input type="hidden" id="check_tax_vat_percentage_<?php echo $i; ?>" value="<?php echo $modelQuoteItems->product->tax->percentage; ?>" />

            </td>
            <td class="bg-success nw">

                <?php echo $form->textField($modelQuoteItems, "[" . $i . "]addition_percentage", array('class' => 'txt-6 go exception text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculatequoteValue($("#quotes_item_table"),this.id);', 'disabled' => $disabled)); ?>
                <?php echo $form->error($modelQuoteItems, "[" . $i . "]addition_percentage"); ?>
                <?php echo $form->textField($modelQuoteItems, "[" . $i . "]addition_amount", array('class' => 'txt-6 go exception text-right additions', 'readonly' => true, 'disabled' => $disabled)); ?>
                <?php echo $form->error($modelQuoteItems, "[" . $i . "]addition_amount"); ?>

            </td>
            <td class="bg-danger nw">

                <?php echo $form->textField($modelQuoteItems, "[" . $i . "]deduction_percentage", array('class' => 'txt-6 go exception text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculatequoteValue($("#quotes_item_table"),this.id);', 'disabled' => $disabled)); ?>
                <?php echo $form->error($modelQuoteItems, "[" . $i . "]deduction_percentage"); ?>
                <?php echo $form->textField($modelQuoteItems, "[" . $i . "]deduction_amount", array('class' => 'txt-6 go exception text-right deductions', 'readonly' => true, 'disabled' => $disabled)); ?>
                <?php echo $form->error($modelQuoteItems, "[" . $i . "]deduction_amount"); ?>

            </td>
            <td>
                <?php echo $form->textField($modelQuoteItems, "[" . $i . "]net_amount", array('class' => 'amt go text-right', 'readonly' => true, 'disabled' => $disabled)); ?>
                <?php echo $form->error($modelQuoteItems, "[" . $i . "]net_amount"); ?>
                <?php
                if ($modelQuoteItems->checked == 1) {
                    $total += $modelQuoteItems->net_amount;
                    $total_vat += $modelQuoteItems->tax_vat_amount;
                }
                ?>
            </td>
            <td class="text-center nw" width="1%">
                <?php //echo CHtml::link('<i class="fa fa-paper-plane-o"></i>', 'javascript:void(0);', array('class' => 'left', 'title' => 'Insert A Row')); ?>
                <?php //echo CHtml::link('<i class="fa fa-paper-plane-o"></i>', 'javascript:void(0);', array('class' => 'left btn btn-primary btn-xs', 'title' => 'Insert A Row')); ?>
                <?php echo CHtml::link('<i class="fa fa-arrow-up"></i>', 'javascript:void(0);', array('class' => 'btn btn-xs btn-theme up', 'title' => 'Move to Up')); ?>
                <?php echo CHtml::link('<i class="fa fa-arrow-down"></i>', 'javascript:void(0);', array('class' => 'btn btn-xs btn-theme down', 'title' => 'Move to Down')); ?>
                <?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-xs btn-danger', 'onclick' => 'removeTableRow($(\'#quotes_item_table\'),this)', 'title' => 'Remove this item')); ?>
            </td>
        </tr>
    <?php endforeach; ?>
</table>
