<?php 
$cs = Yii::app()->getClientScript();
$color = array();$colorname=array();
$modelcolor = MasColourScheme::model()->findAll();
foreach ($modelcolor as $evalue) {
    $color[$evalue->id] = $evalue->colour;
    $colorname[$evalue->id] = $evalue->field;
}
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("check_convert", "function check_convert(id){
    if(id == 'L')
    {

    }else{
        alert('You have no privilege to convert this lead again..');
        $('.quotation-save-btn').hide();
    }

 }", CClientScript::POS_HEAD);
 $cs->registerScript("sendLeadMail", "function sendLeadMail(){
    jQuery.ajax({
        'type': 'post',
        'dataType': 'json',
        'url': '" . Yii::app()->createUrl('service/lead/SendLeadConversionMail') . "',
        'cache': false,
        'success': function(data) {             
            t8.success('Mail Send Successfully');                
        }
    });
 }", CClientScript::POS_HEAD);
  ?>
<script type="text/javascript">
$(document).ready(function() {
    var table_id ="#tbl_lead_details";
    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
        data.lead_status = $("#lead_status").val();
        data.frm = $("#frm").val();
        return data;
    }).DataTable({
        scrollY         : "645px",
        pageLength      : 100,
        columns: [
            {className: ""},
            {className: ""},
            {className: ""},               
            {className: "" },
            {className: "" },
            {className: "" },
            {className: ""},
            {className: ""},
            {className: ""},
            {className: ""},            
            {className: ""},           
            {className: ""},
            
        ],    
        ajax: {
            url: "<?php echo Yii::app()->createUrl('service/lead/GetSalesLeadList');?>",
            type: "POST",
            data: {"frm":<?php  echo $frm;?>},
            cache : false,
        },

        serverSide:     true,
        "order": [[ 1, "desc" ]],
        "aoColumnDefs": [
            { "bSortable": false, "aTargets": [ 7,8 ] },
            {
                "targets": [9,10],
               "visible": false, 
            },
        ], 
        fixedColumns:   true,
        processing: true,
          
          "fnCreatedRow"  : function( nRow, aData, iDataIndex ){
       		$(nRow).addClass("context-menu");
            },
            "fnRowCallback" : function( nRow, aData, iDisplayIndex, iDisplayIndexFull){
                    if ( aData[8] == "High" )  {  
                        $("td", nRow).css("background-color", "<?php echo $color[7];?>"); //high
                           // $("td", nRow).addClass("bg-payment");

                    }
                    else if ( aData[8] == "Medium" ){
                       $("td", nRow).css("background-color", "<?php echo $color[6];?>"); //Medium
                        //$("td", nRow).addClass("bg-success");
                    }  else{
                        $("td", nRow).css("background-color", "<?php echo $color[5];?>"); //low                       
                    }
       	$("#tbl_lead_details tbody").mousedown(function (e) {   
           $(this).contextMenu({
               selector: ".context-menu",
              callback: function(key, options) {
           	var action_id = key;
					var data = table.row( this ).data();
					var file_id=data[0];
					var id=data[1];
					var customer_name=data[2];
					var customer_id = data[9];
					var current_process_status = data[10];
					var lead_status = data[8];
					if(action_id == "edit"){
						if(current_process_status=="L"){
							loadPopupModal("service/lead/create&id="+id+"&file_id="+file_id,id+"/"+file_id ,"lg");
						}
						else{
							loadPopupModal("service/lead/create&view=1&id="+id,id+"/"+file_id,"lg");
						}
					}
					else if(action_id == "convert" && current_process_status=="L"){
						loadPopupModal("service/quotation/create&lead_id="+id+"&file_id="+file_id,"Convert To Quotation" ,"xl");
					}
					else if(action_id == "activity"){
						loadPopupModal("activity/create&frm=L&type=1&file_id="+file_id+"&customer_id="+customer_id,"Activities" ,"xl");
					}
					else if(action_id == "print"){
						window.open($('#liveSite').val()+"/index.php?r=service/lead/PrintLeadReportPDF&id=&id="+id,"_blank");
					}

					
       },
               items: {
              	 <?php if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["lead_edit"])){ ?>
                   		"edit": {name: "Edit", icon: "edit"},
                   <?php } ?>
                   <?php if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["lead_convert"]))/*  && $row->file->current_process_status=="L" */){?> 
                   		"convert": {name: "Convert", icon: "fa-retweet"},
                   	<?php } ?>
                   <?php  if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_activity"])){ ?>
                   		"activity": {name: "Activity", icon: "fa-certificate"},
                   <?php } ?>
                   <?php if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["lead_pdf"])){ ?>
            			"print": {name: "Print", icon: "fa-print"},
            <?php } ?>
               }
           }
           );
       });     
   }
    } );

    $(".dataTables_scrollFoot").hide();

});

</script>
    <section class="panel">
        <input type="hidden" name="frm" id="frm" value="<?php echo $frm;?>">        
        <header class="panel-heading clearfix panel-theame-new">

            <i class="fa fa-area-chart"></i> Lead

            <div class="pull-right">
              <div class="col-md-12">
                  <div class="col-md-7" width="100%">
            <?php  echo CHtml::dropdownList('lead_status','',array( 'H' => 'Hot',  "C" => 'Cold','W'=>'Warm'),array('class'=>'form-control', 'prompt'=>'--Lead Status--','onChange' => 'reloadTable("#tbl_lead_details")'));  ?> 
                  </div>


                <?php if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["lead_add"])){ ?>

                  <div class="col-md-2">
                    <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('service/lead/create&frm=<?php echo $frm;?>','Add New Lead','lg')"><i class="fa fa-plus"></i> ADD</button>
                  </div>
                    <?php } ?>
                   
            </div>
          </div>

        </header>

        <div class="panel-body">

            <div class="custom-data-table">

                <table class="table table-hover table-bordered personal-task" id="tbl_lead_details">

                    <thead>
                        <tr>
                            <th>File</th>
                            <th>Lead #</th>                       
                            <th>Customer</th>
                            <th>Lead Owner</th>
                            <th>Enquiry Date</th> 
                            <th>Closing Date</th>
                            <th>Status</th>
                            <th>File Status</th>
                            <th>Lead Status</th>
                            <th></th>                               
                            <th></th>
                            <th>Created By</th>

                        </tr>
                    </thead>

                </table>

            </div>
            <div class="color-indicator">
                <span style="display: inline-block;width:30px;height:30px;background:<?php echo $color[5];?>; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> <?php echo $colorname[5];?></span>
                <span style="display: inline-block;width:30px;height:30px;background:<?php echo $color[6];?>; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> <?php echo $colorname[6];?></span>
                <span style="display: inline-block;width:30px;height:30px;background:<?php echo $color[7];?>; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> <?php echo $colorname[7];?></span>
            </div>
        </div>

    </section>