<?php

/**
 * This is the model class for table "{{order_proforma_invoice}}".
 *
 * The followings are the available columns in table '{{order_proforma_invoice}}':
 * @property integer $id
 * @property integer $order_id
 * @property integer $quantity
 * @property integer $type
 * @property string $amount
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ServiceOrderProformaInvoice extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{order_proforma_invoice}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('order_id, quantity, type, amount', 'required'),
			array('order_id, quantity, type, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('amount', 'length', 'max'=>15),
			array('performa_number', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, order_id,performa_number, quantity, type, amount, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'order_id' => 'Order',
			'quantity' => 'Quantity',
			'type' => 'Type',
			'amount' => 'Amount',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('order_id',$this->order_id);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('type',$this->type);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return OrderProformaInvoice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getbilltype($id){
            $model_items = OrderItem::model()->findAll(array('select'=>'bill_type','condition' =>'order_id="' . $id . '"'));            //echo '<pre>';     print_r($model_items);
            $billtype_details=array();
            if(!empty($model_items)){
                $m = 0;              
                foreach ($model_items as $i=>$each){
                    if($each->bill_type>0){
                        $array_type=array(1=>'Daily',2=>'Weekly',3=>'Monthly');
                        $billtype_details[$m]['value'] =$each->bill_type;
                        $billtype_details[$m]['type'] = $array_type[$each->bill_type];
                        $m++;
                    }
                }
            }	
            return CHtml::listData($billtype_details, 'value', 'type');
        }
}
