<?php

/**
 * This is the model class for table "{{order}}".
 *
 * The followings are the available columns in table '{{order}}':
 * @property integer $id
 * @property integer $crm_user_id
 * @property integer $file_id
 * @property string $customer_id
 * @property integer $contact_id
 * @property string $order_date
 * @property string $delivery_date
 * @property string $sales_group
 * @property string $reference
 * @property string $currency
 * @property double $exchange_rate
 * @property string $payment_terms
 * @property string $shipping_by
 * @property string $lpo
 * @property string $others
 * @property double $net_amount
 * @property double $final_addition_percentage
 * @property double $final_addition_amount
 * @property double $final_deduction_percentage
 * @property double $final_deduction_amount
 * @property double $net_total
 * @property double $grand_total
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property DeliveryNotes[] $deliveryNotes
 * @property User $crmUser
 * @property MasterFile $file
 * @property Company $company
 * @property OrderItem[] $orderItems
 */
class ServiceOrder extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $customer_name;
    public $lead_owner_id;
    public $lead_owner_name;
    public $shipping_conditions;
    public $title;
    public $no_of_orders;
    public $searchstartdate;
    public $searchenddate;
    public $total_value;
    public $month;
    public $value;
    public $country;
    public $status;    
    public $salesgroup_name;

    // public $netQuantity;

    public function tableName() {
        return '{{order}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('crm_user_id, customer_id, contact_id, order_date, delivery_date, sales_group,
                billing_address, exchange_rate, payment_terms,lead_owner_id,lpo,invoice_type,terms_and_conditions,lpo_date', 'required'),
            array('crm_user_id, file_id, contact_id, lead_owner_id,contract_no', 'numerical', 'integerOnly' => true),
            array('exchange_rate, net_amount, final_addition_amount, final_deduction_amount, net_total, grand_total', 'numerical'),
            array('customer_id,tender_file_id', 'length', 'max' => 20),
            array('sales_group, reference, currency, payment_terms, shipping_by, lpo,lpo_date, others, shipping_conditions,file_title,project_location', 'length', 'max' => 255),
            array('isActive,materials_allocated,tax_type', 'length', 'max' => 1),
            array('notes,remarks', 'length', 'max' => 5000),
//            array(
//                'delivery_date',
//                'compare',
//                'compareAttribute' => 'order_date',
//                'operator' => '<',
//                'allowEmpty' => false,
//                'message' => '{attribute} must be greater than {compareAttribute}.'
//            ),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, crm_user_id, file_id, customer_id, contact_id, order_date, delivery_date, sales_group, reference, 
                currency, exchange_rate, payment_terms, shipping_by, lpo, others, net_amount, final_addition_percentage, 
                final_addition_amount, final_deduction_percentage, final_deduction_amount, net_total, grand_total, isActive,invoice_type', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'customercontact' => array(self::BELONGS_TO, 'CustomerContact', 'contact_id'),
            'deliveryNotes' => array(self::HAS_MANY, 'DeliveryNote', 'order_id'),
            'crmUser' => array(self::BELONGS_TO, 'User', 'crm_user_id'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'items' => array(self::HAS_MANY, 'ServiceOrderItem', 'order_id', 'order' => 'items.id asc'),
            'items1' => array(self::HAS_MANY, 'ServiceOrderItem', 'order_id', 'order' => 'items1.id asc'),  //Used in deallocation, please remove if not needed
            'adItems' => array(self::HAS_MANY, 'ServiceOrderAddition', 'order_id', 'order' => 'adItems.id asc'),
            'dedItems' => array(self::HAS_MANY, 'ServiceOrderDeduction', 'order_id', 'order' => 'dedItems.id asc'),
            'netAmount' => array(self::STAT, 'ServiceOrderItem', 'order_id', 'select' => 'SUM(net_amount)'),
            'netQuantity' => array(self::STAT, 'ServiceOrderItem', 'order_id', 'select' => 'SUM(quantity)'),
            'netbonusQuantity' => array(self::STAT, 'ServiceOrderItem', 'order_id', 'select' => 'SUM(bonus_qty)'),
            //'deliveredQuantity'=>array(self::STAT, 'ServiceOrderItem', 'order_id', 'select' => 'SUM(quantity)'),
            'adTotal' => array(self::STAT, 'ServiceOrderAddition', 'order_id', 'select' => 'SUM(calculated_value)'),
            'dedTotal' => array(self::STAT, 'ServiceOrderDeduction', 'order_id', 'select' => 'SUM(calculated_value)'),
            'paymentTerm' => array(self::BELONGS_TO, 'MasPaymentTerm', 'payment_terms'),
            'currencyname' => array(self::BELONGS_TO, 'MasCurrency', 'currency'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'salesgroup' => array(self::BELONGS_TO, 'MasSalesGroup', 'sales_group'),
            'leadowner' => array(self::BELONGS_TO, 'User', 'lead_owner_id'),
            'employeedetail' => array(self::BELONGS_TO, 'Employee', 'site_supervisor_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'title' => 'File Title',
            'crm_user_id' => 'Crm User',
            'file_id' => 'File',
            'company_name' => 'Company',
            'customer_id' => 'Company ID',
            'contact_id' => 'Contact',
            'order_date' => 'Order Date',
            'delivery_date' => 'Delivery Date',
            'sales_group' => 'Sales Group',
            'reference' => 'Reference',
            'currency' => 'Currency',
            'exchange_rate' => 'Exchange Rate',
            'payment_terms' => 'Payment Terms',
            'shipping_by' => 'Shipping By',
            'lpo' => ' LPO Reference',
            'others' => 'Others',
            'net_amount' => 'Net Amount',
            'final_addition_percentage' => 'Final Addition Percentage',
            'final_addition_amount' => 'Final Addition Amount',
            'final_deduction_percentage' => 'Final Deduction Percentage',
            'final_deduction_amount' => 'Final Deduction Amount',
            'net_total' => 'Net Total',
            'grand_total' => 'Grand Total',
            'isActive' => 'Is Active',
            'lead_owner_id' => 'Lead Owner',
            'tax_type' => 'Tax Type'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search($searchterm = null) {
     // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('order_search')) : $searchterm;
        $criteria->with = array('file', 'file.company', 'file.leadowner');
       /* $criteria->addCondition('       file.own_customer_id=' . Yii::app()->user->master_user_customer_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        $userModel = User::model()->findByPK(Yii::app()->user->id);
        //$criteria->addCondition('file.lead_owner_id in (' . implode(',', $userModel->subordinates).')', 'AND');
        
        $user = User::model()->findByPK(Yii::app()->user->id);
        if(!isset(Yii::app()->user->havePermissionOn['sop_order_viewall']) &&  Yii::app()->user->authorised_user != 1)
        {
        	$criteria->addCondition('file.crm_user_id=' . Yii::app()->user->id.' OR file.lead_owner_id='. Yii::app()->user->id, 'AND');
        }
        /* if((int) Yii::app()->user->havePermissionOn['sop_order_viewall']==1 || Yii::app()->user->authorised_user == 1)
        {
            
        }
        else {
        $criteria->addCondition('t.crm_user_id=' . Yii::app()->user->id.' OR file.lead_owner_id='. Yii::app()->user->id, 'AND');
        } */
        
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
                                        t.file_id like "%' . $searchterm . '%" OR 
                                        company.company_name like "%' . $searchterm . '%" OR 
                                        file.file_title like "%' . $searchterm . '%" OR
                                        leadowner.first_name like "%' . $searchterm . '%" OR
                                        leadowner.last_name like "%' . $searchterm . '%"
                                            ', 'AND');
        }
        if (isset($_GET['month']) && is_array($_GET['month']))            $_GET['month'] = $_GET['month'][0];
        if (isset($_GET['month']))
            $criteria->addCondition("YEAR(order_date)='" . date('Y') . "' AND MONTH(order_date) ='" . $_GET['month'] . "'", 'AND');

        if (isset($_GET['sales_man'])) {
            $sales_man = (int) ($_GET['sales_man']);
            $criteria->addCondition("file.lead_owner_id=" . $sales_man, 'AND');
        }
        if (isset($_GET['sales_group'])) {
            $sales_group_id = (int) ($_GET['sales_group']);
            $criteria->addCondition("sales_group=" . $sales_group_id, 'AND');
        }
        if (isset($_REQUEST['customer_id'])) {
           $customer_id = (int) ($_REQUEST['customer_id']);
            $criteria->addCondition("file.customer_id=" . $customer_id, 'AND');
        }
         
        if ((isset($_GET['sales_man']) || isset($_GET['sales_group']) || isset($_GET['customer_id'])) && !isset($_GET['month'])) {
            $criteria->addCondition("YEAR(order_date)='" . date('Y') . "'", 'AND');
            $criteria->group = 'MONTH(order_date)';
            $criteria->select = 'MONTH(`order_date`) as id,MONTHNAME(`order_date`) as month,SUM(grand_total*exchange_rate) as total_value';
        }

        if (empty($searchterm) && !isset($_GET['month']) && !isset($_GET['sales_group']) && !isset($_GET['sales_man']) && !isset($_GET['customer_id'])) {
            ((int) Yii::app()->session['customer_id'] > 0) ? $criteria->addCondition('t.customer_id=' . Yii::app()->session['customer_id'], 'AND') : '';
            $criteria->addCondition('file.current_process_status="O" OR file.current_process_status="PD"  OR file.current_process_status="PI"', 'AND');
        }

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC,t.file_id DESC,t.customer_id,t.order_date DESC',
            ),
            //  'pagination' => false
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
                // 'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) :!empty($searchterm)?array('pageSize' => 20):false,
        ));
    }

    public function report() {
        $criteria = new CDbCriteria;
        $criteria->with = array('file', 'file.company', 'netQuantity', 'file.deliveredQuantity');
        $criteria->together = true;
        if (!empty($this->customer_id))
            $condition[] = 't.customer_id="' . $this->customer_id . '"';
        if (!empty($this->sales_group))
            $condition[] = 'sales_group="' . $this->sales_group . '"';
        if (!empty($this->lead_owner_id))
            $condition[] = 'lead_owner_id="' . $this->lead_owner_id . '"';
        if (!empty($this->country))
            $condition[] = 'company.billing_country="' . $this->country . '"';
        if (!empty($this->value))
            $condition[] = 'grand_total<="' . $this->value . '"';
        if (!empty($this->status)) {
            switch ($this->status) {
                case 'P':
                    $condition[] = 'file.current_process_status="O"';
                    break;
                case 'D':
                    $condition[] = 'file.current_process_status<>"O" AND t.netQuantity=file.deliveredQuantity';
                    break;
            }
        }
        if (is_array($condition))
            $criteria->condition = implode(' AND ', $condition);
        if (!empty($this->searchstartdate) && !empty($this->searchenddate)) {
            $criteria->addBetweenCondition('order_date', $this->searchstartdate, $this->searchenddate);
        }
       /* $criteria->addCondition('       file.own_customer_id=' . Yii::app()->user->master_user_customer_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.order_date DESC,t.id DESC,t.file_id DESC,t.customer_id DESC',
            ),
            'pagination' => false
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Order the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getTotals($ids) {
        $ids = implode(",", $ids);
        $connection = Yii::app()->db;
        if (!empty($ids)) {
            $command = $connection->createCommand("SELECT SUM(grand_total*exchange_rate) FROM `crm_order` where id in ($ids)");
            return $command->queryScalar();
        }
        else
            return "";
    }

    public function reportOrdersToBeDelivered() {
        $criteria = new CDbCriteria;
        $criteria->with = array('file', 'file.company', 'file.deliveredQuantity');
        if (!empty($this->customer_id))
            $condition[] = 't.customer_id="' . $this->customer_id . '"';
        if (!empty($this->country))
            $condition[] = 'company.billing_country="' . $this->country . '"';

        if (is_array($condition))
            $criteria->condition = implode(' AND ', $condition);
        if (!empty($this->searchstartdate) && !empty($this->searchenddate)) {
            $criteria->addBetweenCondition('order_date', $this->searchstartdate, $this->searchenddate);
        }
        /*$criteria->addCondition('       file.own_customer_id=' . Yii::app()->user->master_user_customer_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id . ' AND (file.current_process_status in ("O","PD","PI","CN")
                                            AND deliveredQuantity<=t.netQuantity
                                            )', 'AND');*/
        $criteria->addCondition('(file.current_process_status in ("O","PD","PI","CN") AND deliveredQuantity<=t.netQuantity)', 'AND');
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.order_date DESC,t.id DESC, t.file_id DESC,t.customer_id DESC',
            ),
            'pagination' => false
        ));
    }
    
    public function getGrand_total_bc() {
        return ($this->grand_total * $this->exchange_rate);
    }
    public function orderFiles($lead_owner_id) {
        $model = MasterFile::model()->findAll(array('condition' => 'lead_owner_id=' . $lead_owner_id));
        $criteria = new CDbCriteria;
        $criteria->with = array('file');
        foreach($model as $eachItem){
        $criteria->addCondition('t.file_id=' . $eachItem->id, 'OR');
        } 
        $criteria->addCondition('file.current_process_status="O" OR file.current_process_status="PD"', 'AND');
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.order_date ASC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 20) : false,
        ));
    }

    public static function getShipping( $file_id=0 ){ 
         return ServiceQuotes::model()->find( array( 'condition' => 'file_id='.$file_id ) )->shipping_by;
    }
    public function getCreated_user() {
        $usermodel = User::model()->findByPK($this->created_by);
        return $usermodel->fullname;
    }
    public function getItemProducts($order_id){ 
        $condition = 'order_id =  '.$order_id;
        $model = ServiceOrderItem::model()->with('product')->findAll(array('condition' => $condition, 'order' => 'product.part_number'));
        return CHtml::listData($model, 'id', 'product.part_number');
    }
}
