<?php

/**
 * This is the model class for table "{{invoice}}".
 *
 * The followings are the available columns in table '{{invoice}}':
 * @property integer $id
 * @property integer $crm_user_id
 * @property integer $file_id
 * @property string $customer_id
 * @property integer $contact_id
 * @property string $billing_address
 * @property string $shipping_address
 * @property string $shipping_conditions
 * @property string $invoice_date
 * @property string $sales_group
 * @property string $reference
 * @property string $currency
 * @property double $exchange_rate
 * @property string $payment_terms
 * @property string $shipping_by
 * @property string $lpo
 * @property string $others
 * @property double $net_amount
 * @property double $grand_total
 * @property string $notes
 * @property string $terms_and_conditions
 * @property string $remarks
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property Company $company
 * @property MasterFile $file
 */
class ServiceInvoice extends CActiveRecord {

    public $company_name;
    public $contact_name;
    public $title;
    public $received_amt;
    public $searchstartdate;
    public $searchenddate;
    public $value;
    public $country;
    public $lead_owner;
    public $lead_owner_id;
    public $lead_owner_name;
    public $credit;
    public $returned_amount;
    public $gt;
    public $ca;
    public $order_date;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{invoice}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('order_id, file_id, customer_id, contact_id, billing_address, 
                            invoice_date, sales_group, exchange_rate, payment_terms, invoice_type, lead_owner_id,terms_and_conditions 
                            ', 'required'),
//            array('delivery_ids', 'required', 'message' => 'Please choose atleast one delivery note for invoicing'),
            /* array(
              'qtn_close_date',
              'compare',
              'compareAttribute'=>'qtn_start_date',
              'operator'=>'>=',
              'allowEmpty'=>false ,
              'message'=>'{attribute} must be greater than "{compareValue}".'
              ), */
            array('crm_user_id, file_id, contact_id,invoice_type', 'numerical', 'integerOnly' => true),
            array('exchange_rate, net_amount, grand_total,tax_type,total_tax_amount', 'numerical'),
            array('customer_id', 'length', 'max' => 20),
            array('shipping_conditions, sales_group, reference, currency, payment_terms, shipping_by, lpo, others,custom_invoice_no', 'length', 'max' => 255),
            array('isActive,paid,invoice_nature', 'length', 'max' => 2),
            array('notes,remarks', 'length', 'max' => 5000),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, crm_user_id, file_id, customer_id, contact_id, billing_address, shipping_address, shipping_conditions, invoice_date, sales_group, reference, currency, exchange_rate, payment_terms, shipping_by, lpo, others, net_amount, grand_total, notes, terms_and_conditions, remarks,invoice_type, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'contact' => array(self::BELONGS_TO, 'CustomerContact', 'contact_id'),
            'leadowner' => array(self::BELONGS_TO, 'User', 'lead_owner_id'),
            'invoicetype' => array(self::BELONGS_TO, 'MasInvoiceType', 'invoice_type'),
            'order_details' => array(self::BELONGS_TO, 'Order', 'order_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'currency0' => array(self::BELONGS_TO, 'MasCurrency', 'currency'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'netSales' => array(self::STAT, 'InvoiceItem', 'invoice_id', 'join' => ' INNER JOIN {{invoice}} I ON I.id = t.invoice_id', 'select' => 'SUM(t.net_amount+t.tax_vat_amount)*I.exchange_rate'),
            'netAmount' => array(self::STAT, 'InvoiceItem', 'invoice_id', 'join' => ' INNER JOIN {{invoice}} I ON I.id = t.invoice_id', 'select' => 'SUM(t.net_amount)*I.exchange_rate'),
            'netVat' => array(self::STAT, 'InvoiceItem', 'invoice_id', 'join' => ' INNER JOIN {{invoice}} I ON I.id = t.invoice_id', 'select' => 'SUM(t.tax_vat_amount)*I.exchange_rate'),
            'netQuantity' => array(self::STAT, 'InvoiceItem', 'invoice_id', 'select' => 'SUM(quantity)'),
            'processedInvoice' => array(self::HAS_MANY, 'ReceivedInvoices', 'invoice_id'),
            'receivedAmount' => array(self::STAT, 'ReceivedInvoices', 'invoice_id', 'select' => 'SUM(received_amt)'),
            'items' => array(self::HAS_MANY, 'InvoiceItem', 'invoice_id'),
            'currencyname' => array(self::BELONGS_TO, 'MasCurrency', 'currency'),
            'paymentTerm' => array(self::BELONGS_TO, 'MasPaymentTerm', 'payment_terms'),
            'adItems' => array(self::HAS_MANY, 'InvoiceAddition', 'invoice_id'),
            'dedItems' => array(self::HAS_MANY, 'InvoiceDeduction', 'invoice_id'),
            'adTotal' => array(self::STAT, 'InvoiceAddition', 'inoice_id', 'select' => 'SUM(calculated_value)'),
            'dedTotal' => array(self::STAT, 'InvoiceDeduction', 'inoice_id', 'select' => 'SUM(calculated_value)'),
            'costTotal' => array(self::STAT, 'InvoiceItem', 'invoice_id', 'select' => 'SUM(cost_rate*quantity)'),
            'salesgroup' => array(self::BELONGS_TO, 'MasSalesGroup', 'sales_group'),
            'returned' => array(self::HAS_ONE, 'Creditnote', 'invoice_id'),
            'returnedAmount' => array(self::STAT, 'Creditnote', 'invoice_id', 'select' => 'SUM(credited_amount)'),
            'returnedVATAmount' => array(self::STAT, 'Creditnote', 'invoice_id', 'select' => 'SUM(total_tax_amount)'),
            'returnedAmountInBC' => array(self::STAT, 'Creditnote', 'invoice_id', 
                'join' => 'INNER JOIN {{invoice}} `inv` ON `inv`.`id` = `t`.`invoice_id`
                    INNER JOIN {{order}} `tc` ON `tc`.`id` = `inv`.`order_id`', 'select' => 'SUM(t.credited_amount*tc.exchange_rate)'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'crm_user_id' => 'Crm User',
            'file_id' => 'File',
            'customer_id' => 'Company',
            'contact_id' => 'Contact',
            'billing_address' => 'Billing Address',
            'shipping_address' => 'Shipping Address',
            'shipping_conditions' => 'Shipping Conditions',
            'invoice_date' => 'Invoice Date',
            'sales_group' => 'Sales Group',
            'reference' => 'Reference',
            'currency' => 'Currency',
            'exchange_rate' => 'Exchange Rate',
            'payment_terms' => 'Payment Terms',
            'shipping_by' => 'Shipping By',
            'lpo' => ' PO Ref :',
            'others' => 'Others',
            'net_amount' => 'Net Amount',
            'grand_total' => 'Grand Total',
            'notes' => 'Notes',
            'terms_and_conditions' => 'Terms And Conditions',
            'remarks' => 'Remarks',
            'invoice_type' => 'Invoice Type',
            'isActive' => 'Is Active',
            'order_id' => 'Order ID',
            'custom_invoice_no'=>'Reference Invoice No'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Invoice the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getFullinvoice(){
        return $this->invoicetype->inv_code.'-'.$this->invoice_no;
    }

    public function getCustomername(){
        return $this->customer->customer_name;
    }

    public function getFullcurrency(){
        return $this->currencyname->currency_code;
    }

    public function getTotals($ids) {
        $ids = implode(",", $ids);
        $connection = Yii::app()->db;
        if (!empty($ids)) {
            $command = $connection->createCommand("SELECT SUM(i.grand_total*i.exchange_rate)-SUM(IFNULL(c.credited_amount, 0)*i.exchange_rate) FROM `crm_invoice` i 
                join `crm_order` o
                on o.id=i.order_id
                left outer join `crm_creditnote` c 
               on i.id=c.invoice_id where i.id in ($ids)");
            return $command->queryScalar();

            /* $command = $connection->createCommand("SELECT SUM(credited_amount) FROM `crm_creditnote` where invoice_id in ($ids)");
              $total_credit_amnt = $command->queryScalar();
              return (($total_inv_amnt - $total_credit_amnt) - $this->file->order->exchange_rate); */
        }
        else
            return "";
    }

    public function calcIndividualProfit($items) {
        $costrate = true;
        foreach ($items as $eachItem) {
            if (empty($eachItem->cost_rate) || $eachItem->cost_rate == 0) {
                if ($eachItem->product->rate != 0) {
                    $eachItem->cost_rate = $eachItem->product->rate;
                    $eachItem->save();
                }
                else
                    $costrate = true;//false; //commneted for removing CRO from GP
            }
        }
        if ($costrate) {
            if ($this->file->current_process_status == "C" /*&& ($this->grand_total == $this->returnedAmount)*/) {
               $profit = '0.00';
            } else {
                $profit = $this->grandTotalLC - $this->costTotal;
            }
            return $profit;
        } else {
            return false;
        }
    }

    public function getSumOfProfits($ids = null) {
        $sumOfprofit = 0;
        if (count($ids) > 0) {
            $ids = implode(",", $ids);

            $invoices = self::model()->findAll('id in (' . $ids . ')');
            foreach ($invoices as $eachInvoice) {
                $sumOfprofit += $eachInvoice->calcIndividualProfit($eachInvoice->items);
            }
        }
        return $sumOfprofit;
    }

    public function getGrandTotalLC() {
        //return (($this->grand_total - $this->returnedAmount) * $this->file->order->exchange_rate);
        return (($this->grand_total - $this->returnedAmount) * $this->exchange_rate);
    }

    public function getGrandTotal() {
        return (($this->grand_total - $this->returnedAmount) );
    }

    public function getProfit() {
        $profit = $this->calcIndividualProfit($this->items);
        return (!$profit) ? '<span color="red">CR0</span>' : $profit;
    }

    public function getProfitInPercentage() {
        return (($this->profit / $this->costTotal) * 100);
    }

    public function getStatus() {        
        if (count($this->returned) > 0)
            return 'CN';
        else
            return 'INVOICE';
    }
    
    public function getGrand_total_bc() {
        //return ($this->grand_total * $this->file->order->exchange_rate);
        return ($this->grand_total * $this->exchange_rate);
        
    }

    public function invoiceFiles($lead_owner_id) {
        $model = MasterFile::model()->findAll(array('condition' => 'lead_owner_id=' . $lead_owner_id));
        $criteria = new CDbCriteria;
        $criteria->with = array('file');
        foreach($model as $eachItem){
        $criteria->addCondition('t.file_id=' . $eachItem->id, 'OR');
        } 
         $criteria->addCondition('(file.current_process_status="I" OR file.current_process_status="PI")', 'AND');
         
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.invoice_date ASC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 20) : false,
        ));
    }
    public function getSumOfCostTotal($ids = null) {
        $sumCostTotal = 0;
        if (count($ids) > 0) 
        {
            $ids = implode(",", $ids);
            $query="SELECT SUM(cost_rate*quantity) AS grant_cost_total FROM {{invoice_item}} WHERE invoice_id IN(".$ids.")";
           	$arr_cost_total=Yii::app()->db->createCommand($query)->queryAll();
           	$sumCostTotal = $arr_cost_total[0]['grant_cost_total'];
        }
        return $sumCostTotal;
    }
    
    public function getTotalGrandTotalLC($arr_data)
    {
    	$total_grand_total_amount	= 0;
    	foreach($arr_data as $record)
    	{
    		$order_id				=	$record->order_id;
    		$invoice_id				=	$record->id;
    		$total_invoice_amount	=	$record->grand_total;
    		$exchange_rate			=	$record->exchange_rate;
    
    		$SQL="SELECT SUM(credited_amount) FROM `crm_creditnote` WHERE invoice_id=".$invoice_id;
    		$total_credited_amount=Yii::app()->db->createCommand($SQL)->queryScalar();
    
    		if($exchange_rate <= 0)
    		{
	    		$SQL_ORDER="SELECT exchange_rate FROM `crm_order` WHERE id=".$order_id;
	    		$exchange_rate=Yii::app()->db->createCommand($SQL_ORDER)->queryScalar();
    		}
    
    		$grand_total_value = (($total_invoice_amount - $total_credited_amount) * $exchange_rate);
    		$total_grand_total_amount+=$grand_total_value;
    	}
    	return $total_grand_total_amount;
    }

    public function getGrandtotalvalue(){
        return ( round( ($this->grand_total * $this->exchange_rate), 2) );
    }

    public function generateInvoice(){
        if( $this->invoice_type > 0 ){
            $model = MasInvoiceType::model()->findByPk( $this->invoice_type );
            $this->invoice_no =  ( $model->current_serial_no > 0 ) ? $model->current_serial_no+1 : $model->start_serial_no;
            $model->current_serial_no = $this->invoice_no;
            $model->save(false);
        }
    }
    public function getCreated_user() {
        $usermodel = User::model()->findByPK($this->created_by);
        return $usermodel->fullname;
    }
}
