<?php
//modified by jisha on 15-9-18.
class CustomerController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),//,'temp_form','CompanyFieldDetails'
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetCustomerList', 'Create','SaveCustomer',
                    'GetContactList', 'CustomerContactCreate', 'SaveContact', 
                    'getDocsList','CreateDocumentForm','SaveDocForm',
                    'DeleteShippingItem','UploadCustomerDocuments','DownloadDocument','CheckTrnExistance',
                    'GetCustomerDetails','GetCustomerContactdetails','info'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     * //modified by jisha on 15-9-18.
     */
    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }
    /*
     * function to list all customers
     * modified by jisha on 15-9-18. 
     */

      public function actionGetCustomerList() {
        $model  = new Customer();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'customer_name',
            2 => 'customer_email_id',
            3 => 'nick_name',
            4 => 'customer_phone_no',
            5 => 'user.first_name',
            6 => 'country.country_name',
            7 => 't.id',
            8 => 'isActive'
        );
        $filterColumn   = $columns[$_POST['order'][0]['column']];
        $filterOrder    = $_POST['order'][0]['dir'];
        $orderBy        = $filterColumn . " " . $filterOrder;
        $condition      = '1=1';
        
        if(Yii::app()->user->authorised_user == 1 || $_POST['view_all']==1){
            $condition = 't.isActive= "Y"';
        }
        else{
            $condition = 't.isActive= "Y" AND t.lead_owner_id= "'.Yii::app()->user->id.'"';
        }
        if($_POST['customer_type']=='s')
            $condition .='AND t.id IN (SELECT customer_id FROM erp_order WHERE order_type="service")';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (CONCAT(TRIM(user.first_name),' ',TRIM(user.last_name)) LIKE '%" . $searchString . "%' OR customer_name LIKE '%" . $searchString . "%' OR  t.id LIKE '%" . $searchString . "%'  OR customer_address LIKE '%" . $searchString . "%' OR customer_phone_no LIKE '%" . $searchString . "%' OR customer_location LIKE '%" . $searchString . "%'  OR customer_email_id LIKE '%" . $searchString . "%' OR pricinggroup.pricing_group_name LIKE '%" . $searchString . "%' OR paymentmethod.payment_terms LIKE '%" . $searchString . "%' OR customer_trn_no LIKE '%" . $searchString . "%' OR country.country_name LIKE '%" . $searchString . "%')";
        }
        $count          = $model->with('pricinggroup','paymentmethod','user','country')->count(array('condition' => $condition));
        $model          = $model->with('pricinggroup','paymentmethod','user','country')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal   = $count;
        $recordsFiltered        = $count;
        $data['draw']   = $draw;
        $data['recordsTotal']   = $recordsTotal;
        $data['recordsFiltered']= $recordsFiltered;
        $rowData                = array();
        $current                = strtotime(date('y-m-d'));
        function getFirstcontact($id){
            return CustomerContact::model()->find( array( 'condition' => 'customer_id='.$id ) )->person_name;
        }
        foreach ($model as $row)
        {
            if($_POST['customer_type']=='s')
                $SQL ='SELECT MAX(`order_date`) AS last_order_date FROM `erp_order` WHERE customer_id='.$row['id'].' AND order_type="service"';
            else {
                $SQL ='SELECT MAX(`order_date`) AS last_order_date FROM `erp_order` WHERE customer_id='.$row['id'];
            }
            $arr_last_order_date = Yii::app()->db->createCommand($SQL)->queryRow();
            //print_r($arr_last_order_date);
            $last_order_date = $arr_last_order_date['last_order_date'];
            //echo $last_order_date;
            $colour=0;
            $own_flag = 0;
            if($row['lead_owner_id']==Yii::app()->user->id || Yii::app()->user->authorised_user == 1){
                $own_flag=1;
            }
            $rowData[]  = array($row['id'], substr($row['customer_name'], 0, 45),$row['customer_location'],$row['customer_phone_no'],$row['customer_trn_no'],$row['user']['Fullname'],'<div title="'.$row['paymentmethod']['payment_terms'].'">'.$row['paymentmethod']['payment_terms'].'</div>',(!empty($last_order_date))?date('d/m/Y',strtotime($last_order_date)):"",$colour,$row['isActive'],$row['isCompetitor'],$own_flag);
            $m++;
        } 
        $data['data'] = $rowData;
        echo json_encode($data);
    }    
}
