<?php
$form = $this->beginWidget('CActiveForm', [
    'id' => 'service-mas-customer-machines-return-form',
    'enableAjaxValidation' => true,
    'htmlOptions' => [
        'class' => 'form-horizontal',
        'enctype' => 'multipart/form-data',
    ],
]);
?>

<ul class="clearfix form-ul material">
    <?php
    $customer_name = '';
    if ($model->customer_id > 0) {
        $customer_name = $model->customer->customer_name;
        echo $form->hiddenField($model, 'id');
        echo $form->hiddenField($model, 'lead_owner_id');
    }
    ?>

    <!-- Customer -->
    <li class="col-sm-4">
        <?php echo $form->textField($model, 'customer_name', [
            'class' => 'tooltipster',
            'title' => 'Please choose a customer',
            'data-label' => 'Customer <span style="color:red">*</span>',
            'onkeyup' => 'autoCompleteMachineCustomer(this.id,"Machine");',
            'value' => $customer_name,
        ]); ?>
        <?php echo $form->hiddenField($model, 'customer_id'); ?>
    </li>

    <!-- Lead Owner (Hidden Multi-Select) -->
    <li class="col-sm-4 hidden">
        <?php echo $form->dropDownList($model, 'lead_owner_id', User::getUser(), [
            'class' => 'tooltipster',
            'title' => 'Returning Lead Owner',
            'data-label' => 'Returning Lead Owner <span style="color:red">*</span>',
            'data-search' => true,
            'multiple' => true,
            'id' => 'ServiceMasCustomerMachines_lead_owner_id',
        ]); ?>
    </li>

    <!-- Customer Outlet Location -->
    <div id="div_customershippimg">
        <li class="col-sm-4">
            <?php
            echo $form->dropDownList(
                $model,
                'customer_shipping_id',
                ($model->customer_id > 0) ? CustomerOutletLocation::getShippingLocation($model->customer_id) : [],
                [
                    'data-label' => 'Outlet Location',
                    'prompt' => 'Select',
                    'id' => 'ServiceMasCustomerMachines_customer_shipping_id',
                ]
            );
            ?>
        </li>
    </div>

    <!-- Machine Table -->
    <li class="col-sm-12">
        <div id="div_customerMachineList"></div>
    </li>
</ul>

<!-- Footer Buttons -->
<div class="modal-footer">
    <div class="text-center mt-3" style="float: right;">
        <?php echo CHtml::ajaxSubmitButton(
            'Return',
            Yii::app()->createUrl('sales/servicecustomermachine/ReturnMachineMultiple'),
            [
                'type' => 'POST',
                'dataType' => 'json',
                'success' => 'function(response){
                    if(response.status == "success"){
                        t8.success(response.message);
                        window.location.reload();
                    } else {
                        t8.error(response.message);
                    }
                }',
            ],
            ['class' => 'btn btn-primary']
        ); ?>
    </div>
</div>

<?php $this->endWidget(); ?>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("returnMachineScripts", "
function autoCompleteMachineCustomer(field_id, frm) {
    var url = '" . Yii::app()->createUrl('customer/GetCustomerDetails') . "' + '&frm=' + frm;

    $('#' + field_id).autocomplete({
        minLength: 1,
        source: function (request, response) {
            autoCompleteSource(request, response, url);
        },
        select: function (event, ui) {
            event.preventDefault();

            var customerId = ui.item.value;
            $('#ServiceMasCustomerMachines_customer_id').val(customerId);
            $('#' + field_id).val(ui.item.label);

            // Load outlet locations for the selected customer
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: '" . Yii::app()->createUrl('sales/Servicecustomermachine/getCustomerShippingdetailsReturn') . "',
                data: { id: customerId },
                success: function (data) {
                    $('#div_customershippimg').html(data.dtship);

                    // Optional: trigger loadReturnMachines automatically if first outlet is selected
                    if ($('#ServiceMasCustomerMachines_customer_shipping_id').val()) {
                        loadReturnMachines();
                    }
                }
            });

            // Load returnable machines immediately
            loadReturnMachines();
        }
    });

    // Clear customer_id if input is cleared manually
    $('#' + field_id).on('change keyup', function() {
        if ($(this).val() === '') {
            $('#ServiceMasCustomerMachines_customer_id').val('');
            $('#div_customerMachineList').html('');
            $('#div_customershippimg').html('');
        }
    });
}

// Load returnable machines based on selected customer
function loadReturnMachines() {
    var customerId = $('#ServiceMasCustomerMachines_customer_id').val();
    var customer_shipping_id = $('#ServiceMasCustomerMachines_customer_shipping_id').val();

    if (!customerId) {
        $('#div_customerMachineList').html('');
        return;
    }

    $.ajax({
        type: 'POST',
        url: '" . Yii::app()->createUrl('sales/servicecustomermachine/getReturnMachines') . "',
        data: { 'ServiceMasCustomerMachines[customer_id]': customerId,'customer_shipping_id' : customer_shipping_id },
        beforeSend: function() {
            $('#div_customerMachineList').html('<div class=\"text-center p-3\"><i class=\"fa fa-spinner fa-spin\"></i> Loading...</div>');
        },
        success: function(response) {
            $('#div_customerMachineList').html(response);
        },
        error: function() {
            t8.error('Failed to load returnable machines.');
            $('#div_customerMachineList').html('');
        }
    });
}

// Trigger loadReturnMachines when outlet location changes
$(document).on('change', '#ServiceMasCustomerMachines_customer_shipping_id', function() {
    loadReturnMachines();
});

// Optional: Enhance multi-select dropdown with Select2
$(document).ready(function() {
    if ($.fn.select2) {
        $('#ServiceMasCustomerMachines_lead_owner_id').select2({
            placeholder: 'Select one or more Lead Owners',
            allowClear: true,
            width: '100%'
        });
    }
});
", CClientScript::POS_END);
?>
