<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>
<script>
    $(document).ready(function () {
        var table_id = "#tbl_schedule";
        var table = $(table_id).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,        
           
            order: [[0, "DESC"]],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('sales/scheduleMaintenance/Getlist') ?>",
                type: "POST",
                cache: false,
                data: function (d) {
                    d.customer_id = $("#customer").val();
                }
            }, 
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

                AddContextMenu(nRow, aData);

            },
            serverSide: true,
            fixedColumns: true
        });
    });
    
    function AddContextMenu(row, datas) {
        const items = {};

            items["edit"] = {
                name: "Edit",
                icon: "edit",
                accesskey: "e",
                callback: function () {
                    //loadPopupModal("rack/create&id=" + datas[5].id, datas[5].code, "lg");
                }
            }
    }
</script>
<section class="panel" >
    <header class="panel-heading clearfix panel-theame">
      <i class="material-icons"></i> 
        <div class="col-sm-1 pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['schedule_maintenance_add']) || Yii::app()->user->authorised_user == '1') { ?>                    
                <button class="btn btn-sm btn-theme"  onclick="printScheduleMaintenanceReportPDF()"><i class="fa fa-file-pdf-o"></i> PDF</button>
                <?php } ?>
        </div>

        <i class="material-icons"></i> Maintenance Schedule
        <div class="col-sm-1 pull-right">
                <?php if (isset(Yii::app()->user->havePermissionOn['schedule_maintenance_add']) || Yii::app()->user->authorised_user == '1') { ?>                    
                    <button class="btn btn-sm btn-theme" id="add_popup" onclick="scheduleMaintanace()"><i class="fa fa-plus"></i> Schedule</button>
                <?php } ?>
            </div>
           
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_schedule" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>SI No</th>
                        <th>Job No</th>
                        <th>File No</th>
                        <th>Order No</th>
                        <th>Customer</th>
                         <th>Outlet</th>
                         <th>Type</th>
<!--                         <th>Last Service</th>
 -->
<!--                         <th>Active Request</th>
 -->
<!--                         <th>Phone</th>
 -->
<!--                         <th>Email</th>
 -->
                         <th>Planned Date</th>
                         <!--th>Machine Count</th-->
                        <th>Action</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>
 <?php 
$cs = Yii::app()->getClientScript();
$cs->registerScript("scheduleMaintanace", "function scheduleMaintanace(id){
    var r = confirm('Are you sure you want to schedule service?');
    if(r==true)
    {
        jQuery.ajax({
            'data' :{'contact_id':id},
            'dataType' : 'json',
            'type':'post',
            'url': '" . Yii::app()->createUrl('sales/scheduleMaintenance/ScheduleRequest') . "',
            'success': function(data) {
                if(data.status=='success'){  
                    reloadTable('#tbl_schedule');
                      t8.success(data.count+' Schedules Saved Successfully!');
                  } else {
                          t8.error('Already Scheduled'); 
                      
                  } 
            }
        });
    }

}", CClientScript::POS_HEAD); 

$cs->registerScript("printScheduleMaintenanceReportPDF", "function printScheduleMaintenanceReportPDF(){

    window.open($('#liveSite').val()+'index.php?r=reports/printScheduleMaintenanceReportPDF', '_blank');

}", CClientScript::POS_HEAD);

?>
