<table class="table table-hover table-bordered personal-task" id="tbl_repair_request_2">
    <thead style="background:none;color:black !important;">
        <tr>
            <th style="width:3%;">No</th>
            <th style="width:10%;">Serial No.</th>
            <th style="width:10%;">Machine</th>
            <th style="width:10%;">Description</th>
            <th style="width:10%;">Location</th>
            <th style="width:10%;" class="new_gragrance hidden">New Fragrance</th>

            <th style="width:14%; display: none;">
                Service
                <?php echo CHtml::dropDownList('selected_list', '', MasServices::getAll(), [
                    'onchange' => 'js:changeStatus(this.value)'
                ]); ?>
            </th>
            <th style="width:25%;">Remark</th>
            <th style="width:2%;" class="text-center">
                <a href="javascript:void(0);" class="btn btn-success btn-sm"
                    onclick="addMachineRow($('#tbl_repair_request_2'))">
                    <i class="fa fa-plus"></i>
                </a>
            </th>
        </tr>
    </thead>

    <tbody>
        <?php $m = 1; ?>
        <?php foreach ($modelmachine as $i => $eachmachine): ?>
            <tr>
                <!-- Serial No -->
                <td><?php
                echo CHtml::checkBox(
                    "SalesRepairRequestItem[{$i}][selected]", // name for tabular form
                    false, // default unchecked
                    [
                        'value' => $eachmachine->id ?? $i,  // checkbox value (e.g., machine ID or index)
                        'class' => 'machine-check',         // optional class for JS use
                        'data-label' => "Select Machine #{$m}"
                    ]
                );
                ?>
                    <label><?php echo $m; ?></label>
                </td>

                <!-- Barcode / Machine Name -->
                <td>
                    <?php
                    echo CHtml::activeTextField(
                        $modelrepair,
                        "[$i]machine_name",
                        [
                            'class' => 'form-control go text-left',
                            'value' => $eachmachine->serial_no,
                            'readonly' => true
                        ]
                    );

                    echo CHtml::activeHiddenField(
                        $modelrepair,
                        "[$i]machine_id",
                        ['value' => $eachmachine->product_id]
                    );

                    /*echo CHtml::activeHiddenField(
                        $modelrepair,
                        "[$i]stock_ledger_id",
                        ['value' => $eachmachine->stock_ledger_id]
                    );*/
                    echo CHtml::activeHiddenField(
                        $modelrepair,
                        "[$i]header_id",
                        ['value' => $eachmachine->goods_issue_id]
                    );

                    echo CHtml::activeHiddenField(
                        $modelrepair,
                        "[$i]serial_no",
                        ['value' => $eachmachine->serial_no]
                    );



                    ?>
                </td>
                <!-- part number -->

                <td>
                    <?php
                    echo CHtml::activeTextField(
                        $modelrepair,
                        "[$i]description",
                        [
                            'class' => 'form-control',
                            'value' => $eachmachine->product_name,
                            'readonly' => true
                        ]
                    );
                    ?>
                </td>

                <!-- Description -->
                <td>
                    <?php
                    echo CHtml::activeTextField(
                        $modelrepair,
                        "[$i]description",
                        [
                            'class' => 'form-control',
                            'value' => $eachmachine->description,
                            'readonly' => true
                        ]
                    );
                    ?>
                </td>

                <!-- Location -->
                <td>
                    <?php
                    echo CHtml::activeTextField(
                        $modelrepair,
                        "[$i]location",
                        [
                            'class' => 'form-control',
                            'value' => $eachmachine->location->location_name,
                            'readonly' => true
                        ]
                    );
                    echo CHtml::activeHiddenField(
                        $modelrepair,
                        "[$i]location_id",
                        ['value' => $eachmachine->location_id]
                    );
                    ?>

                </td>

                <!-- New Fragrance -->
                <td class="add_fragrance hidden">
                    <?php
                    $disabled = ($eachmachine->service_id != 7);
                    $fragranceArray = Store::getFragranceOils();//MasFragrance::getFragrance();
                    echo CHtml::activeDropDownList($modelrepair, "[$i]new_fragrance_id", $fragranceArray, [
                        'class' => 'form-control fragrance_type_ddl',
                        'empty' => 'Select',
                        'disabled' => $disabled
                    ]);
                    ?>
                </td>

                <!-- Service -->
                <td class="hidden">
                    <?php
                    echo CHtml::activeDropDownList(
                        $modelrepair,
                        "[$i]service_id",
                        MasServices::getAll(),
                        [
                            'class' => 'form-control go service_type_ddl',
                            'prompt' => '--Select--',
                            'onchange' => 'ServiceChange($("#tbl_repair_request_2"), this, this.id)'
                        ]
                    );
                    ?>
                </td>

                <!-- Remark -->
                <td>
                    <?php
                    echo CHtml::activeTextArea(
                        $modelrepair,
                        "[$i]remark",
                        [
                            'class' => 'form-control',
                            'rows' => 3,
                            'placeholder' => 'Enter remarks (if any)'
                        ]
                    );
                    ?>
                </td>

                <!-- Remove Button -->
                <td class="text-center">
                    <a href="javascript:void(0);" class="btn btn-danger btn-sm" id="<?php echo $i; ?>"
                        onclick="removeMachineRow($('#tbl_repair_request_2'), this, this.id)">
                        <i class="fa fa-times"></i>
                    </a>
                </td>
            </tr>
            <?php $m++; ?>
        <?php endforeach; ?>
    </tbody>
</table>


<?php
// Prepare service options for JS template
$serviceOptions = '';
foreach (MasServices::getAll() as $key => $val) {
    $serviceOptions .= "<option value='$key'>$val</option>";
}
?>

<script type="text/javascript">
    function addMachineRow($table) {
        var $tbody = $table.find('tbody');
        var rowCount = $tbody.find('tr').length;
        var newIndex = rowCount;

        var newRow = `
        <tr>
            <td><label>${newIndex + 1}</label></td>
            <td>
                <input type="text" id="SalesRepairRequestItem_${newIndex}_machine_name" 
                       name="SalesRepairRequestItem[${newIndex}][machine_name]" 
                       class="form-control" onkeyup="autoCompleteProduct(this.id)">
                <input type="hidden" id="SalesRepairRequestItem_${newIndex}_machine_id" 
                       name="SalesRepairRequestItem[${newIndex}][machine_id]">
            </td>
            <td>
                <input type="text" id="SalesRepairRequestItem_${newIndex}_description" 
                       name="SalesRepairRequestItem[${newIndex}][description]" 
                       class="form-control">
            </td>
            <td>
                <select id="SalesRepairRequestItem_${newIndex}_location_id" 
                        name="SalesRepairRequestItem[${newIndex}][location_id]" 
                        class="form-control">
                    <option value="">Loading...</option>
                </select>
            </td>
            <td>
                <select id="SalesRepairRequestItem_${newIndex}_service_id" 
                        name="SalesRepairRequestItem[${newIndex}][service_id]" 
                        class="form-control service_type_ddl"
                        onchange="ServiceChange($('#tbl_repair_request_2'), this, this.id)">
                    <?php echo $serviceOptions; ?>
                </select>
            </td>
            <td>
                <textarea id="SalesRepairRequestItem_${newIndex}_remark" 
                          name="SalesRepairRequestItem[${newIndex}][remark]" 
                          class="form-control" rows="3"></textarea>
            </td>
            <td class="text-center">
                <a href="javascript:void(0);" class="btn btn-danger btn-sm" id="${newIndex}"
                   onclick="removeMachineRow($('#tbl_repair_request_2'), this, this.id)" title="Remove">
                   <i class="fa fa-times"></i>
                </a>
            </td>
        </tr>
    `;

        $tbody.append(newRow);

        // Load location options via AJAX
        var customer = $('#SaleRepairRequest_customer_id').val();
        var outlet_id = $('#SaleRepairRequest_customer_shipping_id').val();

        $.ajax({
            url: '<?php echo Yii::app()->createUrl("sales/schedule/GetLocationdetailsAjax"); ?>',
            type: 'GET',
            data: { customer: customer, outlet_id: outlet_id },
            dataType: 'json',
            success: function (data) {
                console.log(newIndex);
                console.log(`SalesRepairRequestItem_${newIndex}_location_id`);


                var $locationSelect = $tbody.find(`#SalesRepairRequestItem_${newIndex}_location_id`);
                $locationSelect.empty().append('<option value="">Select Location</option>');
                $.each(data, function (key, val) {
                    $locationSelect.append(`<option value="${key}">${val}</option>`);
                });
            },
            error: function () {
                alert('Failed to load locations.');
            }
        });
    }

    // Remove row function
    function removeMachineRow($table, elem, id) {
        $(elem).closest('tr').remove();
        // Re-number rows
        $table.find('tbody tr').each(function (index) {
            $(this).find('td:first label').text(index + 1);
        });
    }

    // Service change function
    function ServiceChange(jQtable, evt, field_id) {
        var arr_fields = field_id.split('_');
        var row_field = arr_fields[1];
        var service_id = $('#SalesRepairRequestItem_' + row_field + '_service_id').val();

        if (service_id != 7) {
            $('#SalesRepairRequestItem_' + row_field + '_new_fragrance_id').val('');
            $('#SalesRepairRequestItem_' + row_field + '_new_fragrance_id').prop('disabled', true);
        } else {
            $('#SalesRepairRequestItem_' + row_field + '_new_fragrance_id').prop('disabled', false);
        }
    }
</script>